package com.efuture.ocp.common.rest;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

import org.springframework.util.StringUtils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.util.SpringBeanFactory;

public class ServiceMethodReflect
{
    private enum ParamMode { SESSION_JSON,SESSION_STRING,SESSION_STRING_LIST,STRING,VOID } ;
	
	public ServiceMethodReflect()
	{
		
	}

	public Object executeClassMethod(String method,ServiceSession sessionobj,String param) throws Exception
	{
		try
		{
			JSONObject jsonparam = null;

			// 创建服务组件
			StringBuffer component = new StringBuffer();
			StringBuffer componentmethod = new StringBuffer();
			Object obj = createClassObject(method,component,componentmethod);
			if (obj == null) throw new Exception("method instance invalid");
			String methodname = componentmethod.toString();
			
			// 根据参数优先反射匹配的方法
			Object retobj = null; 
			StringBuffer sb = new StringBuffer();
			if (sessionobj != null)
			{
				// ServiceSession,String
                retobj = invoke(ParamMode.SESSION_STRING,sb,obj,methodname,new Object[]{ sessionobj,param });
                if (sb.length() > 0) return retobj;
                
                // ServiceSession,JSONObject
                if (jsonparam == null) { try { jsonparam = JSON.parseObject(param); } catch(Exception ex) { } }
                retobj = invoke(ParamMode.SESSION_JSON,sb,obj,methodname,new Object[]{ sessionobj,jsonparam });
                if (sb.length() > 0) return retobj;
                
                // String
                retobj = invoke(ParamMode.STRING,sb,obj,methodname,new Object[]{ param });
                if (sb.length() > 0) { return retobj; }
				
				// void
				retobj = invoke(ParamMode.VOID,sb,obj,methodname,null);
				if (sb.length() > 0) { return retobj; }
			}
			else
			{
				if (param != null && !param.equals(""))
				{
					// String
					retobj = invoke(ParamMode.STRING,sb,obj,methodname,new Object[]{ param });
					if (sb.length() > 0) { return retobj; }
					
					// void
					retobj = invoke(ParamMode.VOID,sb,obj,methodname,null);
					if (sb.length() > 0) { return retobj; }
				}
				else
				{
					// void
					retobj = invoke(ParamMode.VOID,sb,obj,methodname,null);
					if (sb.length() > 0) { return retobj; }
					
					// String
					retobj = invoke(ParamMode.STRING,sb,obj,methodname,new Object[]{ param });
					if (sb.length() > 0) { return retobj; }
				}
				
				// ServiceSession,String
				retobj = invoke(ParamMode.SESSION_STRING,sb,obj,methodname,new Object[]{ null,param });
				if (sb.length() > 0) { return retobj; }
				
				// ServiceSession,JSONObject
				if (jsonparam == null) { try { jsonparam = JSON.parseObject(param); } catch(Exception ex) { } }
				retobj = invoke(ParamMode.SESSION_JSON,sb,obj,methodname,new Object[]{ null,jsonparam });
				if (sb.length() > 0) { return retobj; }
			}
			
			throw new Exception(component+"."+methodname+" method not found!");
		}
		catch (Exception ex)
		{
		    if (ex instanceof InvocationTargetException)
		    {
		        InvocationTargetException e = (InvocationTargetException) ex;
		        if (e.getTargetException() != null)
		        {
		            if (e.getTargetException() instanceof Exception)
		            {
		                throw (Exception)e.getTargetException();
		            }
		            else
		            {
		                throw new Exception(e.getTargetException().getMessage());
		            }
		        }
		        else throw ex;
		    }
		    else
		    {
		        throw ex;
		    }
		}
	}
	
    public Object executeClassMethodForListParam(String method, ServiceSession sessionobj, String param,List<?> list) throws Exception
    {
        try
        {
            // 创建服务组件
            StringBuffer component = new StringBuffer();
            StringBuffer componentmethod = new StringBuffer();
            Object obj = createClassObject(method, component, componentmethod);
            if (obj == null) throw new Exception("method instance invalid");
            String methodname = componentmethod.toString();

            // 根据参数优先反射匹配的方法
            Object retobj = null;
            StringBuffer sb = new StringBuffer();

            // ServiceSession,List
            retobj = invoke(ParamMode.SESSION_STRING_LIST, sb, obj, methodname, new Object[] { sessionobj, param,list });
            if (sb.length() > 0) return retobj;

            // void
            retobj = invoke(ParamMode.VOID, sb, obj, methodname, null);
            if (sb.length() > 0) { return retobj; }

            throw new Exception(component + "." + methodname + " method not found!");
        }
        catch (Exception ex)
        {
            if (ex instanceof InvocationTargetException)
            {
                InvocationTargetException e = (InvocationTargetException) ex;
                if (e.getTargetException() != null) throw (Exception)e.getTargetException();
                else throw ex;
            }
            else
            {
                throw ex;
            }
        }
    }
	   
    private Object createClassObject(String servicemethod,StringBuffer component,StringBuffer methodname) throws Exception
    {
        // 分解组件名和方法名
        if (StringUtils.isEmpty(servicemethod)) throw new Exception("method name is empty");
        int lastdot = servicemethod.lastIndexOf(".");
        if (lastdot < 0) throw new Exception("method name invalid");
        component.append(servicemethod.substring(0, lastdot));
        methodname.append(servicemethod.substring(lastdot + 1));

        // 反射类对象
        Object obj;
        Class<?> cl;
        try
        {
            // 通过Spring工厂创建
            obj = SpringBeanFactory.getBean(component.toString());
        }
        catch (Exception ex)
        {
            // 通过类名创建
            cl = Class.forName(component.toString());
            obj = cl.newInstance();
        }
        
        return obj;
    }

	@SuppressWarnings({ "rawtypes", "unchecked" })
	private Object invoke(ParamMode mode,StringBuffer find,Object objinst,String methodname,Object[] params) throws Exception
	{
		Method classmethod = null;
		try
		{
	        Class cl = objinst.getClass();
	        
	        switch(mode)
	        {
    	        case SESSION_JSON:
    	            classmethod = cl.getMethod(methodname, new java.lang.Class[]{ ServiceSession.class,JSONObject.class });
    	            break;
    	        case SESSION_STRING:
    	            classmethod = cl.getMethod(methodname, new java.lang.Class[]{ ServiceSession.class,String.class });
    	            break;
    	        case SESSION_STRING_LIST:
    	            classmethod = cl.getMethod(methodname, new java.lang.Class[]{ ServiceSession.class,String.class,List.class });
    	            break;
    	        case STRING:
    	            classmethod = cl.getMethod(methodname, new java.lang.Class[]{ String.class });
    	            break;
    	        default:
    	            classmethod = cl.getMethod(methodname);
	        }
		}
		catch(Exception ex)
		{
			// 找不到匹配方法
		}
				
		find.delete(0, find.length());
		if (classmethod != null) 
		{
			find.append("find");
			if (params != null) return classmethod.invoke(objinst, params);
			else return classmethod.invoke(objinst);
		}
		return null;
	}
}
