/**
 * Copyright (C), 2007-2014, eFuture 北京富基融通科技有限公司
 * FileName:	ServiceVersion.java
 * Author:		亮
 * Date:		2014-10-31 上午9:42:23
 * Description:	
 * History:
 * <author>		<time>			<version>		<description>
 * 
 */
package com.efuture.ocp.common.rest;

import java.util.HashMap;
import java.util.Map;

import org.apache.log4j.Logger;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.util.SpringBeanFactory;

/**
 * @author		亮
 * @description	
 * 
 */
public class ServiceVersion
{
    Logger logger = Logger.getLogger(ServiceVersion.class);
    boolean logstatus;
    
    String logformat;

	public String getLogFormat() {
		if (logformat == null) {
			return "default";
		}
		return logformat;
	}

	public void setLogFormat(String logFormat) {
		this.logformat = logFormat;
	}
	String ver;    
    public ServiceVersion(String version, String openlog)
    {
    	//ServiceVersion(version,openlog,"default");
    	ver = version;
        logstatus = openlog.equalsIgnoreCase("y");
        setLogFormat("default");
    }
    
    public ServiceVersion(String version, String openlog,String logformat)
    {
        ver = version;
        logstatus = openlog.equalsIgnoreCase("y");
        setLogFormat(logformat);
    }
    public ServiceVersion(String version)
    {
        ver = version;
    }
    
    public String getVer()
    {
        return ver;
    }

    public boolean isLogstatus()
    {
        return logstatus;
    }

    public void setLogstatus(boolean logstatus)
    {
        this.logstatus = logstatus;
    }

    public void debugLog(Object message)
    {
        if (logstatus) logger.info(message);
    }
    
    Map<String,JSONObject> elapsed = new HashMap<String,JSONObject>();
    long[] elapsedStep = new long[]{200,300,500,1000,3000,5000};
    
    public Map<String, JSONObject> getElapsed()
    {
        return elapsed;
    }
    public void setElapsed(Map<String, JSONObject> elapsed)
    {
        this.elapsed = elapsed;
    }
    
    public synchronized void writeElapsed(String key,long time)
    {
        try
        {
        	// 0耗时的不记录
        	if (time <= 0) return;
        	
            // 总次数,总耗时,平均耗时
        	JSONObject json = elapsed.get(key);
            if (json == null)
            {
                json = new JSONObject();
                json.put("num", 1);
                json.put("tot", time);
                json.put("avg", time);
                this.elapsed.put(key,json);
            }
            else
            {
                json.put("num", json.getLong("num")+1);                
                json.put("tot", json.getLong("tot")+time);
                json.put("avg", json.getLong("tot") / json.getLong("num"));
            }
            
            // 分档耗时
            boolean exist = false;
            for (int i=0;i<elapsedStep.length;i++)
            {
                if (time <= elapsedStep[i])
                {
                    String str = (i > 0 ? elapsedStep[i-1] + "-" + elapsedStep[i] : "<=" + elapsedStep[i]);
                    if (json.containsKey(str)) json.put(str, json.getLong(str)+1);
                    else json.put(str, 1);
                    
                    exist = true;
                    break;
                }
            }
            if (!exist)
            {
                String str = ">" + elapsedStep[elapsedStep.length-1];
                if (json.containsKey(str)) json.put(str, json.getLong(str)+1);
                else json.put(str, 1);
            }
            
            //System.out.println(json.toJSONString());
        }
        catch(Exception ex)
        {
        }
    }
    
    public static ServiceVersion getInstance()
    {
        ServiceVersion sv = SpringBeanFactory.getBean("ServiceVersion",ServiceVersion.class);
        return sv;
    }
    
    public static String getVersion()
    {
        return getInstance().getVer();
    }
    
}
