/**
 * Copyright (C), 2007-2014, eFuture 北京富基融通科技有限公司
 * FileName:	CacheUtils.java
 * Author:		亮
 * Date:		2014-9-16 下午4:43:00
 * Description:	
 * History:
 * <author>		<time>			<version>		<description>
 * 
 */
package com.efuture.ocp.common.util;

import java.util.UUID;

import net.rubyeye.xmemcached.GetsResponse;



/**
 * @author		亮
 * @description	
 * 
 */
public abstract class CacheUtils
{
    public interface CacheTimeOut
    {
    	final int Min  = 300;
        final int HalfHour = 1800;
        final int Hour = 3600;
        final int Day = 86400;
    }
    
    // 设置数据(timeout单位秒,0=长期)
    public abstract String putData(String key,Object object,int timeout);
    
    // 得到数据
    public abstract Object getData(String key);
    
    // 删除数据
    public abstract boolean deleteData(String key);
    
    // 获取数据的版本号
    public abstract long getCasValue(String key) ;
    
    // 获取数据的版本号
    public abstract GetsResponse getCasData(String key) ;
    
    // 根据版本号更新
    public abstract boolean putbyCas(String key,Object object,int timeout,long casvalue);
    

    //////////////////////
    public String putData(Object object)
    {
        return putData(object,CacheTimeOut.Day);
    }
    
    public String putData(Object object,int timeout)
    {
        //String key = MD5Utils.MD5(String.valueOf(UniqueID.getUniqueID()));
        String key = UUID.randomUUID().toString().replace("-", "").toUpperCase();
        return getCacheUtils().putData(key,object, timeout);
    }
    
    ///////////////////////////////////
    public static CacheUtils getCacheUtils()
    {
        return SpringBeanFactory.getBean("CacheUtils",CacheUtils.class);
    }

	public boolean AddData(String key, Object object, int timeout) {
		// TODO Auto-generated method stub
		return false;
	}

	

}

