package com.efuture.ocp.common.util;

import java.math.BigDecimal;
import java.util.Map;

public class MapUtils {

	public static String getString(Map map, String key, String defval, boolean check) {
		try {
			if (map.containsKey(key) && map.get(key) != null) {
				return map.get(key).toString();
			} else {
				if (check)
					throw new Exception("Key " + key + " in Map is Null");
				else
					return defval;
			}
		} catch (Exception ex) {
			return defval;
		}
	}

	public static String getString(Map map, String key, String defval) {
		return getString(map, key, defval, false);
	}

	public static String getString(Map map, String key) {
		return getString(map, key, "");
	}

	public static double getDouble(Map map, String key, double defval) {
		try {
			if (map.containsKey(key) && map.get(key) != null) {
				return Double.parseDouble(map.get(key).toString());
			} else {
				return defval;
			}
		} catch (Exception ex) {
			return defval;
		}
	}

	public static double getDouble(Map map, String key) {
		return getDouble(map, key, 0);
	}

	public static int getInteger(Map map, String key, int defval) {
		try {
			if (map.containsKey(key) && map.get(key) != null) {
				return Integer.parseInt(map.get(key).toString());
			} else {
				return defval;
			}
		} catch (Exception ex) {
			return defval;
		}
	}

	public static int getInteger(Map map, String key) {
		return getInteger(map, key, 0);
	}
	
	public static long getLongValue(Map map, String key, long defval) {
		try {
			if (map.containsKey(key) && map.get(key) != null) {
				return Long.parseLong(map.get(key).toString());
			} else {
				return defval;
			}
		} catch (Exception ex) {
			return defval;
		}
	}

	public static long getLongValue(Map map, String key) {
		return getLongValue(map, key, 0L);
	}
	

	public static BigDecimal getBigDecimal(Map map, String key, BigDecimal defval) {
		try {
			if (map.containsKey(key) && map.get(key) != null) {
				//return BigDecimal.valueOf(Double.valueOf(map.get(key).toString()));
				return new BigDecimal(map.get(key).toString());
			} else {
				return defval;
			}
		} catch (Exception ex) {
			return defval;
		}
	}

	public static BigDecimal getBigDecimal(Map map, String key) {
		return getBigDecimal(map, key, new BigDecimal(0));
	}
}
