/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.entity.FileImportObject;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.rest.ServiceLogs;
import com.efuture.ocp.common.util.ImpRowCallbackHandler;
import com.efuture.ocp.common.util.IniReader;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.ocp.common.util.WebPathUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public class ExcelUtils {
    public static final String XLS = "XLS";
    public static final String XLSX = "XLSX";
    public static final String DATATYPE_STRING = "S";
    public static final String DATATYPE_NUMBER = "N";
    public static final String DATATYPE_DATE = "D";
    public static final IniReader impconfig = new IniReader();
    public static final String fieldLimitChar = "\t";
    public static final String fieldLimit = ",";
    @Autowired
    private static Environment env;

    public static boolean isNumeric(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONArray TXTtoJSONArray(InputStream is, String flds, long maxrow, String custtype) throws Exception {
        JSONArray array = new JSONArray();
        String[] fields = null;
        if (!StringUtils.isEmpty((Object)flds)) {
            fields = flds.split(fieldLimit);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, "gbk"));
        String line_record = null;
        try {
            while ((line_record = reader.readLine()) != null) {
                JSONObject json = new JSONObject();
                String[] fields1 = line_record.split(fieldLimitChar);
                for (int celNum = 0; celNum < fields1.length; ++celNum) {
                    String colkey;
                    String string = colkey = fields != null ? fields[celNum] : String.valueOf(celNum);
                    if (colkey.equals("birthday")) {
                        json.put(colkey, ExcelUtils.formatval(fields1[celNum], DATATYPE_DATE));
                        continue;
                    }
                    json.put(colkey, (Object)fields1[celNum]);
                }
                json.put("custtype", (Object)custtype);
                array.add((Object)json);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (maxrow > 0L && (long)array.size() >= maxrow) {
            throw new ServiceException("10000", "limit rows {0},excel rows {1}", maxrow, array.size());
        }
        return array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONArray TXTtoJSONAray(InputStream is, String flds, long maxrow, String custtype) throws Exception {
        JSONArray array = new JSONArray();
        String[] fields = null;
        if (!StringUtils.isEmpty((Object)flds)) {
            fields = flds.split(fieldLimit);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, "utf-8"));
        String line_record = null;
        try {
            while ((line_record = reader.readLine()) != null) {
                JSONObject json = new JSONObject();
                String[] fields1 = line_record.split(fieldLimit);
                for (int celNum = 0; celNum < fields1.length; ++celNum) {
                    String colkey = fields != null ? fields[celNum] : String.valueOf(celNum);
                    json.put(colkey, (Object)fields1[celNum]);
                }
                array.add((Object)json);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (maxrow > 0L && (long)array.size() >= maxrow) {
            throw new ServiceException("10000", "limit rows {0},excel rows {1}", maxrow, array.size());
        }
        return array;
    }

    public static JSONArray XLStoJSONArray(InputStream is, String flds, long maxrow) throws Exception {
        JSONArray array = new JSONArray();
        String[] fields = null;
        if (!StringUtils.isEmpty((Object)flds)) {
            fields = flds.split(fieldLimit);
        }
        HSSFWorkbook hssfWorkbook = new HSSFWorkbook(is);
        for (int numSheet = 0; numSheet < hssfWorkbook.getNumberOfSheets(); ++numSheet) {
            HSSFRow hssfRow;
            HSSFSheet hssfSheet = hssfWorkbook.getSheetAt(numSheet);
            if (hssfSheet == null) continue;
            if (fields == null && hssfSheet.getLastRowNum() >= 1 && (hssfRow = hssfSheet.getRow(0)) != null) {
                fields = new String[hssfRow.getLastCellNum()];
                for (int i = 0; i < fields.length; ++i) {
                    HSSFCell xh = hssfRow.getCell(i);
                    fields[i] = xh.getStringCellValue();
                }
            }
            for (int rowNum = 1; rowNum < hssfSheet.getLastRowNum() + 1; ++rowNum) {
                HSSFRow hssfRow2 = hssfSheet.getRow(rowNum);
                if (hssfRow2 == null) continue;
                JSONObject json = new JSONObject();
                int celcount = fields != null ? fields.length : (int)hssfRow2.getLastCellNum();
                for (int celNum = 0; celNum < celcount; ++celNum) {
                    String colkey = fields != null ? fields[celNum] : String.valueOf(celNum);
                    HSSFCell xh = hssfRow2.getCell(celNum);
                    if (xh == null) {
                        json.put(colkey, (Object)"");
                        continue;
                    }
                    if (xh.getCellType() == 4) {
                        json.put(colkey, (Object)xh.getBooleanCellValue());
                        continue;
                    }
                    if (xh.getCellType() == 0) {
                        json.put(colkey, (Object)xh.getNumericCellValue());
                        continue;
                    }
                    if (xh.getCellType() == 3) {
                        json.put(colkey, (Object)"");
                        continue;
                    }
                    json.put(colkey, (Object)xh.getStringCellValue());
                }
                array.add((Object)json);
            }
        }
        if (maxrow > 0L && (long)array.size() >= maxrow) {
            throw new ServiceException("10000", "limit rows {0},excel rows {1}", maxrow, array.size());
        }
        return array;
    }

    public static JSONArray XLSXtoJSONArray(InputStream is, String flds, long maxrow) throws Exception {
        JSONArray array = new JSONArray();
        String[] fields = null;
        if (!StringUtils.isEmpty((Object)flds)) {
            fields = flds.split(fieldLimit);
        }
        XSSFWorkbook hssfWorkbook = new XSSFWorkbook(is);
        for (int numSheet = 0; numSheet < hssfWorkbook.getNumberOfSheets(); ++numSheet) {
            XSSFRow hssfRow;
            XSSFSheet hssfSheet = hssfWorkbook.getSheetAt(numSheet);
            if (hssfSheet == null) continue;
            if (fields == null && hssfSheet.getLastRowNum() >= 1 && (hssfRow = hssfSheet.getRow(0)) != null) {
                fields = new String[hssfRow.getLastCellNum()];
                for (int i = 0; i < fields.length; ++i) {
                    XSSFCell xh = hssfRow.getCell(i);
                    fields[i] = xh.getStringCellValue();
                }
            }
            for (int rowNum = 1; rowNum < hssfSheet.getLastRowNum() + 1; ++rowNum) {
                XSSFRow hssfRow2 = hssfSheet.getRow(rowNum);
                if (hssfRow2 == null) continue;
                JSONObject json = new JSONObject();
                int celcount = fields != null ? fields.length : (int)hssfRow2.getLastCellNum();
                for (int celNum = 0; celNum < celcount; ++celNum) {
                    String colkey = fields != null ? fields[celNum] : String.valueOf(celNum);
                    XSSFCell xh = hssfRow2.getCell(celNum);
                    if (xh == null) {
                        json.put(colkey, (Object)"");
                        continue;
                    }
                    if (xh.getCellType() == 4) {
                        json.put(colkey, (Object)xh.getBooleanCellValue());
                        continue;
                    }
                    if (xh.getCellType() == 0) {
                        json.put(colkey, (Object)xh.getNumericCellValue());
                        continue;
                    }
                    if (xh.getCellType() == 3) {
                        json.put(colkey, (Object)"");
                        continue;
                    }
                    json.put(colkey, (Object)xh.getStringCellValue());
                }
                array.add((Object)json);
            }
        }
        if (maxrow > 0L && (long)array.size() >= maxrow) {
            throw new ServiceException("10000", "limit rows {0},excel rows {1}", maxrow, array.size());
        }
        return array;
    }

    public static Map<String, String> getconfig(Map<String, String> config, int sheetnum) {
        return config;
    }

    public static String checkval(Object val, String checktype, boolean ibriase) {
        return null;
    }

    public static Object formatval(Object val, String datatype) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (StringUtils.isEmpty((Object)val)) {
            return val;
        }
        if (StringUtils.isEmpty((Object)datatype)) {
            return val;
        }
        if (datatype.equalsIgnoreCase(DATATYPE_STRING)) {
            if (val.getClass().equals(String.class)) {
                return val.toString().trim();
            }
            if (val.getClass().equals(Double.TYPE)) {
                return String.valueOf((Long)val).trim();
            }
            if (val.getClass().equals(Double.class)) {
                return String.valueOf(Math.round(Double.parseDouble(String.valueOf(val).trim())));
            }
            if (val.getClass().equals(Date.class)) {
                return sdf.format(val);
            }
            return val.toString();
        }
        if (datatype.equalsIgnoreCase(DATATYPE_NUMBER)) {
            if (ExcelUtils.isNumeric(val.toString())) {
                return Double.parseDouble((String)val);
            }
            return val;
        }
        if (datatype.equalsIgnoreCase(DATATYPE_DATE)) {
            if (val.getClass().equals(Date.class)) {
                return sdf.parseObject(sdf.format(val));
            }
            if (val.getClass().equals(String.class)) {
                SimpleDateFormat sdf1;
                String val1 = (String)val;
                if (val1.indexOf(45) > -1) {
                    sdf1 = new SimpleDateFormat("yyyy-MM-dd");
                    if (val1.length() > 10 && val1.length() < 17) {
                        sdf1 = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                    } else if (val1.length() > 17) {
                        sdf1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    }
                } else if (val1.indexOf(47) > -1) {
                    sdf1 = new SimpleDateFormat("yyyy/MM/dd");
                    if (val1.length() > 10 && val1.length() < 17) {
                        sdf1 = new SimpleDateFormat("yyyy/MM/dd HH:mm");
                    } else if (val1.length() > 17) {
                        sdf1 = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                    }
                } else {
                    return val1;
                }
                return sdf1.parseObject((String)val);
            }
            return val;
        }
        return val;
    }

    public static JSONArray execltoJSONArray(InputStream is, String filetype, String modid) throws Exception {
        return ExcelUtils.execltoJSONArray(is, filetype, modid, null);
    }

    public static JSONArray execltoJSONArray(FileImportObject fio, String modid, ImpRowCallbackHandler irch) throws Exception {
        String filetype = fio.getFilename().toLowerCase().endsWith(".xlsx") ? XLSX : XLS;
        return ExcelUtils.execltoJSONArray(fio.getStream(), filetype, modid, irch);
    }

    public static JSONArray execltoJSONArray(InputStream is, String filetype, String modid, ImpRowCallbackHandler irch) throws Exception {
        Map<String, String> config = ExcelUtils.getimpconfig(modid);
        return ExcelUtils.execltoJSONArray(is, filetype, config, irch);
    }

    public static JSONArray execltoJSONArray(InputStream is, String filetype, Map<String, String> config, ImpRowCallbackHandler irch) throws Exception {
        JSONArray array = new JSONArray();
        Object workbook = filetype.equalsIgnoreCase(XLS) ? new HSSFWorkbook(is) : new XSSFWorkbook(is);
        int numSheet = 0;
        String[] fields = null;
        String[] datatype = null;
        String[] defvalue = null;
        String[] checktype = null;
        Sheet sheet = workbook.getSheetAt(numSheet);
        FormulaEvaluator evaluator = workbook.getCreationHelper().createFormulaEvaluator();
        Map<String, String> stconfig = ExcelUtils.getconfig(config, numSheet);
        if (!StringUtils.isEmpty((Object)stconfig.get("fields"))) {
            fields = stconfig.get("fields").split(fieldLimit);
        }
        if (!StringUtils.isEmpty((Object)stconfig.get("datatype"))) {
            datatype = stconfig.get("datatype").split(fieldLimit);
        }
        if (!StringUtils.isEmpty((Object)stconfig.get("defvalue"))) {
            defvalue = stconfig.get("defvalue").split(fieldLimit);
        }
        if (!StringUtils.isEmpty((Object)stconfig.get("checktype"))) {
            checktype = stconfig.get("checktype").split(fieldLimit);
        }
        int minRowIx = 1;
        int maxRowIx = sheet.getLastRowNum();
        boolean endflag = false;
        boolean emptyRow = false;
        for (int rowIx = minRowIx; rowIx <= maxRowIx && !endflag && !emptyRow; ++rowIx) {
            Row row = sheet.getRow(rowIx);
            if (!ExcelUtils.isIllegalRow(fields, (Workbook)workbook, row)) {
                emptyRow = true;
                continue;
            }
            JSONObject json = new JSONObject();
            short minColIx = row.getFirstCellNum();
            short maxColIx = row.getLastCellNum();
            JSONObject errjson = new JSONObject();
            for (short colIx = minColIx; colIx <= maxColIx; colIx = (short)(colIx + 1)) {
                String msg;
                Cell cell = row.getCell(new Integer(colIx).intValue());
                CellValue cellValue = evaluator.evaluate(cell);
                Object value = null;
                if (cellValue == null) {
                    if (colIx != minColIx) continue;
                    endflag = true;
                    break;
                }
                String colkey = fields != null && fields.length > colIx ? fields[colIx] : String.valueOf(rowIx);
                String dtkey = datatype != null && datatype.length > colIx ? datatype[colIx] : null;
                String dvkey = defvalue != null && defvalue.length > colIx ? defvalue[colIx] : null;
                String ctkey = checktype != null && checktype.length > colIx ? checktype[colIx] : null;
                value = ExcelUtils.getCellValue(cell, cellValue);
                if (StringUtils.isEmpty((Object)value) && !StringUtils.isEmpty((Object)dvkey)) {
                    value = dvkey;
                }
                value = ExcelUtils.formatval(value, dtkey);
                if (!StringUtils.isEmpty((Object)ctkey) && !StringUtils.isEmpty((Object)(msg = ExcelUtils.checkval(value, ctkey, false)))) {
                    errjson.put(colkey, (Object)msg);
                }
                json.put(colkey, value);
                if (errjson.size() <= 0) continue;
                json.put("errmsg", (Object)errjson);
            }
            if (irch != null) {
                irch.processRow(json);
            }
            if (endflag) continue;
            array.add((Object)json);
        }
        return array;
    }

    public static Map<String, String> getimpconfig(String modid) throws IOException {
        if (env == null) {
            env = (Environment)SpringBeanFactory.getContext().getBean(Environment.class);
        }
        if ("Y".equalsIgnoreCase(env.getProperty("efuture.impconfig"))) {
            ServiceLogs.truedebuglog("execlConfig", "use property config", 0L);
            String[] keys = new String[]{"fields", "datatype", "defvalue", "checktype"};
            HashMap<String, String> rtn = new HashMap<String, String>();
            for (int i = 0; i <= 3; ++i) {
                String key = "efuture.impconfig." + modid + "." + keys[i];
                String value = env.getProperty(key);
                rtn.put(keys[i], value);
            }
            return rtn;
        }
        ServiceLogs.truedebuglog("execlConfig", "use file config:impconfig.ini", 0L);
        if (!impconfig.isinit()) {
            String filename = WebPathUtils.getWebRootClassPath() + "/impconfig.ini";
            impconfig.init(filename);
        }
        return impconfig.getsection(modid);
    }

    private static boolean isIllegalRow(String[] fields, Workbook workbook, Row row) {
        FormulaEvaluator evaluator = workbook.getCreationHelper().createFormulaEvaluator();
        int minColIx = row.getFirstCellNum();
        short maxColIx = row.getLastCellNum();
        int numfields = maxColIx - minColIx;
        if (fields.length == numfields) {
            return true;
        }
        boolean isEmpty = true;
        for (int colIx = minColIx; colIx <= maxColIx; ++colIx) {
            Object value;
            Cell cell = row.getCell(new Integer(colIx).intValue());
            CellValue cellValue = evaluator.evaluate(cell);
            if (cellValue == null || StringUtils.isEmpty((Object)(value = ExcelUtils.getCellValue(cell, cellValue)))) continue;
            isEmpty = false;
            break;
        }
        return !isEmpty;
    }

    private static Object getCellValue(Cell cell, CellValue cellValue) {
        Object value = null;
        switch (cellValue.getCellType()) {
            case 4: {
                value = cellValue.getBooleanValue();
                break;
            }
            case 0: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    value = cell.getDateCellValue();
                    break;
                }
                value = cellValue.getNumberValue();
                break;
            }
            case 1: {
                String tmp = cellValue.getStringValue();
                tmp = tmp.trim();
                tmp = tmp.replaceAll("\u3000|\u00a0", "");
                tmp = tmp.trim();
                value = tmp;
                break;
            }
            default: {
                value = cellValue.getStringValue();
            }
        }
        return value;
    }
}

