/**
 * Copyright (C), 2007-2015, eFuture 北京富基融通科技有限公司
 * FileName:	BillCommonServiceImpl.java
 * Author:		亮
 * Date:		2015-7-10 下午5:49:51
 * Description:	
 * History:
 * <author>		<time>			<version>		<description>
 * 
 */
package com.efuture.ocp.common.billservice;

import java.io.IOException;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.dom4j.DocumentException;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.domain.Sort.Direction;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.bpm.BpmService;
import com.efuture.ocp.common.component.MasterSlaveComponent;
import com.efuture.ocp.common.entity.AbstractEntityBean;
import com.efuture.ocp.common.entity.BeanConstant;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.language.MessageSourceHelper;
import com.efuture.ocp.common.language.ResponseCode;
import com.efuture.ocp.common.user.UserDataRangeSrv;
import com.efuture.ocp.common.util.HttpUtils;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.ocp.common.util.SslUtils;
import com.efuture.ocp.common.util.StorageUtils;
import com.efuture.ocp.common.util.UniqueID;
import com.efuture.ocp.common.util.Utils;
import com.efuture.omd.storage.FMybatisTemplate;
import com.efuture.omd.storage.FStorageOperations;

/**
 * @author 亮
 * @description
 * 
 */
public class BillCommonServiceImpl<T extends BillAbstractHeadBean> extends MasterSlaveComponent<T> implements BillCommonService {
	SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
	public interface BillStatus {
		final String NEW = "N"; // 新建
		final String AUDIT = "Y"; // 审核完毕
		final String CANCEL = "C"; // 取消
		final String WAIT = "W"; // 等待异步审核
		final String EXEC = "T"; // 异步审核中
		final String AUDITING = "A"; // 审批中
		final String SUBMIT = "S"; // 提交
		final String REJECT = "R"; // 驳回
		final String ERR = "E";		//审核错误
	}

	public interface BillSource {
		final String APP = "APP"; // APP录入的单据
		final String MSS = "MSS"; // 后台MSS录入的单据
	}

	private Map<String, String> STATUSNAME = new HashMap<String, String>();
	private BillOperLogService operlog;

	// 申请单号
	@Override
	@Transactional(propagation = Propagation.REQUIRES_NEW)
	public ServiceResponse applybillno(ServiceSession session, JSONObject jsonparam) throws Exception {
		// 参数检查
		if (session == null)
			return ServiceResponse.buildFailure(session, ResponseCode.Exception.SESSION_IS_EMPTY);
		if (StringUtils.isEmpty(jsonparam))
			return ServiceResponse.buildFailure(session, ResponseCode.Exception.PARAM_IS_EMPTY);
		if (StringUtils.isEmpty(jsonparam.get("moduleid")))
			return ServiceResponse.buildFailure(session, ResponseCode.EXCEPTION, "{0} {1} is empty", "", "moduleid");

		// 默认生成billno
		String ruleid = jsonparam.getString("ruleid");
		if (StringUtils.isEmpty(ruleid))
			ruleid = "billno";
		int num = 1;
		if (jsonparam.containsKey("count"))
			num = jsonparam.getInteger("count");

		JSONObject json = new JSONObject();
		if (num > 1)
			json.put(ruleid, doApplyBillNoBatch(session.getEnt_id(), ruleid, jsonparam.getString("moduleid"), jsonparam.getString("type"), jsonparam.getString("level"), num));
		else
			json.put(ruleid, doApplyBillNo(session.getEnt_id(), ruleid, jsonparam.getString("moduleid"), jsonparam.getString("type"), jsonparam.getString("level")));
		return ServiceResponse.buildSuccess(json);
	}

	@Transactional(propagation = Propagation.REQUIRES_NEW)
	public String doApplyBillNo(long ent_id, String ruleid, String moduleid, String type, String level) {
		List<String> list = doApplyBillNoBatch(ent_id, ruleid, moduleid, type, level, 1);
		if (list != null && list.size() > 0)
			return list.get(0);
		else
			return null;
	}

	@Transactional(propagation = Propagation.REQUIRES_NEW)
	public List<String> doApplyBillNoBatch(long ent_id, String ruleid, String moduleid, String type, String level, int num) {
		// 生成规则编码
		List<String> billnolist = new ArrayList<String>();
		FMybatisTemplate storage = null;
		try {
			// 得到数据源
			storage = getStorageOperations(FMybatisTemplate.class);

			// 先查询编码规则
			String globrule = "globrule";
			Criteria criteria = Criteria.where("ent_id").is(ent_id).and("ruleid").is(ruleid);
			Query query = new Query(criteria);
			Map<String, Object> map = storage.selectOne(query, globrule);
			if (map == null) {
				criteria = Criteria.where("ent_id").is(0).and("ruleid").is(ruleid);
				query = new Query(criteria);
				map = storage.selectOne(query, globrule);
			}
			if (map == null || StringUtils.isEmpty(map.get("ruledef")))
				throw new ServiceException(ResponseCode.Failure.NOT_EXIST, "{0} {1} [{2}] does not exist", "globrule", "ruleid", ruleid);

			// 生成规则码
			SimpleDateFormat datefmt = new SimpleDateFormat("yyMMdd");
			StringBuffer sb = new StringBuffer();
			int daylen = 0;
			String[] ruledefs = map.get("ruledef").toString().split("\\|");
			for (String def : ruledefs) {
				if ("#SEQ".equalsIgnoreCase(def))
					continue;
				else if ("#DAY".equalsIgnoreCase(def))
					daylen = 6;
				else if ("#MON".equalsIgnoreCase(def))
					daylen = 4;
				else if ("#MODULEID".equalsIgnoreCase(def))
					sb.append(moduleid);
				else
					sb.append(def);
			}
			int seqlen = Integer.parseInt(map.get("rulesyslen").toString()) - sb.length() - daylen;

			// 锁住编码规则
			if (num <= 0)
				num = 1;
			String globruledet = "globruledet";
			long seqno = 1;
			String datestr = datefmt.format(new Date());
			if (daylen > 0)
				datestr = datestr.substring(0, daylen);
			String rulestr = (sb.length() > 0 ? sb.toString() : moduleid);
			criteria = Criteria.where("ent_id").is(ent_id).and("ruleid").is(ruleid).and("ruletypestr").is(rulestr);
			query = new Query(criteria);
			Update upt = new Update();
			upt.set("ruleid", ruleid);
			if (storage.update(query, upt, globruledet) <= 0) {
				Map<String, Object> data = new HashMap<String, Object>();
				data.put("ent_id", ent_id);
				data.put("ruleid", ruleid);
				data.put("ruletypestr", rulestr);
				data.put("rulecurseqno", seqno + (num - 1));
				data.put("ruletypeday", datestr);
				storage.insert(data, globruledet);
			} else {
				map = storage.selectOne(query, globruledet);
				if (daylen > 0 && !datestr.equals(map.get("ruletypeday")))
					seqno = 1;
				else
					seqno = Long.parseLong(map.get("rulecurseqno").toString()) + 1;

				upt = new Update();
				upt.set("rulecurseqno", seqno + (num - 1));
				upt.set("ruletypeday", datestr);
				storage.update(query, upt, globruledet);
			}

			// 批量生成编号
			for (int i = 0; i < num; i++) {
				sb.delete(0, sb.length());
				for (String def : ruledefs) {
					if ("#SEQ".equalsIgnoreCase(def)) {
						int len = seqlen - String.valueOf(seqno).length();
						if (len < 0)
							throw new ServiceException(ResponseCode.FAILURE, "seqno [{0}] length is max [{1}]", seqno, seqlen);
						if (len > 0)
							sb.append("00000000000000000000".substring(0, len));
						sb.append(seqno);
					} else if ("#DAY".equalsIgnoreCase(def) || "#MON".equalsIgnoreCase(def))
						sb.append(datestr);
					else if ("#MODULEID".equalsIgnoreCase(def))
						sb.append(moduleid);
					else
						sb.append(def);
				}

				billnolist.add(sb.toString());
				seqno = seqno + 1;
			}
		} finally {
			if (storage != null)
				storage.destroy();
		}

		return billnolist;
	}

	protected String getBillNoRuleID(String billmoduleid) {
		return "billno";
	}

	@Transactional(propagation = Propagation.REQUIRED)
	public long doAdd(AbstractEntityBean bean, String id, String... uniques) throws Exception {
		// 申请单号
		if (bean instanceof BillAbstractHeadBean) {
			BillAbstractHeadBean bill = (BillAbstractHeadBean) bean;
			if (StringUtils.isEmpty(bill.getBillno()) && !StringUtils.isEmpty(bill.getBillmoduleid())) {
				// 单独事务申请单号
				String ruleid = getBillNoRuleID(bill.getBillmoduleid());
				String billno = SpringBeanFactory.getBean("bill.common", BillCommonServiceImpl.class).doApplyBillNo(bill.getEnt_id(), ruleid, bill.getBillmoduleid(), null, null);
				bill.setBillno(billno);
				if(!StringUtils.isEmpty(getBillKeyField())){
					getBillKeyField().set(bean, billno);
				}
				
			}

			// 如果手工单号为空,填入单号
			if (StringUtils.isEmpty(bill.getBillsgno()))
				bill.setBillsgno(bill.getBillno());

			// 设置单据录入缺省值
			bill.setInputdate(new Date());
			bill.setLastmodby(bill.getInputer());
			bill.setLastmodby_name(bill.getInputer_name());
			this.getOperlog().log(bill.getInputer(), bill.getInputer_name(), "新增", "", bill);
		}

		return super.doAdd(bean, id, uniques);
	}

	@Transactional(propagation = Propagation.REQUIRED)
	public Object doDelete(AbstractEntityBean bean, String id, String... keys) throws Exception {
		// 加锁检查单据状态
		if (bean instanceof BillAbstractHeadBean) {
			BillAbstractHeadBean bill = (BillAbstractHeadBean) bean;
			BillAbstractHeadBean oribill = checkBillStatus(bill);
			if (!BillStatus.NEW.equalsIgnoreCase(oribill.getBillstatus()))
				throw new ServiceException(ResponseCode.FAILURE, "[{0}]单据不是录入状态的单据,不能删除!", oribill.getBillno());
			this.getOperlog().log("删除", "", bill);
		}

		return super.doDelete(bean, id, keys);
	}

	@Transactional(propagation = Propagation.REQUIRED)
	public Object doUpdate(AbstractEntityBean bean, Set<String> keys, String id, String... uniques) throws Exception {
		// 加锁检查单据状态
		if (bean instanceof BillAbstractHeadBean) {
			BillAbstractHeadBean bill = (BillAbstractHeadBean) bean;
			BillAbstractHeadBean oribill = checkBillStatus(bill);
			if (!BillStatus.NEW.equalsIgnoreCase(oribill.getBillstatus()))
				throw new ServiceException(ResponseCode.FAILURE, "[{0}]单据不是录入状态的单据,不能修改!", oribill.getBillno());
			this.getOperlog().log("修改", "", bill);
		}

		return super.doUpdate(bean, keys, id, uniques);
	}

	// 加锁检查单据状态
	@Transactional(propagation = Propagation.REQUIRED)
	protected BillAbstractHeadBean checkBillStatus(BillAbstractHeadBean bill) throws Exception {
		// 先锁住避免并发
		Set<String> keys = new HashSet<String>();
		bill.setPh_timestamp(new Date());
		keys.add("ph_timestamp");
		super.doUpdate(bill, keys, "billno");

		// 再查询单据
		JSONObject json = new JSONObject();
		json.put(BeanConstant.QueryField.PARAMKEY_FIELDS, "*"); // 不查子表
		json.put("ent_id", bill.getEnt_id());
		json.put("billno", bill.getBillno());
		T oribill = doSearchOne(json, getBeanClass());
		if (oribill == null)
			throw new ServiceException(ResponseCode.Failure.NOT_EXIST, "{0} {1} [{2}] does not exist", MessageSourceHelper.getMessage(bill.fetchAnnotationTableName(), bill.getLang()), "billno",
					bill.getBillno());
		return oribill;
	}

	// 审核单据
	@Override
	@Transactional(propagation = Propagation.REQUIRED)
	public ServiceResponse billaudit(ServiceSession session, JSONObject jsonparam) throws Exception {
		// 参数检查
		UserDataRangeSrv.setlocalisrange(false);
		if (session == null)
			return ServiceResponse.buildFailure(session, ResponseCode.Exception.SESSION_IS_EMPTY);
		if (StringUtils.isEmpty(jsonparam))
			return ServiceResponse.buildFailure(session, ResponseCode.Exception.PARAM_IS_EMPTY);
		if (StringUtils.isEmpty(jsonparam.get("billno")))
			return ServiceResponse.buildFailure(session, ResponseCode.EXCEPTION, "{0} {1} is empty", "", "billno");

		// 强审标志
		boolean force = false;
		if (jsonparam.containsKey("force"))
			force = jsonparam.getBoolean("force");

		T bean = StorageUtils.parseBeanObject(jsonparam, getBeanClass());
		bean.initUpdateMember(session);
		Object auditdata = doBillAudit(bean, session, force);

		// 非强审有审核数据返回,说明审核需要确认
		JSONObject json = new JSONObject();
		if (!force && auditdata != null) {
			json.put("data", auditdata);
			json.put("msg", "[" + jsonparam.get("billno") + "] 单据审核不成功,需再次确认!");
		} else {
			json.put("msg", "[" + jsonparam.get("billno") + "] 单据审核成功!");
		}
		return ServiceResponse.buildSuccess(json);
	}

	protected Set<String> beforeBillAudit(BillAbstractHeadBean bill) throws Exception {
		// 标识为异步执行
		if ("WAITTING".equalsIgnoreCase(bill.getBillsgno()))
			bill.setBillstatus(BillStatus.WAIT);

		return null;
	}

	protected void afterBillAudit(BillAbstractHeadBean bill) throws Exception {
		
	}
	@Transactional(propagation = Propagation.REQUIRED)
	public Object doBillAudit(BillAbstractHeadBean bill, ServiceSession session, boolean force) throws Exception {
		// 加锁检查单据状态
		BillAbstractHeadBean oribill = checkBillStatus(bill);
		if (BillStatus.AUDIT.equalsIgnoreCase(oribill.getBillstatus()))
			throw new ServiceException(ResponseCode.FAILURE, "[{0}]单据已审核,不能重复审核!", oribill.getBillno());
		if (!BillStatus.NEW.equalsIgnoreCase(oribill.getBillstatus())) {
			if (BillStatus.WAIT.equalsIgnoreCase(oribill.getBillstatus()) && !"asyncaudit".equalsIgnoreCase(bill.getBillsgno())) {
				throw new ServiceException(ResponseCode.FAILURE, "[{0}]单据已审核,不能重复审核!", oribill.getBillno());
			} else if (BillStatus.WAIT.equalsIgnoreCase(oribill.getBillstatus()) && "asyncaudit".equalsIgnoreCase(bill.getBillsgno())) {

			} else if (BillStatus.AUDITING.equalsIgnoreCase(oribill.getBillstatus())) {

			} else {
				throw new ServiceException(ResponseCode.FAILURE, "[{0}]单据不是待审核单据,不能审核!", oribill.getBillno());
			}

		}

		bill.setBillmoduleid(oribill.getBillmoduleid());
		bill.setBillstatus(null);

		// 更新单据状态
		if (StringUtils.isEmpty(bill.getBillstatus()) || BillStatus.NEW.equalsIgnoreCase(bill.getBillstatus()))
			bill.setBillstatus(BillStatus.AUDIT);
		if (StringUtils.isEmpty(bill.getAuditor()) && session != null)
			bill.setAuditor(session.getUser_code());
		if (StringUtils.isEmpty(bill.getAuditor_name()) && session != null)
			bill.setAuditor_name("[" + session.getUser_code() + "]" + session.getUser_name());
		bill.setAuditdate(new Date());
		bill.setLastmodby(bill.getAuditor());
		bill.setLastmodby_name(bill.getAuditor_name());

		// 审核动作
		Set<String> keys = beforeBillAudit(bill);

		if (keys == null)
			keys = new HashSet<String>();
		keys.add("billstatus");
		keys.add("ph_timestamp");
		keys.add("lastmodby");
		keys.add("lastmodby_name");
		keys.add("auditor");
		keys.add("auditor_name");
		keys.add("auditdate");
		super.doUpdate(bill, keys, "billno");
		
		
		//审核后事件
		afterBillAudit(bill);
		if (!force) {
			this.getOperlog().log(bill.getAuditor(), bill.getAuditor_name(), "审核", "", bill);
		}

		return null;
	}

	// 取消单据
	@Override
	@Transactional(propagation = Propagation.REQUIRED)
	public ServiceResponse billcancel(ServiceSession session, JSONObject jsonparam) throws Exception {
		// 参数检查
		UserDataRangeSrv.setlocalisrange(false);
		if (session == null)
			return ServiceResponse.buildFailure(session, ResponseCode.Exception.SESSION_IS_EMPTY);
		if (StringUtils.isEmpty(jsonparam))
			return ServiceResponse.buildFailure(session, ResponseCode.Exception.PARAM_IS_EMPTY);
		if (StringUtils.isEmpty(jsonparam.get("billno")))
			return ServiceResponse.buildFailure(session, ResponseCode.EXCEPTION, "{0} {1} is empty", "", "billno");

		// 强审标志
		boolean force = false;
		if (jsonparam.containsKey("force"))
			force = jsonparam.getBoolean("force");

		T bean = StorageUtils.parseBeanObject(jsonparam, getBeanClass());
		bean.initUpdateMember(session);
		Object canceldata = doBillCancel(bean, session, force);

		// 非强审有审核数据返回,说明审核需要确认
		JSONObject json = new JSONObject();
		if (!force && canceldata != null) {
			json.put("data", canceldata);
			json.put("msg", "[" + jsonparam.get("billno") + "] 单据取消不成功,需再次确认!");
		} else {
			json.put("msg", "[" + jsonparam.get("billno") + "] 单据取消成功!");
		}
		return ServiceResponse.buildSuccess(json);
	}

	protected Set<String> beforeBillCancel(BillAbstractHeadBean bill) throws Exception {
		// 标识为异步执行
		if ("WAITTING".equalsIgnoreCase(bill.getBillsgno()))
			bill.setBillstatus(BillStatus.WAIT);

		return null;
	}

	// 取消检查
	public void checkBillCancel(ServiceSession session, BillAbstractHeadBean oribill) {
		if (BillStatus.CANCEL.equalsIgnoreCase(oribill.getBillstatus()))
			throw new ServiceException(ResponseCode.FAILURE, "[{0}]单据已取消,不能重复取消!", oribill.getBillno());
		if (!BillStatus.AUDIT.equalsIgnoreCase(oribill.getBillstatus()))
			throw new ServiceException(ResponseCode.FAILURE, "[{0}]单据不是已审核单据,不能取消!", oribill.getBillno());
	}

	@Transactional(propagation = Propagation.REQUIRED)
	public Object doBillCancel(BillAbstractHeadBean bill, ServiceSession session, boolean force) throws Exception {
		// 加锁检查单据状态
		BillAbstractHeadBean oribill = checkBillStatus(bill);
		checkBillCancel(session, oribill);
		bill.setBillmoduleid(oribill.getBillmoduleid());
		bill.setBillstatus(null);

		// 取消动作
		Set<String> keys = beforeBillCancel(bill);

		// 更新单据状态
		if (StringUtils.isEmpty(bill.getBillstatus()) || BillStatus.AUDIT.equalsIgnoreCase(bill.getBillstatus()))
			bill.setBillstatus(BillStatus.CANCEL);
		if (StringUtils.isEmpty(bill.getCanceler()) && session != null)
			bill.setCanceler(session.getUser_code());
		if (StringUtils.isEmpty(bill.getCanceler_name()) && session != null)
			bill.setCanceler_name("[" + session.getUser_code() + "]" + session.getUser_name());
		bill.setCanceldate(new Date());
		bill.setLastmodby(bill.getCanceler());
		bill.setLastmodby_name(bill.getCanceler_name());
		if (keys == null)
			keys = new HashSet<String>();
		keys.add("billstatus");
		keys.add("ph_timestamp");
		keys.add("lastmodby");
		keys.add("lastmodby_name");
		keys.add("canceler");
		keys.add("canceler_name");
		keys.add("canceldate");
		super.doUpdate(bill, keys, "billno");
		this.getOperlog().log(bill.getCanceler(), bill.getCanceler_name(), "取消", "", bill);
		return null;
	}

	// 作废单据
	@Override
	@Transactional(propagation = Propagation.REQUIRED)
	public ServiceResponse billvoid(ServiceSession session, JSONObject jsonparam) throws Exception {
		// 参数检查
		if (session == null)
			return ServiceResponse.buildFailure(session, ResponseCode.Exception.SESSION_IS_EMPTY);
		if (StringUtils.isEmpty(jsonparam))
			return ServiceResponse.buildFailure(session, ResponseCode.Exception.PARAM_IS_EMPTY);
		if (StringUtils.isEmpty(jsonparam.get("billno")))
			return ServiceResponse.buildFailure(session, ResponseCode.EXCEPTION, "{0} {1} is empty", "", "billno");

		// 强审标志
		boolean force = false;
		if (jsonparam.containsKey("force"))
			force = jsonparam.getBoolean("force");

		T bean = StorageUtils.parseBeanObject(jsonparam, getBeanClass());
		bean.initUpdateMember(session);
		Object voiddata = doBillVoid(bean, session, force);

		// 非强审有审核数据返回,说明审核需要确认
		JSONObject json = new JSONObject();
		if (!force && voiddata != null) {
			json.put("data", voiddata);
			json.put("msg", "[" + jsonparam.get("billno") + "] 单据作废不成功,需再次确认!");
		} else {
			json.put("msg", "[" + jsonparam.get("billno") + "] 单据作废成功!");
		}
		return ServiceResponse.buildSuccess(json);
	}

	@Transactional(propagation = Propagation.REQUIRED)
	public Object doBillVoid(BillAbstractHeadBean bill, ServiceSession session, boolean force) throws Exception {
		// 加锁检查单据状态
		BillAbstractHeadBean oribill = checkBillStatus(bill);
		if (BillStatus.CANCEL.equalsIgnoreCase(oribill.getBillstatus()))
			throw new ServiceException(ResponseCode.FAILURE, "[{0}]单据已作废,不能重复作废!", oribill.getBillno());
		if (!BillStatus.AUDIT.equalsIgnoreCase(oribill.getBillstatus()))
			throw new ServiceException(ResponseCode.FAILURE, "[{0}]单据不是已审核单据,不能作废!", oribill.getBillno());
		bill.setBillmoduleid(oribill.getBillmoduleid());
		bill.setBillstatus(null);

		// 作废动作
		Set<String> keys = beforeBillVoid(bill);

		// 更新单据状态
		if (StringUtils.isEmpty(bill.getBillstatus()) || BillStatus.AUDIT.equalsIgnoreCase(bill.getBillstatus()))
			bill.setBillstatus(BillStatus.CANCEL);
		if (StringUtils.isEmpty(bill.getCanceler()) && session != null)
			bill.setCanceler(session.getUser_code());
		if (StringUtils.isEmpty(bill.getCanceler_name()) && session != null)
			bill.setCanceler_name("[" + session.getUser_code() + "]" + session.getUser_name());
		bill.setCanceldate(new Date());
		bill.setLastmodby(bill.getCanceler());
		bill.setLastmodby_name(bill.getCanceler_name());
		if (keys == null)
			keys = new HashSet<String>();
		keys.add("billstatus");
		keys.add("ph_timestamp");
		keys.add("lastmodby");
		keys.add("lastmodby_name");
		keys.add("canceler");
		keys.add("canceler_name");
		keys.add("canceldate");
		super.doUpdate(bill, keys, "billno");
		this.getOperlog().log(bill.getCanceler(), bill.getCanceler_name(), "作废", "", bill);
		return null;
	}

	protected Set<String> beforeBillVoid(BillAbstractHeadBean bill) throws Exception {
		// 标识为异步执行
		if ("WAITTING".equalsIgnoreCase(bill.getBillsgno()))
			bill.setBillstatus(BillStatus.WAIT);

		return null;
	}

	protected List<?> doGet(JSONObject jsonparam, Class<?> objClass, StringBuffer total) throws Exception {
		// 如果传入了门店和渠道查询字段,查询门店渠道子表进行过滤
		if (jsonparam != null && (!StringUtils.isEmpty(jsonparam.getString("mktid")) || !StringUtils.isEmpty(jsonparam.getString("chid")))) {
			Field mktfld = AbstractEntityBean.fetchDeclaredField(objClass, "billmktdetail");
			Field chlfld = AbstractEntityBean.fetchDeclaredField(objClass, "billchanneldetail");
			if (mktfld != null && !StringUtils.isEmpty(jsonparam.get("mktid"))) {
				Object mktobj = jsonparam.get("mktid");
				jsonparam.remove("mktid");

				// %为全部门店
				if (mktobj instanceof JSONObject)
					jsonparam.put("billmktdetail:mktid", mktobj);
				else {
					JSONObject json = new JSONObject();
					json.put("$in", mktobj + ",%");
					jsonparam.put("billmktdetail:mktid", json);
				}
			}
			if (chlfld != null && !StringUtils.isEmpty(jsonparam.get("chid"))) {
				Object chlobj = jsonparam.get("chid");
				jsonparam.remove("chid");

				// %为全部渠道
				if (chlobj instanceof JSONObject)
					jsonparam.put("billchanneldetail:chid", chlobj);
				else {
					JSONObject json = new JSONObject();
					json.put("$in", chlobj + ",%");
					jsonparam.put("billchanneldetail:chid", json);
				}
			}
		}

		// 查询数据
		return super.doGet(jsonparam, objClass, total);
	}

	public BillOperLogService getOperlog() {
		if (operlog == null) {
			operlog = BillOperLogSrvImpl.getLog();
		}
		return operlog;
	}

	public void setOperlog(BillOperLogService operlog) {
		this.operlog = operlog;
	}
	protected Field getBillKeyField() throws IllegalArgumentException, IllegalAccessException
    {
		if(!StringUtils.isEmpty(getBillKey())){
			Field idfld = AbstractEntityBean.fetchDeclaredField(getBeanClass(),getBillKey());
	        return idfld;
		}else{
			return null;
		}
        
    }    
	
	protected String getBillKey() throws IllegalArgumentException, IllegalAccessException
    {
        return getBillKey(null);
    }
    
	protected String getBillKey(Class<?> cl) throws IllegalArgumentException, IllegalAccessException{
		Field fld =AbstractEntityBean.fetchDeclaredField(cl==null?getBeanClass():cl,"BILL_KEY");
		if (fld == null) {
    		return null;
    	}
        return (String) fld.get(null);
	}
	/**
	 * 审批
	 */
	@Transactional(propagation = Propagation.REQUIRED)
	@Override
	public ServiceResponse billsubmit(ServiceSession session, JSONObject jsonparam) throws Exception {
		// 参数检查
		if (session == null)
			return ServiceResponse.buildFailure(session, ResponseCode.Exception.SESSION_IS_EMPTY);
		if (StringUtils.isEmpty(jsonparam))
			return ServiceResponse.buildFailure(session, ResponseCode.Exception.PARAM_IS_EMPTY);
		if (StringUtils.isEmpty(jsonparam.get("billno")))
			return ServiceResponse.buildFailure(session, ResponseCode.EXCEPTION, "{0} {1} is empty", "", "billno");

		T bean = StorageUtils.parseBeanObject(jsonparam, getBeanClass());

		Object submitdata = dobillsubmit(bean, session);

		JSONObject json = new JSONObject();
		json.put("msg", "[" + jsonparam.get("billno") + "] 单据提交成功!");
		return ServiceResponse.buildSuccess(json);
	}

	/**
	 * 对接第三方审批流审批
	 */
	@Transactional(propagation = Propagation.REQUIRED)
	public ServiceResponse billapproveforthird(ServiceSession session, JSONObject jsonparam) throws Exception {
		// 参数检查
		if (session == null)
			return ServiceResponse.buildFailure(session, ResponseCode.Exception.SESSION_IS_EMPTY);
		if (StringUtils.isEmpty(jsonparam))
			return ServiceResponse.buildFailure(session, ResponseCode.Exception.PARAM_IS_EMPTY);
		if (StringUtils.isEmpty(jsonparam.get("billno")))
			return ServiceResponse.buildFailure(session, ResponseCode.EXCEPTION, "{0}为空", "", "billno");

		T bean = StorageUtils.parseBeanObject(jsonparam, getBeanClass());
		dobillthirdbpmexec(bean, BillStatus.AUDITING, session, jsonparam.getString("billislast"));
		JSONObject jsonrtn = new JSONObject();
		jsonrtn.put("msg", "单据 [" + jsonparam.get("billno") + "] " + "审核成功!");
		return ServiceResponse.buildSuccess(jsonrtn);
	}

	/**
	 * 得到流程编码
	 * 
	 * @param bill
	 * @return
	 */
	public String getprocessdefkey(BillAbstractHeadBean bill) {
		// 从billmain中得到流程编号,如果没有填写则取默认 BPM+单据模块ID
		FMybatisTemplate fs = this.getStorageOperations(FMybatisTemplate.class);
		Criteria criteria = Criteria.where("modeid").is(bill.getBillmoduleid());
		Query q = new Query(criteria);
		q.limit(1);
		q.fields().include("billisworkflow");
		Map<String, Object> billmain = fs.selectOne(q, "billmain");
		String processdefkey = "BPM" + bill.getBillmoduleid();
		if (billmain != null && !StringUtils.isEmpty(billmain.get("billisworkflow"))) {
			String[] s = billmain.get("billisworkflow").toString().split("\\|");
			if (s.length > 1) {
				processdefkey = s[1];
			}
		}
		return processdefkey;
	}

	/**
	 * 得到模块billmain配置
	 * 
	 * @param bill
	 * @return
	 */
	public Map<String, Object> getbillmain(BillAbstractHeadBean bill) {
		FMybatisTemplate fs = this.getStorageOperations(FMybatisTemplate.class);
		Criteria criteria = Criteria.where("modeid").is(bill.getBillmoduleid());
		Query q = new Query(criteria);
		q.limit(1);
		Map<String, Object> billmain = null;
		try {
			billmain = fs.selectOne(q, "billmain");
		} catch (Exception e) {
			
		}
		

		return billmain;
	}

	/**
	 * 得到要传给BPM的参数
	 * 
	 * @param bill
	 * @param session
	 * @return
	 */
	public JSONObject getbpmvariable(BillAbstractHeadBean bill, ServiceSession session) {
		JSONObject obj = (JSONObject) Utils.toNormalJSONObject(bill);
		obj.put("rolecode", session.getRolecode());
		return obj;
	}

	public Object getmuid(BillAbstractHeadBean bill, ServiceSession session) {
		Object muid = null;
		try {
			muid = AbstractEntityBean.fetchDeclaredField(bill.getClass(), "muid").get(bill);
		} catch (Exception e) {
			muid = session.getDeptcode();
			e.printStackTrace();
		}
		return muid;
	}

	/**
	 * 得到提交给BPM的信息
	 * 
	 * @param bill
	 * @param session
	 * @param getvariable
	 *            是否要传参数
	 * @return
	 * @throws DocumentException 
	 * @throws ParseException 
	 * @throws NumberFormatException 
	 */
	public Map<String, Object> getbpminfo(BillAbstractHeadBean bill, ServiceSession session, boolean getvariable, String billstatus) throws DocumentException, NumberFormatException, ParseException {
		bill.setBillstatus(billstatus);
		Map<String, Object> rtn = new HashMap<String, Object>();
		String processdefkey = getprocessdefkey(bill);
		//接入忘忧草工作流，billmain.billisworkflow="Y|WYC"
		if ("WYC".equalsIgnoreCase(processdefkey)) {
			
			FMybatisTemplate storage = getStorageOperations(FMybatisTemplate.class);
			try {
				try {
					SslUtils.ignoreSsl();
				} catch (Exception e) {
					e.printStackTrace();
				}
				//storage = (FMybatisTemplate) getStorageOperations();
				String workconfig = "dbusrpub.workflagtable";
				Sort order = new Sort(Direction.ASC, "rowno");
				Criteria criteria = Criteria.where("billmoduleid").is(bill.getBillmoduleid());
				Query query = new Query(criteria);
				query.with(order);
				List<Map<String, Object>> map = storage.select(query, workconfig);
				if (map == null||map.size() == 0)
					throw new ServiceException(ResponseCode.FAILURE, "单据模块未定义工作流提交信息【workflagtable】配置!");
				JSONObject jsonpara = new JSONObject();
				String sheet="";
				String billdets="";
				for(Map<String, Object> worktable:map){
					String colsql = worktable.get("colsql").toString();
					String sql = colsql.replace("{billno}", bill.getBillno()).replace("{ent_id}", String.valueOf(bill.getEnt_id()));
					Map<String, Object> para = new HashMap<String, Object>();
					para.put("value", sql);
					List<Map<String,Object>> colvalues = storage.getSqlSessionTemplate().selectList("mybatis.sql.select", para);
					if (worktable.get("rowno").toString().equalsIgnoreCase("0")){
						sheet=colvalues.get(0).get("value").toString();
						Map<String,Object> utc = storage.getSqlSessionTemplate().selectOne("mybatis.sql.select_UNIX_TIMESTAMP");
					    String utctime = utc.get("utctime").toString();
					    sheet=sheet+",\"submiter\":\"["+session.getUser_code()+"]"+session.getUser_name()+"\"";
					}else{
						String colname = worktable.get("colname").toString();
						String billdet;
						billdet="["+colname+"]";
						for(Map<String, Object> det:colvalues){
							billdet=billdet + ",["+ det.get("value").toString() +"]";
						}
						if (billdets.isEmpty() || billdets==""){
							billdets="["+billdet+"]";
						}else{
							billdets=billdets + ",["+billdet+"]";
						}
					}
				}
				sheet = "{"+sheet +",\"sheetDetail\":\"["+billdets+"]\"}";
				rtn.put("sheet", sheet);
				rtn.put("processdefkey", processdefkey);
				Criteria cri = Criteria.where("1=1");
				Query queryt = new Query(cri);
//				Map<String,Object> token = storage.selectOne(queryt,"view_workflagtoken");
				Map<String,Object> token = storage.selectOne(queryt,"workflagtoken");
				double expired=Double.parseDouble(token.get("expires_in").toString());
				String lasttime=token.get("lasttime").toString();
				String curtime = sdf.format(new Date());
				String auth = null;
			
				if (DiffDate(curtime,lasttime)<expired){
					String tokenurl = token.get("url").toString();
					String authorization = token.get("authorization").toString();
					String tokenkey = token.get("tokenkey").toString();
					try {
//						String returnstr = HttpUtils.postRequest(tokenurl, "", authorization, "UTF-8");
//						JSONObject tokenjson = JSON.parseObject(returnstr);
						Map paramap = new HashMap<>();
						paramap.put("username", token.get("username").toString());
						paramap.put("password", token.get("password").toString());
						paramap.put("grant_type", token.get("grant_type").toString());
						String[] rtnfields={"access_token","expires_in"};
						JSONObject tokenjson=HttpUtils.postRequestWithAuthorization(tokenurl, paramap, authorization, rtnfields);
						String tokenvalue = tokenjson.getString("access_token");
						Integer expires_in = Integer.valueOf(tokenjson.getString("expires_in"));
						Update updaterun = new Update();
						updaterun.set("token", tokenvalue);
						updaterun.set("expires_in", expires_in);
						updaterun.set("lasttime", curtime);
						Criteria criteriarun = Criteria.where("1=1");
						Query queryrun = new Query(criteriarun);
						storage.update(queryrun, updaterun, "workflagtoken");
						auth =  tokenkey + tokenvalue;
					} catch (IOException e) {
						e.printStackTrace();
						this.getLogger().info("bpm token errors:"+e.getMessage());
					}
				}else{
					auth = token.get("tokenkey").toString()+token.get("token").toString();
				}
				rtn.put("auth", auth);
			} finally {
				if (storage != null)
					storage.destroy();
			}
		} else {
			rtn.put("processdefkey", processdefkey);
			rtn.put("billid", bill.getBillno());
			rtn.put("userid", session.getUser_code());
	
			Object muid = null;
			if (billstatus.equalsIgnoreCase(BillStatus.AUDITING) || billstatus.equalsIgnoreCase(BillStatus.REJECT)) {
				muid = session.getDeptcode();
			} else {
				// 获取单据来源，默认MSS
				Object billsource = null;
				try {
					billsource = AbstractEntityBean.fetchDeclaredField(bill.getClass(), "billsource").get(bill) == null ? "MSS"
							: AbstractEntityBean.fetchDeclaredField(bill.getClass(), "billsource").get(bill);
				} catch (Exception e) {
					billsource = "MSS";
				}
				if (billsource.toString().equalsIgnoreCase("APP")) {
					muid = getmuid(bill, session);
				} else {
					muid = session.getDeptcode();
				}
			}
			rtn.put("unitcode", muid);
			rtn.put("positionid", session.getPostid());
			rtn.put("billimoduleid", bill.getBillmoduleid());
			System.out.println("审批流参数:" + rtn.toString());
			if (getvariable) {
				JSONObject info = getbpmvariable(bill, session);
				info.put("billstatus", billstatus);
				rtn.put("variable", getbpmvariable(bill, session));
			}
		}
		return rtn;
	}

	@Transactional(propagation = Propagation.REQUIRED)
	private Object dobillsubmit(BillAbstractHeadBean bill, ServiceSession session) throws Exception {
		bill.initUpdateMember(session);
		// 加锁检查单据状态
		BillAbstractHeadBean oribill = checkBillStatus(bill);
		if (BillStatus.SUBMIT.equalsIgnoreCase(oribill.getBillstatus()))
			throw new ServiceException(ResponseCode.FAILURE, "[{0}]单据提交,不能重复提交!", oribill.getBillno());
		if (!BillStatus.NEW.equalsIgnoreCase(oribill.getBillstatus()))
			throw new ServiceException(ResponseCode.FAILURE, "[{0}]单据不是未提交状态,不能提交!", oribill.getBillno());
		bill.setBillmoduleid(oribill.getBillmoduleid());
		bill.setBillstatus(BillStatus.SUBMIT);
		bill.setLastmodby(Utils.nvl(session.getUser_code(), oribill.getInputer()));
		bill.setLastmodby_name("[" + Utils.nvl(session.getUser_code(), oribill.getInputer()) + "]" + Utils.nvl(session.getUser_name(), oribill.getInputer_name()));
		// 提交前处理
		// Set<String> keys = beforeBillsubmit(session, bill);
		Set<String> keys = beforeBillsubmit(session, oribill);
		// 得到当前用户信息
		Map<String, Object> bpminfo = getbpminfo(oribill, session, true, BillStatus.SUBMIT);
		BpmService.getBpmService().submit(bpminfo);
		// 更新单据状态
		if (keys == null)
			keys = new HashSet<String>();
		keys.add("billstatus");
		keys.add("ph_timestamp");
		keys.add("lastmodby");
		keys.add("lastmodby_name");
		super.doUpdate(oribill, keys, "billno");
		this.getOperlog().log(bill.getLastmodby(), bill.getLastmodby_name(), "提交", "", bill);
		// 提交后处理
		// Set<String> postkeys = PostBillsubmit(session, bill);
		Set<String> postkeys = PostBillsubmit(session, oribill);
		return null;
	}

      public Set<String> PostBillsubmit(ServiceSession session, BillAbstractHeadBean bill) {
		// TODO Auto-generated method stub
		// 提交后根据billmain配置，将billbpmdesr配置字段更新到bpm任务表的描述字段,billbpmdesr 多字段时用,拼接
		Map<String, Object> billmain = getbillmain(bill);

		if (billmain == null) {
			return null;
		}
		if(!StringUtils.isEmpty(billmain.get("billbpmdesr"))){
			String[] fileds=billmain.get("billbpmdesr").toString().split(",");
			
			Map<String, Object> para = new HashMap<String, Object>();
			para.put("procdefkey_", getprocessdefkey(bill));
			para.put("procinstkey_", bill.getBillno());
			para.put("fields", billmain.get("billbpmdesr").toString());
			SqlSessionTemplate db = getStorageOperations(FMybatisTemplate.class).getSqlSessionTemplate();
			List<Map<String, Object>> list = db.selectList("select_bpmfieldvar", para);
			
			Map<String, String> map=new HashMap<String, String>();
			for(int i=0;i<list.size();i++){
				map.put(list.get(i).get("name_").toString(), list.get(i).get("text_").toString());
			}
			StringBuffer sb=new StringBuffer();
			for(int i=0;i<fileds.length;i++){
				if(!StringUtils.isEmpty(map.get(fileds[i].replaceAll("'", "")))){
					sb.append(map.get(fileds[i].replaceAll("'", "")));
				}
			   
			}
			if(!StringUtils.isEmpty(sb.toString())){
				para.put("description_", sb.toString());
				db.update("upt_billbpmdesc", para);	
			}
			
		}
		return null;
	}

	public Set<String> beforeBillsubmit(ServiceSession session, BillAbstractHeadBean bill) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	@Transactional(propagation = Propagation.REQUIRED)
	public ServiceResponse billsaveandsubmit(ServiceSession session, JSONObject jsonparam) throws Exception {
		ServiceResponse sre = this.add(session, jsonparam.toJSONString());
		if (!sre.getReturncode().equals("0")) {
			return sre;
		}
		JSONObject rtn = (JSONObject) sre.getData();
		long id = (Long) rtn.get(getIdKey());
		JSONObject json = new JSONObject();
		json.put(BeanConstant.QueryField.PARAMKEY_FIELDS, "*"); // 不查子表
		json.put("ent_id", session.getEnt_id());
		json.put(getIdKey(), id);
		T oribill = doSearchOne(json, getBeanClass());
		try {
			dobillsubmit(oribill, session);
		} catch (Exception e) {
			doDelete(oribill, "ph_key");
			return ServiceResponse.buildFailure(session, ResponseCode.FAILURE, "提交审批错误:{0}", e.getMessage());
		}
		JSONObject jsonrtn = new JSONObject();
		jsonrtn.put(getIdKey(), id);
		jsonrtn.put("billno", oribill.getBillno());
		jsonrtn.put("msg", "单据提交成功!");
		return ServiceResponse.buildSuccess(jsonrtn);
	}

	// 审批
	@Transactional(propagation = Propagation.REQUIRED)
	public ServiceResponse billapproval(ServiceSession session, JSONObject jsonparam) throws Exception {
		return billbpmexec(session, jsonparam, BillStatus.AUDITING);
	}

	// 驳回
	@Transactional(propagation = Propagation.REQUIRED)
	public ServiceResponse billreject(ServiceSession session, JSONObject jsonparam) throws Exception {
		return billbpmexec(session, jsonparam, BillStatus.REJECT);
	}

	// 撤回
	@Transactional(propagation = Propagation.REQUIRED)
	public ServiceResponse billrepeal(ServiceSession session, JSONObject jsonparam) throws Exception {
		return billbpmexec(session, jsonparam, BillStatus.NEW);
	}

	// 执行BPM
	@Transactional(propagation = Propagation.REQUIRED)
	public ServiceResponse billbpmexec(ServiceSession session, JSONObject jsonparam, String billstatus) throws Exception {
		// 参数检查
		if (session == null)
			return ServiceResponse.buildFailure(session, ResponseCode.Exception.SESSION_IS_EMPTY);
		if (StringUtils.isEmpty(jsonparam))
			return ServiceResponse.buildFailure(session, ResponseCode.Exception.PARAM_IS_EMPTY);
		if (StringUtils.isEmpty(jsonparam.get("billno")))
			return ServiceResponse.buildFailure(session, ResponseCode.EXCEPTION, "{0} {1} is empty", "", "billno");

		T bean = StorageUtils.parseBeanObject(jsonparam, getBeanClass());
		dobillbpmexec(bean, jsonparam.getString("comment"), jsonparam.getString("taskid"), billstatus, session);
		JSONObject jsonrtn = new JSONObject();
		jsonrtn.put("msg", "单据 [" + jsonparam.get("billno") + "] " + getstatusname(billstatus) + "成功!");
		return ServiceResponse.buildSuccess(jsonrtn);
	}

	public String getstatusname(String billstatus) {
		/*
		 * final String NEW = "N"; //新建 final String AUDIT = "Y"; //审核完毕 final
		 * String CANCEL = "C"; //取消 final String WAIT = "W"; //等待异步审核 final
		 * String EXEC = "T"; //异步审核中 final String AUDITING = "A"; //审批中 final
		 * String SUBMIT = "S"; //提交 final String REJECT = "R"; //驳回
		 */
		if (STATUSNAME.size() <= 0) {
			STATUSNAME.put("N", "撤销");
			// STATUSNAME.put("Y", "已审核");
			// STATUSNAME.put("W", "等待异步审核");
			// STATUSNAME.put("T", "异步审核中");
			STATUSNAME.put("A", "审批");
			STATUSNAME.put("S", "提交");
			STATUSNAME.put("R", "驳回");
		}
		return STATUSNAME.get(billstatus);
	}

	public ServiceResponse gettask(ServiceSession session, JSONObject jsonparam) throws Exception {
		// 参数检查
		if (session == null)
			return ServiceResponse.buildFailure(session, ResponseCode.Exception.SESSION_IS_EMPTY);
		if (StringUtils.isEmpty(jsonparam))
			return ServiceResponse.buildFailure(session, ResponseCode.Exception.PARAM_IS_EMPTY);
		if (StringUtils.isEmpty(jsonparam.get("billno")))
			return ServiceResponse.buildFailure(session, ResponseCode.EXCEPTION, "{0} {1} is empty", "", "billno");

		JSONObject json = new JSONObject();
		json.put(BeanConstant.QueryField.PARAMKEY_FIELDS, "*"); // 不查子表
		json.put("ent_id", session.getEnt_id());
		json.put("billno", jsonparam.get("billno"));
		T oribill = null;
		try {
			oribill = doSearchOne(json, getBeanClass());
		} catch (Exception e1) {
			e1.printStackTrace();
		}
		Map<String, Object> bpmdata = getbpminfo(oribill, session, true, oribill.getBillstatus());
		ServiceResponse resp = BpmService.getBpmService().gettask(bpmdata);
		return resp;
	}

	// 执行BPM
	@Transactional(propagation = Propagation.REQUIRED)
	public Object dobillbpmexec(BillAbstractHeadBean bill, String comment, String taskid, String billstatus, ServiceSession session) throws Exception {
		bill.initUpdateMember(session);
		// 加锁检查单据状态
		String name = getstatusname(billstatus);

		BillAbstractHeadBean oribill = checkBillStatus(bill);
		if (!(oribill.getBillstatus().equalsIgnoreCase(BillStatus.SUBMIT) || oribill.getBillstatus().equalsIgnoreCase(BillStatus.AUDITING)
				|| oribill.getBillstatus().equalsIgnoreCase(BillStatus.REJECT))) {
			throw new ServiceException(ResponseCode.FAILURE, "单据[{0}]只有提交和审批中状态时才能执行{1}!", oribill.getBillno(), name);
		}
		if (oribill.getBillstatus().equalsIgnoreCase(BillStatus.REJECT) && !billstatus.equalsIgnoreCase(BillStatus.NEW)) {
			throw new ServiceException(ResponseCode.FAILURE, "单据[{0}]已被驳回,不能执行{1}操作!", oribill.getBillno(), name);
		}
		bill.setBillmoduleid(oribill.getBillmoduleid());
		bill.setBillstatus(billstatus);
		bill.setLastmodby(Utils.nvl(session.getUser_code(), oribill.getInputer()));
		bill.setLastmodby_name("[" + Utils.nvl(session.getUser_code(), oribill.getInputer()) + "]" + Utils.nvl(session.getUser_name(), oribill.getInputer_name()));
		// 提交前处理
		Set<String> keys = null;
		Map<String, Object> bpminfo = null;
		// 得到审批信息 撤销不需要传递参数
		// if (billstatus.equalsIgnoreCase(BillStatus.NEW)) {
		// bpminfo = getbpminfo(oribill, session, false, billstatus);
		// } else {
		bpminfo = getbpminfo(oribill, session, true, billstatus);
		// }
		bpminfo.put("comment", comment);
		// bpminfo.put("taskid", taskid);

		// 是否有sbid
		Object sbid = null;
		try {
			sbid = AbstractEntityBean.fetchDeclaredField(oribill.getClass(), "sbid").get(oribill);
		} catch (Exception e) {

		}

		ServiceResponse resp = null;
		if (billstatus.equalsIgnoreCase(BillStatus.AUDITING)) {
			resp = BpmService.getBpmService().approval(bpminfo);
		} else if (billstatus.equalsIgnoreCase(BillStatus.REJECT)) {

			BpmService.getBpmService().reject(bpminfo);
			notification(oribill, billstatus);
		} else if (billstatus.equalsIgnoreCase(BillStatus.NEW)) {
			BpmService.getBpmService().repeal(bpminfo);
		}

		// 更新单据状态
		if (keys == null)
			keys = new HashSet<String>();
		keys.add("billstatus");
		keys.add("ph_timestamp");
		keys.add("lastmodby");
		keys.add("lastmodby_name");
		super.doUpdate(bill, keys, "billno");
		this.getOperlog().log(bill.getLastmodby(), bill.getLastmodby_name(), name, comment, bill);

		if (billstatus.equalsIgnoreCase(BillStatus.AUDITING)) {
			if (resp != null && resp.getData() != null && !resp.getData().equals("")) {
				JSONObject json = JSONObject.parseObject(resp.getData().toString());
				String islast = json.getString("islast");
				if (islast.equals("Y")) {
					doBillAudit(oribill, session, true);
					notification(oribill, billstatus);
				}
			}
		}

		return null;
	}

	// 执行BPM
	@Transactional(propagation = Propagation.REQUIRED)
	public Object dobillthirdbpmexec(BillAbstractHeadBean bill, String billstatus, ServiceSession session, String lastflag) throws Exception {
		bill.initUpdateMember(session);
		// 加锁检查单据状态
		String name = getstatusname(billstatus);

		BillAbstractHeadBean oribill = checkBillStatus(bill);
		if (!(oribill.getBillstatus().equalsIgnoreCase(BillStatus.SUBMIT) || oribill.getBillstatus().equalsIgnoreCase(BillStatus.AUDITING)
				|| oribill.getBillstatus().equalsIgnoreCase(BillStatus.REJECT))) {
			throw new ServiceException(ResponseCode.FAILURE, "单据[{0}]只有提交和审批中状态时才能执行{1}!", oribill.getBillno(), name);
		}
		if (oribill.getBillstatus().equalsIgnoreCase(BillStatus.REJECT) && !billstatus.equalsIgnoreCase(BillStatus.NEW)) {
			throw new ServiceException(ResponseCode.FAILURE, "单据[{0}]已被驳回,不能执行{1}操作!", oribill.getBillno(), name);
		}
		bill.setBillmoduleid(oribill.getBillmoduleid());
		bill.setBillstatus(billstatus);
		bill.setLastmodby(Utils.nvl(session.getUser_code(), oribill.getInputer()));
		bill.setLastmodby_name("[" + Utils.nvl(session.getUser_code(), oribill.getInputer()) + "]" + Utils.nvl(session.getUser_name(), oribill.getInputer_name()));
		// 提交前处理
		Set<String> keys = null;

		// 更新单据状态
		if (keys == null)
			keys = new HashSet<String>();
		keys.add("billstatus");
		keys.add("ph_timestamp");
		keys.add("lastmodby");
		keys.add("lastmodby_name");
		super.doUpdate(bill, keys, "billno");
		this.getOperlog().log(bill.getLastmodby(), bill.getLastmodby_name(), name, "", bill);

		if (billstatus.equalsIgnoreCase(BillStatus.AUDITING) && lastflag.equalsIgnoreCase("Y")) {
			doBillAudit(oribill, session, false);
		}

		return null;
	}

	@Transactional(propagation = Propagation.REQUIRED)
	public void notification(BillAbstractHeadBean bill, String billstatus) {
		// 单据分为两种，如果是APP来源的，需要发送给租户
		String billsource = null;
		try {
			billsource = AbstractEntityBean.fetchDeclaredField(bill.getClass(), "billsource").get(bill) == null ? BillSource.MSS
					: AbstractEntityBean.fetchDeclaredField(bill.getClass(), "billsource").get(bill).toString();
		} catch (Exception e) {
			billsource = BillSource.MSS;
		}
		String title, notiinfo, userid, Notitype, postid;
		if (billstatus.equalsIgnoreCase(BillStatus.AUDITING)) {
			title = "单据审批提醒";
			notiinfo = "单号【" + bill.getBillno() + "】已审批通过";
			Notitype = "单据审批提醒";
		} else if (billstatus.equalsIgnoreCase(BillStatus.REJECT)) {
			title = "单据审批提醒";
			notiinfo = "单号【" + bill.getBillno() + "】已被驳回";
			Notitype = "单据审批提醒";
		} else {
			return;
		}
		if (billsource.equalsIgnoreCase(BillSource.APP)) {
			try {
				userid = AbstractEntityBean.fetchDeclaredField(bill.getClass(), "sbid").get(bill).toString();
			} catch (Exception e) {
				userid = bill.getInputer();
			}
			postid = "99999999";
		} else {
			userid = bill.getInputer();
			postid = "0";
		}
		insertnotification(postid, userid, bill.getBillmoduleid(), bill.getBillno(), notiinfo, title, Notitype);
	}

	@Transactional(propagation = Propagation.REQUIRED)
	public void insertnotification(String postid, String userid, String moduleid, String billno, String notiinfo, String title, String Notitype) {
		FMybatisTemplate storage = null;
		try {
			// 得到数据源
			storage = getStorageOperations(FMybatisTemplate.class);

			String sql = "CALL DBUSRPUB.INSERT_NOTIFICATION(" + "'" + postid + "'," + "'" + userid + "'," + "'" + moduleid + "'," + "'" + billno + "'," + "'" + notiinfo + "'," + "'" + title + "',"
					+ "'" + Notitype + "'" + ")";
			Map<String, String> map = new HashMap<String, String>();
			map.put("value", sql);
			storage.getSqlSessionTemplate().insert("mybatis.sql.insert", map);

		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * 如果没有主键,可以按billno查询
	 */
	@Override
	public ServiceResponse get(ServiceSession session, JSONObject jsonparam) throws Exception {
		try {
			// 参数检查
			if (session == null)
				return ServiceResponse.buildFailure(session, ResponseCode.Exception.SESSION_IS_EMPTY);
			if (StringUtils.isEmpty(jsonparam))
				return ServiceResponse.buildFailure(session, ResponseCode.Exception.PARAM_IS_EMPTY);

			String idkey = getIdKey();
			String table = getBeanTable();
			if (!jsonparam.containsKey(idkey) || StringUtils.isEmpty(jsonparam.get(idkey))) {
				if (!jsonparam.containsKey("billno") || StringUtils.isEmpty(jsonparam.get("billno"))) {
					return ServiceResponse.buildFailure(session, ResponseCode.Exception.SPECDATA_IS_EMPTY, "{0} {1} is empty", table, idkey);
				}

			}

			// 按ID查询
			jsonparam.put("ent_id", session.getEnt_id());

			// 查询
			Object obj = null;
			if (StringUtils.isEmpty(jsonparam.get(BeanConstant.QueryField.PARAMKEY_FIELDS)))
				obj = doSearchOne(jsonparam, getBeanClass());
			else
				obj = doSearchOneForMap(jsonparam, getBeanClass());
			if (obj == null)
				return ServiceResponse.buildFailure(session, ResponseCode.Failure.NOT_EXIST, "{0} {1} [{2}] does not exist", table, idkey, jsonparam.getLong(idkey));

			// 返回应答对象
			JSONObject respdata = new JSONObject();
			respdata.put(table, obj);
			return ServiceResponse.buildSuccess(respdata);
		} catch (ServiceException ex) {
			this.getLogger().error(ex.getMessage(), ex);
			return ServiceResponse.buildFailure(session, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs());
		}
	}

	@Transactional(propagation = Propagation.REQUIRED)
	public void sendmsg(BillAbstractHeadBean bill) {
		String mktcol = null, mkt = null, sendflag = "N";

		Map<String, Object> billmain = getbillmain(bill);
		
		if (billmain == null) {
			return;
		}
		
		mktcol = billmain.get("billmktcol") == null ? "" : billmain.get("billmktcol").toString();
		sendflag = billmain.get("billissendmsg") == null ? "N" : billmain.get("billissendmsg").toString();
		if (mktcol != null && !mktcol.isEmpty() && sendflag != null && !sendflag.isEmpty() && sendflag.equals("Y")) {
			try {
				mkt = AbstractEntityBean.fetchDeclaredField(bill.getClass(), mktcol.toLowerCase()).get(bill).toString();
			} catch (Exception e) {
				e.printStackTrace();
				return;
			}
			if (mkt != null && !mkt.isEmpty()) {
				Map<String, String> map = new HashMap<String, String>();
				map.put("muid", mkt);
				map.put("moduleid", bill.getBillmoduleid());
				SqlSessionTemplate db = getStorageOperations(FMybatisTemplate.class).getSqlSessionTemplate();
				List<Map<String, Object>> list = db.selectList("select_billauditor", map);
				// 根据门店，模块，找到对应有审核按钮权限的人
				String title, notiinfo, userid = null, Notitype, postid = null;
				for (Map<String, Object> auditor : list) {
					postid = auditor.get("postid").toString();
					userid = auditor.get("userid").toString();
					if (bill.getBillstatus().equalsIgnoreCase(BillStatus.NEW)) {
						title = "单据审批提醒";
						notiinfo = "单号【" + bill.getBillno() + "】待审批";
						Notitype = "单据审批提醒";
					} else {
						return;
					}

					insertnotification(postid, userid, bill.getBillmoduleid(), bill.getBillno(), notiinfo, title, Notitype);
				}

			}

		}

	}
	//获取单据的提交人
	/**
	 * 获取提交人信息
	 */
	public ServiceResponse getBillSubmitter(ServiceSession session, JSONObject jsonparam) throws Exception {
		try {
			// 参数检查
			if (session == null)
				return ServiceResponse.buildFailure(session, ResponseCode.Exception.SESSION_IS_EMPTY);
			if (StringUtils.isEmpty(jsonparam))
				return ServiceResponse.buildFailure(session, ResponseCode.Exception.PARAM_IS_EMPTY);
			FMybatisTemplate storage = (FMybatisTemplate) getStorageOperations();
			String billno = (String)jsonparam.get("billno");
			String moduleid = (String)jsonparam.get("moduleid");
			
			String sql_submiter="select ta.TEXT_ from dbusrpub.act_ru_variable ta, dbusrpub.act_ru_task tb "+
					" where ta.execution_id_ = tb.EXECUTION_ID_ and ta.proc_inst_id_ = tb.proc_inst_id_ "+
					" and tb.procdefkey_ LIKE '%"+moduleid+"%' "+
					" and tb.procinstkey_ ='"+billno+"' "+
					" and ta.name_ ='startUserInfo' ";
		    
   	    	Map<String, Object> map0 = new HashMap<String, Object>();
   	    	map0.put("value", sql_submiter);
   	    	List<Map<String, Object>> list = storage.getSqlSessionTemplate().selectList("mybatis.sql.select", map0);
   	    	JSONObject respdata = new JSONObject();
   	    	if (list != null && list.size() > 0) {
   	    		respdata.put("submitter", list.get(0).get("TEXT_").toString().split(";")[0]);
   	    	}
			return ServiceResponse.buildSuccess(respdata);
		} catch (ServiceException ex) {
			this.getLogger().error(ex.getMessage(), ex);
			return ServiceResponse.buildFailure(session, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs());
		}
	}
	// 保存单据
	@Override
	@Transactional(propagation = Propagation.REQUIRED)
	public ServiceResponse save(ServiceSession session, String param) throws Exception {
		ServiceResponse res = super.save(session, param);
// 杉杉需求，保存后给有审核权限的人发消息，会员营销有些库没有billmain配置表，先屏蔽，杉杉发布时需放开
//		Object obj = JSON.parse(param);
//		JSONArray jsonarray = null;
//		if (obj instanceof JSONArray)
//			jsonarray = (JSONArray) obj;
//		else if (obj instanceof JSONObject) {
//			jsonarray = ((JSONObject) obj).getJSONArray(getBeanTable());
//			if (jsonarray == null) {
//				jsonarray = new JSONArray();
//				jsonarray.add(obj);
//			}
//		}
//		if (!StringUtils.isEmpty(jsonarray) && !StringUtils.isEmpty(jsonarray.get(0)) && !StringUtils.isEmpty(((JSONObject) jsonarray.get(0)).get("flag"))&&!((JSONObject) jsonarray.get(0)).getString("flag").equalsIgnoreCase("D")) {
//			JSONArray array = (JSONArray) res.getData();
//			JSONObject json = new JSONObject();
//			json.put(BeanConstant.QueryField.PARAMKEY_FIELDS, "*"); // 不查子表
//			json.put("ent_id", session.getEnt_id());
//			json.put(getIdKey(), ((JSONObject) array.get(0)).get(getIdKey()));
//			T oribill = doSearchOne(json, getBeanClass());
//			sendmsg(oribill);
//		}

		return res;
	}
	public double DiffDate(String curdate , String comparedate) throws ParseException  {
		java.util.Date now = sdf.parse(curdate);
		java.util.Date date=sdf.parse(comparedate);
		long l=now.getTime()-date.getTime();
		long day=l/(24*60*60*1000);

		long hour=(l/(60*60*1000)-day*24);

		long min=((l/(60*1000))-day*24*60-hour*60);
		long s=(l/1000-day*24*60*60-hour*60*60-min*60);
		return s;
	}
}
