/**
 * Copyright (C), 2007-2015, eFuture 北京富基融通科技有限公司
 * FileName:	TopicHead.java
 * Author:		亮
 * Date:		2015-7-8 下午2:55:15
 * Description:	
 * History:
 * <author>		<time>			<version>		<description>
 * 
 */
package com.efuture.ocp.common.billservice;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.ibatis.session.RowBounds;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.util.StringUtils;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.component.BasicComponent;
import com.efuture.ocp.common.entity.BeanConstant;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.language.ResponseCode;
import com.efuture.ocp.common.util.GlobPara;
import com.efuture.ocp.common.util.UniqueID;
import com.efuture.omd.storage.FMybatisTemplate;
import com.efuture.omd.storage.FStorageOperations;
import com.efuture.omd.storage.mybatis.HashMapCase;
import com.github.pagehelper.Page;

/**
 * @author 亮
 * @description
 * 
 */
public class ReportServiceImpl extends BasicComponent implements ReportService {

	@Override
	public ServiceResponse query(ServiceSession session, JSONObject jsonparam) throws Exception {
		return query(session, jsonparam, "report");
	}
	@Override
	public ServiceResponse query(ServiceSession session, JSONObject jsonparam, String datakey) throws Exception {
		// 参数检查
		if (session == null)
			return ServiceResponse.buildFailure(session, ResponseCode.Exception.SESSION_IS_EMPTY);
		if (StringUtils.isEmpty(jsonparam))
			return ServiceResponse.buildFailure(session, ResponseCode.Exception.PARAM_IS_EMPTY);
		if (StringUtils.isEmpty(jsonparam.get("queryid")))
			return ServiceResponse.buildFailure(session, ResponseCode.EXCEPTION, "{0} {1} is empty", "", "queryid");

		// 分页参数
		int pageno = -1, pagesize = 40;
		if (jsonparam.containsKey(BeanConstant.QueryField.PARAMKEY_PAGENO)
				&& !StringUtils.isEmpty(jsonparam.get(BeanConstant.QueryField.PARAMKEY_PAGENO))) {
			pageno = jsonparam.getInteger(BeanConstant.QueryField.PARAMKEY_PAGENO);
			if (pageno <= 0)
				pageno = 1;
			jsonparam.remove(BeanConstant.QueryField.PARAMKEY_PAGENO);
		}
		if (jsonparam.containsKey(BeanConstant.QueryField.PARAMKEY_PAGESIZE)
				&& !StringUtils.isEmpty(jsonparam.get(BeanConstant.QueryField.PARAMKEY_PAGESIZE))) {
			pagesize = jsonparam.getInteger(BeanConstant.QueryField.PARAMKEY_PAGESIZE);
			if (pagesize <= 0)
				pagesize = 40;
			// if (pagesize > 100) pagesize = 100;
			if (pagesize > 10000)
				pagesize = 10000;
			jsonparam.remove(BeanConstant.QueryField.PARAMKEY_PAGESIZE);

			if (pageno <= 0)
				pageno = 1;
		}
		RowBounds rowBounds = null;
		if (pageno >= 1)
			rowBounds = new RowBounds((pageno - 1) * pagesize, pagesize);

		// 转换查询条件
		Map<String, Object> map = new HashMapCase<String, Object>();
		map.put("ent_id", session.getEnt_id());
		for (String key : jsonparam.keySet())
			map.put(key, jsonparam.get(key));

		// 执行SQL查询
		StringBuffer total = new StringBuffer();
		JSONObject json = new JSONObject();
		json.put(datakey, doQuery(jsonparam.getString("queryid"), map, rowBounds, total));
		if (total.toString() != "") {
			json.put("total_results", total.toString());
		} else {
			json.put("total_results", "0");
		}
		return ServiceResponse.buildSuccess(json);
	}

	@SuppressWarnings("rawtypes")
	protected List<Map<String, Object>> doQuery(String queryid, Object param, RowBounds rowBounds, StringBuffer total) {
		FMybatisTemplate storage = null;
		try {
			// 得到数据源
			storage = getStorageOperations(FMybatisTemplate.class);
			SqlSessionTemplate db = storage.getSqlSessionTemplate();

			// 查询
			if (rowBounds == null) {
				List<Map<String, Object>> list = db.selectList(queryid, param);
				// total.append(list.size());
				return list;
			} else {
				// PageHelper.startPage(rowBounds.getOffset()/rowBounds.getLimit()+1,
				// rowBounds.getLimit());
				List<Map<String, Object>> list = db.selectList(queryid, param, rowBounds);
				if (total != null) {
					total.append(((Page) list).getTotal());
				}
				return list;
			}
		} finally {
			if (storage != null)
				storage.destroy();
		}
	}

	// 导出
	public String export(ServiceSession session, JSONObject jsonparam) throws Exception {
		// 参数检查
		if (session == null)
			throw new ServiceException(ResponseCode.Exception.SESSION_IS_EMPTY, "session is empty");
		if (StringUtils.isEmpty(jsonparam))
			throw new ServiceException(ResponseCode.Exception.PARAM_IS_EMPTY, "param is empty");

		// 导出必须指定字段
		if (StringUtils.isEmpty(jsonparam.get(BeanConstant.QueryField.PARAMKEY_FIELDS)))
			throw new ServiceException(ResponseCode.EXCEPTION, "{0} {1} is empty", "",
					BeanConstant.QueryField.PARAMKEY_FIELDS);

		// 解析字段名
		// fields="fld1:XXXX:fmt,fld2:XXXXX:fmt,fld3:XXXXX:fmt";
		StringBuffer flds = new StringBuffer();
		List<String> fldlst = new ArrayList<String>();
		Map<String, String> disps = new HashMap<String, String>();
		Map<String, String> fmts = new HashMap<String, String>();
		analyzeExportFields(jsonparam.getString(BeanConstant.QueryField.PARAMKEY_FIELDS), flds, fldlst, disps, fmts);
		jsonparam.put(BeanConstant.QueryField.PARAMKEY_FIELDS, flds.toString());

		// 查询全部数据导出
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("ent_id", session.getEnt_id());
		for (String key : jsonparam.keySet())
			map.put(key, jsonparam.get(key));
		List<Map<String, Object>> list = doQuery(jsonparam.getString("queryid"), map, null, null);

		// 生成XLS文件的XML
		return createExportXLS(list, fldlst, disps, fmts);
	}
}
