/**
 * Copyright (C), 2007-2014, eFuture 北京富基融通科技有限公司
 * FileName:	BaseServiceIntf.java
 * Author:		亮
 * Date:		2014-8-22 下午4:49:17
 * Description:	
 * History:
 * <author>		<time>			<version>		<description>
 * 
 */
package com.efuture.ocp.common.component;

import java.util.Set;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.entity.AbstractEntityBean;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;

/**
 * @author		亮
 * @description	
 * 
 */
public interface BaseServiceIntf
{
    // 新增
    ServiceResponse add(ServiceSession session,String param) throws Exception;   
    long doAdd(AbstractEntityBean bean,String id,String... uniques) throws Exception;
    
    // 修改
    ServiceResponse update(ServiceSession session,String param) throws Exception;
    Object doUpdate(AbstractEntityBean bean,Set<String> keys,String id,String... uniques) throws Exception;
    
    // 删除
    ServiceResponse delete(ServiceSession session,String param) throws Exception;
    Object doDelete(AbstractEntityBean bean,String id,String... keys) throws Exception;
    
    // 批量保存
    ServiceResponse save(ServiceSession session,String param) throws Exception;
    JSONArray doSave(ServiceSession session, JSONArray jsonarray) throws Exception;
    
    // 获取单行数据
    ServiceResponse get(ServiceSession session,JSONObject jsonparam) throws Exception;

    // 条件分页查询
    ServiceResponse search(ServiceSession session,JSONObject jsonparam) throws Exception;
    
    // 按父ID查询子集合
    ServiceResponse getchildren(ServiceSession session, JSONObject jsonparam) throws Exception;
    
    // 通用EXCEL导出
    Object export(ServiceSession session, JSONObject jsonparam) throws Exception;
}
