/**
 * Copyright (C), 2007-2016, eFuture 北京富基融通科技有限公司 FileName: ExecutorWrapper.java
 * Author: F Date: 2016年2月2日 下午2:19:08 Description: History: <author> <time>
 * <version> <description>
 * 
 */
package com.efuture.ocp.common.filter;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;


import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.MappedStatement.Builder;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.log4j.Logger;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.ast.statement.SQLUnionQueryTableSource;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlOutputVisitor;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectQueryBlock;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleOutputVisitor;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitorAdapter;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.user.UserDataRangeSrv;
import com.efuture.ocp.user.DataRange;


/**
 * @author F
 * @description
 * 
 */
@Intercepts(
{
    @Signature(type = Executor.class, method = "query", args =
    {
            MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class
    })
})
public class ExecutorWrapper implements Interceptor
{

    private static Logger sqlLog = Logger.getLogger("sqlLog");
    private String dbType;

    @Override
    public Object intercept(Invocation invocation) throws Throwable
    {
        // sqlLog.info("invoke intercept");
        /**
         * 如果当前上下文设置不执行数据范围,则直接返回执行
         */
        if (!UserDataRangeSrv.getlocalisrange()) { return invocation.proceed(); }
        MappedStatement mappedStatement = (MappedStatement) invocation.getArgs()[0];
        String sql = "";

        Object parameter = null;
        if (invocation.getArgs().length > 1)
        {
            parameter = invocation.getArgs()[1];
        }

        BoundSql boundSql = mappedStatement.getBoundSql(parameter);
        sql = boundSql.getSql();
        boolean isexec = false;

        List<DataRange> authList = getdatarange();
        if (null == authList || authList.size() < 1) { return invocation.proceed(); }
        for (DataRange dr : authList)
        {
            if (sql.toLowerCase().indexOf(dr.getTablename()) != -1)
            {
                isexec = true;
                break;
            }
        }

        if (!isexec) { return invocation.proceed(); }
        try
        {
            JSONObject logJson = new JSONObject();
            List<SQLStatement> statementList = SQLUtils.toStatementList(sql, this.dbType);
            for (SQLStatement stmt : statementList)
            {
                if (stmt instanceof SQLSelectStatement)
                {
                    SQLSelectStatement selectStmt = (SQLSelectStatement) stmt;
                    logJson.put("selectSql", sql);
                    if (selectStmt.getSelect().getQuery() instanceof SQLUnionQuery)
                    {
                        logJson.put("result", getUnionSqlInfo((SQLUnionQuery) selectStmt.getSelect().getQuery(), 1));
                    }
                    else
                    {
                        logJson.put("result", getSqlInfo((SQLSelectQueryBlock) selectStmt.getSelect().getQuery()));
                    }

                    // 给sql赋值
                    StringBuffer newSql = new StringBuffer();
                    SQLASTOutputVisitor visitor = null;
                    if (this.dbType.equals("mysql"))
                    {
                        visitor = new MySqlOutputVisitor(newSql);
                    }
                    else if (this.dbType.equals("oracle"))
                    {
                        visitor = new OracleOutputVisitor(newSql);
                    }
                    else
                    {
                        throw new Exception("未识别的dbType");
                    }
                    visitor.visit(selectStmt);
                    visitor.println();
                    visitor.endVisit(selectStmt);
                    //final Object[] args = invocation.getArgs();
                    //args[1] = processParameter(mappedStatement, parameter,boundSql);
                    
                    SqlSource sqlSource = new FtSqlSource(mappedStatement.getConfiguration(), newSql.toString(), boundSql);
                    MappedStatement newMs = copyFromMappedStatement(mappedStatement, sqlSource);

                    invocation.getArgs()[0] = newMs;
                    
                    logJson.put("newSql", newSql.toString());

                    sqlLog.info(logJson.toJSONString());
                }

            }

        }
        catch (Exception e)
        {
            invocation.getArgs()[0] = mappedStatement;
            JSONObject errorJson = new JSONObject();
            errorJson.put("unresolved sql", sql);
            sqlLog.error(errorJson.toJSONString());
            e.printStackTrace();
        }
        return invocation.proceed();
    }

    @Override
    public Object plugin(Object target)
    {
        return Plugin.wrap(target, this);
    }

    @Override
    public void setProperties(Properties properties)
    {
        this.dbType = properties.getProperty("dbType");
        if (this.dbType == null || this.dbType.equals(""))
        {
            this.dbType = "mysql";
        }
    }

    private List<DataRange> getdatarange()
    {

        List<DataRange> listdr = UserDataRangeSrv.getlocaldatarange();
        return listdr;
    }

    public JSONObject getSqlInfo(SQLSelectQuery selectQuery) throws Exception
    {
        JSONObject resultJson = new JSONObject();
        SQLSelectQueryBlock query = (SQLSelectQueryBlock) selectQuery;
        resultJson.put("selectField", getSelectField(query.getSelectList()));
        // resultJson.put("selectOrderBy", getOrderBy(query.getOrderBy()));
        resultJson.put("selectGroupBy", query.getGroupBy() == null ? null : query.getGroupBy().toString());
        JSONObject tableJson = getTableInfo(query.getFrom(), query);

        return tableJson;
    }

    private String getSelectField(List<SQLSelectItem> sqlSelectList)
    {
        String selectFields = "";
        for (int i = 0; i < sqlSelectList.size(); i++)
        {
            SQLSelectItem item = sqlSelectList.get(i);
            if (item.getExpr() instanceof SQLAggregateExpr)
            {
                SQLAggregateExpr expr = (SQLAggregateExpr) item.getExpr();
                String methodName = expr.getMethodName();
                selectFields += methodName + "(";
                List<SQLExpr> args = expr.getArguments();
                for (int j = 0; j < args.size(); j++)
                {
                    selectFields += args.get(j).toString() + ",";
                }
                selectFields += ")";
            }
            else if (item.getExpr() instanceof SQLQueryExpr)
            {
                // 没找到逆转成sql的方法。。
                selectFields += item.getExpr() + ",";
            }
            else
            {
                selectFields += item.getExpr().toString() + ",";
            }
        }
        if (!selectFields.equals(""))
        {
            selectFields.substring(0, selectFields.length() - 1);
        }
        return selectFields;
    }

    private String getOrderBy(SQLOrderBy sqlOrderBy)
    {
        String orderBy = null;
        for (int i = 0; sqlOrderBy != null && i < sqlOrderBy.getItems().size(); i++)
        {
            if (orderBy == null)
            {
                orderBy = "";
            }
            SQLSelectOrderByItem item = sqlOrderBy.getItems().get(i);
            orderBy += item.getExpr() + " " + item.getType();
            if (i <= sqlOrderBy.getItems().size() - 1)
            {
                orderBy += ",";
            }
        }
        return orderBy;
    }

    public JSONObject getUnionSqlInfo(SQLUnionQuery selectQuery, int sqlseq) throws Exception
    {
        JSONObject sqlJson = new JSONObject();
        sqlJson.put("sql" + sqlseq, getSqlInfo(selectQuery.getLeft()));
        sqlseq++;
        if (selectQuery.getRight() instanceof SQLUnionQuery)
        {
            sqlJson.putAll(getUnionSqlInfo((SQLUnionQuery) selectQuery.getRight(), sqlseq));
        }
        else if (selectQuery.getRight() instanceof SQLSelectQueryBlock)
        {
            sqlJson.put("sql" + sqlseq, getSqlInfo(selectQuery.getRight()));
        }
        return sqlJson;
    }

    public JSONObject getTableInfo(SQLTableSource tableSrc, SQLSelectQueryBlock query) throws Exception
    {
        JSONObject tableJson = new JSONObject();
        JSONObject resultJson = new JSONObject();
        // 如果是一般查询
        if (tableSrc instanceof SQLExprTableSource)
        {
            SQLExpr expr = ((SQLExprTableSource) tableSrc).getExpr();
            if (expr instanceof SQLIdentifierExpr)
            {
                SQLIdentifierExpr expr1 = (SQLIdentifierExpr) expr;
                tableJson.put("selectTable", expr1.getName());
            }
            else
            {
                SQLPropertyExpr expr1 = (SQLPropertyExpr) ((SQLExprTableSource) tableSrc).getExpr();
                tableJson.put("selectTable", expr1.getName());
            }
            tableJson.put("selectTableAlias", tableSrc.getAlias() == null ? "" : tableSrc.getAlias());
            resultJson.put("selectTable", tableJson);
            resultJson.put("selectWhere", modifyWhereExpr(tableJson, query));
            return resultJson;
        }
        else if (tableSrc instanceof SQLSubqueryTableSource)
        { // 如果是子查询
            SQLSelectQueryBlock selectQuery = (SQLSelectQueryBlock) ((SQLSubqueryTableSource) tableSrc).getSelect().getQuery();
            tableJson.put("selectField", getSelectField(selectQuery.getSelectList()));
            // tableJson.put("selectOrderBy",
            // getOrderBy(selectQuery.getOrderBy()));
            tableJson.put("selectGroupBy", selectQuery.getGroupBy() == null ? null : selectQuery.getGroupBy().toString());
            JSONObject tempTableJson = getTableInfo(selectQuery.getFrom(), selectQuery);
            /*
             * by zhouwd 放入方法内部处理 tableJson.put("selectTable", tempTableJson);
             * tableJson.put("selectTableAlias", tableSrc.getAlias() == null ?
             * "" : tableSrc.getAlias()); tableJson.put("selectWhere",
             * modifyWhereExpr(tempTableJson, selectQuery));
             */
            return tempTableJson;
        }
        else if (tableSrc instanceof SQLJoinTableSource)
        { // 如果是关联查询
            SQLTableSource left = ((SQLJoinTableSource) tableSrc).getLeft();
            SQLTableSource right = ((SQLJoinTableSource) tableSrc).getRight();
            tableJson.put("leftTable", getTableInfo(left, query));
            tableJson.put("rightTable", getTableInfo(right, query));
            tableJson.put("join", ((SQLJoinTableSource) tableSrc).getJoinType());
            return tableJson;
        }
        else if (tableSrc instanceof SQLUnionQueryTableSource)
        { // 如果是union查询
            SQLUnionQuery selectQuery = (SQLUnionQuery) ((SQLUnionQueryTableSource) tableSrc).getUnion();
            tableJson.putAll(getUnionSqlInfo(selectQuery, 1));
            return tableJson;
        }
        return tableJson;
    }

    private SQLExpr getWhereInfo(String whereSql)
    {

        SQLStatementParser parser = new SQLStatementParser("select * from test where " + whereSql);
        SQLStatement stmt = parser.parseStatement();
        SQLSelectStatement selectStmt = (SQLSelectStatement) stmt;
        SQLSelectQueryBlock query = (SQLSelectQueryBlock) selectStmt.getSelect().getQuery();
        return query.getWhere();
    }

    private String modifyWhereExpr(JSONObject tableJson, SQLSelectQueryBlock query)
    {
        // 如果没有selectTable，则查找leftTable和rightTable
        Object tableName = tableJson.get("selectTable");
        Object tableNameAlias = tableJson.get("selectTableAlias");
        if (tableName == null)
        {
            tableName = tableJson.get("leftTable");
            modifyWhereExpr((JSONObject) tableName, query);

            tableName = tableJson.get("rightTable");
            modifyWhereExpr((JSONObject) tableName, query);
        }
        else
        {
            // 当tableName为JSON，并且还有selectTable存在时，判断当前query的selectTable是否是子查询，不是则不进入
            if (tableName instanceof JSONObject)
            {
                if (((JSONObject) tableName).containsKey("selectTable"))
                {
                    if (!(query.getFrom() instanceof SQLSubqueryTableSource))
                    {
                        modifyWhereExpr((JSONObject) tableName, query);
                    }

                }

            }
        }

        // 如果没有selectTable说明是关联查询，则不进行sql修改
        if (tableName != null)
        {
            String thistable = (String) tableName;
            SQLExpr newWhereExpr = new SQLBinaryOpExpr();
            List<DataRange> authList = getdatarange();
            for (DataRange dr : authList)
            {

                String authTableName = dr.getTablename();
                String authWhereSql = dr.getWherestr();

                if (thistable.equalsIgnoreCase(authTableName))
                {
                    authWhereSql = authWhereSql.replaceAll("@", (tableNameAlias == null || tableNameAlias.equals("")) ? tableName.toString() : tableNameAlias.toString());

                    SQLExpr authWhereExpr = getWhereInfo(authWhereSql);
                    if (query.getWhere() != null && query.getWhere() instanceof SQLBinaryOpExpr)
                    {
                        SQLBinaryOpExpr whereExpr = (SQLBinaryOpExpr) query.getWhere();
                        if (whereExpr != null)
                        {
                            ((SQLBinaryOpExpr) newWhereExpr).setOperator(SQLBinaryOperator.BooleanAnd);
                            ((SQLBinaryOpExpr) newWhereExpr).setLeft(whereExpr);
                            ((SQLBinaryOpExpr) newWhereExpr).setRight(authWhereExpr);
                        }
                    }
                    else
                    {
                        newWhereExpr = authWhereExpr;
                    }
                    query.setWhere(newWhereExpr);
                }
            }
        }

        StringBuffer whereStr = new StringBuffer();

        if (query.getWhere() != null)
        {
        	SQLASTVisitorAdapter v = null;
        	if(query instanceof OracleSelectQueryBlock) {
        		v = new OracleOutputVisitor(whereStr);
        	} else {
        		v = new SQLASTOutputVisitor(whereStr);
        	}
            query.getWhere().accept(v);
        }
        return whereStr.toString();
    }

    /**
     * 复制MappedStatement对象
     */
    private MappedStatement copyFromMappedStatement(MappedStatement ms, SqlSource newSqlSource)
    {
        Builder builder = new Builder(ms.getConfiguration(), ms.getId(), newSqlSource, ms.getSqlCommandType());

        builder.resource(ms.getResource());
        builder.fetchSize(ms.getFetchSize());
        builder.statementType(ms.getStatementType());
        builder.keyGenerator(ms.getKeyGenerator());
        builder.keyProperty(ms.getKeyProperties() == null ? null : ms.getKeyProperties()[0]);
        builder.timeout(ms.getTimeout());
        builder.parameterMap(ms.getParameterMap());
        builder.resultMaps(ms.getResultMaps());
        builder.resultSetType(ms.getResultSetType());
        builder.cache(ms.getCache());
        builder.flushCacheRequired(ms.isFlushCacheRequired());
        builder.useCache(ms.isUseCache());

        return builder.build();
    }
    
    public  Map<String, Object> processParameter(MappedStatement ms, Object parameterObject, BoundSql boundSql) {
        Map paramMap = null;
        if (parameterObject == null) {
            paramMap = new HashMap();
        } else if (parameterObject instanceof Map) {
            //解决不可变Map的情况
            paramMap = new HashMap();
            paramMap.putAll((Map) parameterObject);
        } else {
            paramMap = new HashMap();
            //动态sql时的判断条件不会出现在ParameterMapping中，但是必须有，所以这里需要收集所有的getter属性
            //TypeHandlerRegistry可以直接处理的会作为一个直接使用的对象进行处理
            boolean hasTypeHandler = ms.getConfiguration().getTypeHandlerRegistry().hasTypeHandler(parameterObject.getClass());
            MetaObject metaObject = SystemMetaObject.forObject(parameterObject);
            if (!hasTypeHandler) {
                for (String name : metaObject.getGetterNames()) {
                    paramMap.put(name, metaObject.getValue(name));
                }
            }
            //下面这段方法，主要解决一个常见类型的参数时的问题
            if (boundSql.getParameterMappings() != null && boundSql.getParameterMappings().size() > 0) {
                for (ParameterMapping parameterMapping : boundSql.getParameterMappings()) {
                    String name = parameterMapping.getProperty();
                    if (paramMap.get(name) == null) {
                        if (hasTypeHandler
                                || parameterMapping.getJavaType().equals(parameterObject.getClass())) {
                            paramMap.put(name, parameterObject);
                            break;
                        }
                    }
                }
            }
        }
        return paramMap;
    }
}
