package com.efuture.ocp.common.filter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.zip.GZIPOutputStream;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GzipResponseWrapper extends HttpServletResponseWrapper
{
    public static final Logger LOGGER = LoggerFactory.getLogger(GzipRequestWrapper.class);
    private HttpServletResponse response;  
    
    private GZipOutputStream gzipOutputStream;  
    private PrintWriter writer;
    
    public GzipResponseWrapper(HttpServletResponse response)
    {
        super(response);
        this.response = response;
    }
    
    public ServletOutputStream getOutputStream() throws IOException 
    {  
        if (gzipOutputStream == null) gzipOutputStream = new GZipOutputStream(response);  
        return gzipOutputStream;  
    }  
  
    public PrintWriter getWriter() throws IOException 
    {  
        if (writer == null) writer = new PrintWriter(new OutputStreamWriter(new GZipOutputStream(response), "UTF-8"));  
        return writer;  
    }  
    
    // 压缩后数据长度会发生变化 因此将该方法内容置空  
    public void setContentLength(int contentLength) 
    {  
    }  
  
    public void flushBuffer() throws IOException 
    {  
        gzipOutputStream.flush();  
    }  
  
    public void finishResponse() throws IOException 
    {  
        if (gzipOutputStream != null) gzipOutputStream.close();  
        if (writer != null) writer.close();  
    }
    
    public class GZipOutputStream extends ServletOutputStream 
    {  
        private HttpServletResponse response;  
        private GZIPOutputStream gzipOutputStream;  
        private ByteArrayOutputStream byteArrayOutputStream;  
      
        public GZipOutputStream(HttpServletResponse response) throws IOException 
        {  
            this.response = response;  
            byteArrayOutputStream = new ByteArrayOutputStream();  
            gzipOutputStream = new GZIPOutputStream(byteArrayOutputStream);  
        }  
      
        public void write(int b) throws IOException 
        {  
            gzipOutputStream.write(b);  
        }  
      
        public void close() throws IOException 
        {  
            gzipOutputStream.finish();  
      
            byte[] content = byteArrayOutputStream.toByteArray();  
      
            response.addHeader("Content-Encoding", "gzip");  
            response.addHeader("Content-Length", Integer.toString(content.length));  
      
            ServletOutputStream out = response.getOutputStream();  
            out.write(content);  
            out.close();  
        }  
      
        public void flush() throws IOException 
        {  
            gzipOutputStream.flush();  
        }  
      
        public void write(byte[] b, int off, int len) throws IOException 
        {  
            gzipOutputStream.write(b, off, len);  
        }  
      
        public void write(byte[] b) throws IOException 
        {  
            gzipOutputStream.write(b);  
        }  
    }  
}
