package com.efuture.ocp.common.user;

import java.util.ArrayList;
import java.util.List;

import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.util.RestClientUtils;
import com.efuture.ocp.user.DataRange;
import com.efuture.ocp.user.UserService;
import com.efuture.ocp.user.UserTokenInfo;

/**
 * 给新的portal的用户和数据范围接口
 * 1.目前只有数据范围接口
 * 2.传入的token实际上是entid-数据范围ID,暂时先这样，只处理数据范围，不处理其他用户信息
 * @author zhouwd
 *
 */
@Component("userService_cloud")
public class UserServiceCloudPortal implements UserService {
	
	public String DATA_RANGE_URL ="com.efuture.ocm.system.datarange.get";
	@Override
	public UserTokenInfo getuserinfo(String token) {
		UserTokenInfo useInfo = new UserTokenInfo();
		useInfo.setDatarange(getDataRangeBytoken(token));
		return useInfo;
	}

	@Override
	public List<DataRange> getDataRangeBytoken(String token) {
		return getDataRangeBypostid(token);
	}

	@Override
	public List<DataRange> getDataRangeBypostid(String postid) {
		String[] para = postid.split("-");
		if(para.length != 2){
			throw new ServiceException("50000", "获取用户数据范围信息时参数错误:[{0}]", postid);
		}
		String ent_id  =  para[0];
		String post_id = para[1];
		ServiceSession session = new ServiceSession();
		session.setEnt_id(Long.valueOf(ent_id));
		session.setPostid(post_id);
		ServiceResponse sr = null;
		try {
			sr = RestClientUtils.getRestUtils().sendRequest(session, DATA_RANGE_URL, "");
		} catch (Exception e) {
			throw new ServiceException("50000", "获取用户数据范围信息时错误:[{0}]-[{1}]", postid,e.getMessage());
		}
		JSONArray ja = JSONArray.parseArray(sr.getData().toString());
		List<DataRange> rtn = new ArrayList<DataRange>();
		for(Object data:ja){
			JSONObject jo = (JSONObject)data;
			DataRange dr = JSONObject.toJavaObject(jo, DataRange.class);
			rtn.add(dr);
		}
		return rtn;
	}

	@Override
	public UserTokenInfo gettoken(String userid, Object entid) {
		// 不支持
		return null;
	}

}
