/**
 * Copyright (C), 2007-2014, eFuture 北京富基融通科技有限公司
 * FileName:	CacheUtilsMemcached.java
 * Author:		亮
 * Date:		2014-9-16 下午4:50:31
 * Description:	
 * History:
 * <author>		<time>			<version>		<description>
 * 
 */
package com.efuture.ocp.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.TimeoutException;

import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

import org.apache.log4j.Logger;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.util.StringUtils;

import com.efuture.ocp.common.SerializeUtil.SerializeUtil;

import net.rubyeye.xmemcached.GetsResponse;


/**
 * @author 亮
 * @description
 * 
 */
public class CacheUtilsRediscached extends CacheUtils implements Serializable{
	private JedisPool jedispool;
	private String cfgFile = null;
	private int cachetime = -1;
	public Logger logger = Logger.getLogger(CacheUtilsRediscached.class);

	public CacheUtilsRediscached() {
		this(null);
	}

	public CacheUtilsRediscached(String config) {
		this(config, -1);
	}

	public CacheUtilsRediscached(String config, int cachetime) {
		this.cfgFile = config;
		this.cachetime = cachetime;
	}

	/**
	 * 往缓存赋值
	 * 
	 * @param key
	 *            键值
	 * @param object
	 *            值对象
	 * @param timeout
	 *            超时：毫秒
	 * @return
	 */
	private Jedis getJedis() {
		try {
			return jedispool.getResource();
		} catch (Exception ex) {
			ex.printStackTrace();
			return null;
		}
	}
	/**
	 *  返回释放Jedis
	 * @param jedis
	 */
	private void returnJedis(Jedis jedis) {
		if (jedis != null)
		{
			jedispool.returnResource(jedis);
			//jedispool.close();
		}
	}
	public String putData(String key, Object object, int timeout) {
		if (jedispool == null) {
			try {
				jedispool = CreateJedisPool();
			} catch (FileNotFoundException e) {
				e.printStackTrace();
				return null;
			} catch (IOException e) {
				e.printStackTrace();
				return null;
			}
		}
		Jedis jedis = getJedis();
		// set
		try {
			if (timeout < 0)
				timeout = (cachetime > 0 ? cachetime : 0);
			jedis.set(key.getBytes(),SerializeUtil.serialize(object));
			
			return key;
		} catch (Exception e) {
			jedispool.returnBrokenResource(jedis);
			e.printStackTrace();
			return null;
		} finally {
			returnJedis(jedis);
			 if(jedis.isConnected())
			 {
				 jedis.disconnect();
			 }
		}
		
	}

	/**
	 * 缓存取值
	 * 
	 * @param key
	 *            键值
	 * @return
	 */
	public Object getData(String key) {
		if (jedispool == null) {
			try {
				jedispool = CreateJedisPool();
			} catch (FileNotFoundException e) {
				e.printStackTrace();
				return null;
			} catch (IOException e) {
				e.printStackTrace();
				return null;
			}
		}
		Jedis jedis = getJedis();

		// get
		Object result = null;
		try {
			byte[] obj = jedis.get((key).getBytes());
			result = SerializeUtil.unserialize(obj);
		} catch (Exception e) {
			//释放redis对象  
			jedispool.returnBrokenResource(jedis);
			e.printStackTrace();
		} finally {
			returnJedis(jedis);
			if(jedis.isConnected())
			 {
				jedis.disconnect();
			 }
		}
		return result;
	}

	/**
	 * 缓存删除
	 * 
	 * @param key
	 *            键值
	 */
	public boolean deleteData(String key) {
		if (jedispool == null) {
			try {
				jedispool = CreateJedisPool();
			} catch (FileNotFoundException e) {
				e.printStackTrace();
				return false;
			} catch (IOException e) {
				e.printStackTrace();
				return false;
			}
		}
		Jedis jedis = getJedis();

		// delete
		try {
			jedis.del(key);
		} catch (Exception e) {
			//释放redis对象  
			jedispool.returnBrokenResource(jedis);
			e.printStackTrace();
			return false;
		} finally {
			returnJedis(jedis);
			 if(jedis.isConnected())
			 {
				 jedis.disconnect();
			 }
		}

		return true;
	}

	/**
	 * 创建redis缓存客户端
	 * 
	 * @return Memcached客户端对象
	 * @throws InvalidFileFormatException
	 * @throws FileNotFoundException
	 * @throws IOException
	 */
	public synchronized JedisPool CreateJedisPool() throws FileNotFoundException, IOException {
		if (jedispool != null)
			return jedispool;

		// 取redis.ini中的redis服务器配置
		String ini = null, ini0 = null;
		if (StringUtils.isEmpty(cfgFile)) {
			String p = WebPathUtils.getWebRootClassPath();
			ini = p + "/redis.ini"; // （原来的）
			ini0 = p + "/conf/redis.ini";
			// *****************解决有的配置文件存储在/WEB-INF/classes/conf 下***********//

		} else {
			if (cfgFile.startsWith("\\") || cfgFile.startsWith("/")) {
				String p = WebPathUtils.getWebRootClassPath();
				ini = p + cfgFile;
				ini0 = p + "/conf" + cfgFile;
			} else
				ini = cfgFile;
		}
		int maxActive = 100;
		int timeout = 5000;
		int maxIdle = 30;
		boolean testOnBorrow = true;
		String host = "localhost";
		int port = 6379;
		int maxWait = 5000;

		File input = new File(ini);
		// 如果classes目录下没有查找classes/conf目录
		if (ini0 != null && !input.exists()) {
			input = new File(ini0);
		}

		logger.info("redis.ini path:" + ini);
		if (input.exists()) {
			InputStream is = new FileInputStream(input);
			Properties p = new Properties();
			p.load(is);
			is.close();

			String sServer = p.getProperty("redis.host");
			if (sServer != null) {
				host = sServer.trim();
			}
			String smaxActive = p.getProperty("redis.maxActive");
			if (smaxActive != null) {
				maxActive = Integer.parseInt(smaxActive);
			}
			String stimeout = p.getProperty("redis.timeout");
			if (stimeout != null) {
				timeout = Integer.parseInt(stimeout);
			}
			String smaxIdle = p.getProperty("redis.maxIdle");
			if (smaxIdle != null) {
				maxIdle = Integer.parseInt(smaxIdle);
			}
			String stestOnBorrow = p.getProperty("redis.testOnBorrow");
			if (stestOnBorrow != null) {
				testOnBorrow = ((stestOnBorrow != null && stestOnBorrow.equalsIgnoreCase("false")) ? false : true);
			}
			String sport = p.getProperty("redis.port");
			if (sport != null) {
				port = Integer.parseInt(sport);
			}
			String smaxWait = p.getProperty("redis.maxWait");
			if (smaxWait != null) {
				maxWait = Integer.parseInt(smaxWait);
			}
			
			logger.info("rediscached server:" + host + ":" +sport);

			JedisPoolConfig config = new JedisPoolConfig();
			config.setTestOnBorrow(true);
			config.setMaxActive(maxActive);
			config.setMaxIdle(maxIdle);
			config.setMaxWait(maxWait);

			jedispool = new JedisPool(config, host, port,timeout);	
		} else {
			logger.warn("redis.ini not exits!");
			
			JedisPoolConfig config = new JedisPoolConfig();
			config.setTestOnBorrow(true);
			config.setMaxActive(maxActive);
			config.setMaxIdle(maxIdle);
			config.setMaxWait(maxWait);

			jedispool = new JedisPool(config, host, port,timeout);
			System.out.println("rediscached server-地址:" + "localhost:"+port);
		}

		
		return jedispool;
	}

	@Override
	public long getCasValue(String key) {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public boolean putbyCas(String key, Object object, int timeout, long casvalue) {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public GetsResponse getCasData(String key) {
		// TODO Auto-generated method stub
		return null;
	}

}
