/**
 * Copyright (C), 2007-2014, eFuture 北京富基融通科技有限公司
 * FileName:	RestClientFactory.java
 * Author:		亮
 * Date:		2014-3-27 下午2:39:12
 * Description:	
 * History:
 * <author>		<time>			<version>		<description>
 * 
 */
package com.efuture.ocp.common.util;

import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;

/**
 * @author		亮
 * @description	
 * 
 */
public class RestClientFactory extends BasePooledObjectFactory<Client>
{
	/**
	 * @return
	 * @throws Exception
	 * @see org.apache.commons.pool2.BasePooledObjectFactory#create()
	 */
	@Override
	public Client create() throws Exception
	{
		ClientConfig config = new DefaultClientConfig();
		
		// 默认10秒超时
		Client client = Client.create(config);
		client.setReadTimeout(10000);
		
		return client;
	}

	/**
	 * @param paramT
	 * @return
	 * @see org.apache.commons.pool2.BasePooledObjectFactory#wrap(java.lang.Object)
	 */
	@Override
	public PooledObject<Client> wrap(Client paramT)
	{
		return new DefaultPooledObject<Client>(paramT);
	}
	
	@Override
    public void destroyObject(PooledObject<Client> p) throws Exception
    {
        p.getObject().destroy();
    }
}
