/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.filter;

import com.efuture.ocp.common.filter.GzipRequestWrapper;
import com.efuture.ocp.common.filter.GzipResponseWrapper;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GzipFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean isgzip = false;
        HttpServletRequest req = (HttpServletRequest)request;
        String contentEncoding = req.getHeader("Content-Encoding");
        if (null != contentEncoding && contentEncoding.indexOf("gzip") != -1) {
            isgzip = true;
        }
        if (isgzip) {
            GzipRequestWrapper gzipreq = new GzipRequestWrapper((HttpServletRequest)request);
            GzipResponseWrapper gziprep = new GzipResponseWrapper((HttpServletResponse)response);
            chain.doFilter((ServletRequest)gzipreq, (ServletResponse)gziprep);
            gziprep.finishResponse();
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }
}

