/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.distributedLock;

import com.efuture.ocp.common.distributedLock.DLock;
import com.efuture.ocp.common.distributedLock.DistributedLockHandle;
import com.efuture.ocp.common.distributedLock.DistributedLockKeyHandle;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.rest.ServiceLogs;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class DistributedLockAspect {
    DistributedLockHandle lockHandle;
    DistributedLockKeyHandle keyHandle;

    @Around(value="@annotation(around)")
    public Object round(ProceedingJoinPoint point, DLock around) throws Throwable {
        ServiceLogs.truedebuglog("DistributedLock", "\u5f00\u59cb\u6267\u884c", 0L);
        String lockKey = this.keyHandle.getKey(point, around);
        ServiceLogs.truedebuglog("DistributedLock", "\u83b7\u53d6\u5230Key:" + lockKey, 0L);
        int lockExpire = around.lockExpire();
        boolean locked = this.lockHandle.tryLock(lockKey, lockExpire);
        if (!locked) {
            throw new ServiceException("50000", "\u83b7\u53d6\u9501\u5931\u8d25[{0}]", lockKey);
        }
        Object result = null;
        try {
            result = point.proceed();
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            this.lockHandle.unlock(lockKey);
        }
        return result;
    }
}

