/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.fileio;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.component.BasicComponentService;
import com.efuture.ocp.common.entity.FileImportObject;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.fileio.DataImportConfigBean;
import com.efuture.ocp.common.fileio.DataImportConfigServiceImpl;
import com.efuture.ocp.common.fileio.FileImportService;
import com.efuture.ocp.common.util.ExcelUtils;
import com.efuture.ocp.common.util.RestClientUtils;
import com.efuture.ocp.common.util.Utils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

public class FileImportSrvl
extends BasicComponentService
implements FileImportService {
    private static final String STATIC_XLS = "XLS";
    private static final String STATIC_XLSX = "XLSX";
    private static final String SimpleDateFormat = null;
    private SXSSFWorkbook xlsx = null;
    private HSSFWorkbook xls = null;
    private String createfilepath = null;

    public String getCreatefilepath() {
        return this.createfilepath;
    }

    public void setCreatefilepath(String createfilepath) {
        this.createfilepath = createfilepath;
    }

    @Override
    public ServiceResponse getConfig(ServiceSession session, JSONObject jsonparam) throws Exception {
        DataImportConfigServiceImpl dataImportConfig = new DataImportConfigServiceImpl();
        return dataImportConfig.search(session, jsonparam);
    }

    @Override
    public JSONObject beforeFileImport(ServiceSession session, JSONObject jsonparam, List<FileImportObject> list) throws Exception {
        DataImportConfigServiceImpl dataImportConfig;
        DataImportConfigBean exportConfig;
        long starttime = System.currentTimeMillis();
        this.getLogger().info((Object)("import start: " + starttime));
        if (StringUtils.isEmpty((Object)jsonparam.get((Object)"eid"))) {
            if (!StringUtils.isEmpty((Object)jsonparam.get((Object)"billmoduleid"))) {
                jsonparam.put("eid", jsonparam.get((Object)"billmoduleid"));
            } else {
                throw new ServiceException("10000", "{0} or {1} does not exist", "eid", "billmoduleid");
            }
        }
        if ((exportConfig = (dataImportConfig = new DataImportConfigServiceImpl()).getConfig(session.getEnt_id(), jsonparam.getString("eid"), null)) == null) {
            throw new ServiceException("10000", "\u5bfc\u5165\u914d\u7f6e\u4e0d\u5b58\u5728", new Object[0]);
        }
        String impfields = exportConfig.getImpfields();
        String imptype = exportConfig.getEid();
        long maxrow = -1L;
        this.checkConfig(exportConfig);
        this.getLogger().info((Object)("import start: " + starttime + " imptype: " + imptype));
        JSONObject jsonconfig = (JSONObject)Utils.toNormalJSONObject(exportConfig);
        JSONArray errList = new JSONArray();
        JSONArray successList = new JSONArray();
        JSONArray ary = null;
        JSONArray array = null;
        for (FileImportObject fio : list) {
            ary = fio.getFilename().toLowerCase().endsWith(".xlsx") ? ExcelUtils.XLSXtoJSONArray(fio.getStream(), impfields, maxrow) : ExcelUtils.XLStoJSONArray(fio.getStream(), impfields, maxrow);
            if (array != null) {
                array.addAll((Collection)ary);
                continue;
            }
            array = ary;
        }
        array = this.impToRegular(array);
        this.checkStyle(array, jsonconfig, successList, errList);
        array = (JSONArray)successList.clone();
        successList.clear();
        JSONObject out = new JSONObject();
        if (array.size() > 0) {
            out.put("imparray", (Object)array);
        }
        if (errList.size() > 0) {
            out.put("errList", (Object)errList);
        }
        out.put("impconfig", (Object)jsonconfig);
        return out;
    }

    public void checkConfig(DataImportConfigBean config) throws Exception {
        String impfields = config.getImpfields();
        String impname = config.getImpfields_name();
        String imptype = config.getImpfields_datatype();
        String defaultparam = config.getDefaultparam();
        String defaultvalue = config.getDefaultvalue();
        if (StringUtils.isEmpty((Object)impfields) || StringUtils.isEmpty((Object)impname) || StringUtils.isEmpty((Object)imptype)) {
            throw new ServiceException("10000", "\u5bfc\u5165\u914d\u7f6e:impfields\u3001impfields_name\u3001impfields_datatype \u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        if (impfields.split(",").length != impname.split(",").length) {
            throw new ServiceException("10000", "\u5bfc\u5165\u914d\u7f6e:impfields\u3001impfields_name \u4e0d\u5339\u914d", new Object[0]);
        }
        if (impfields.split(",").length != imptype.split(",").length) {
            throw new ServiceException("10000", "\u5bfc\u5165\u914d\u7f6e:impfields\u3001impfields_datatype \u4e0d\u5339\u914d", new Object[0]);
        }
        if (!StringUtils.isEmpty((Object)defaultparam) && defaultparam.split(",").length != defaultvalue.split(",").length) {
            throw new ServiceException("10000", "\u5bfc\u5165\u914d\u7f6e:defaultparam\u3001defaultvalue \u4e0d\u5339\u914d", new Object[0]);
        }
    }

    public boolean isDate(String strDate) {
        Pattern pattern = Pattern.compile("^((\\d{2}(([02468][048])|([13579][26]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))(\\s(((0?[0-9])|([1-2][0-3]))\\:([0-5]?[0-9])((\\s)|(\\:([0-5]?[0-9])))))?$");
        Matcher m = pattern.matcher(strDate);
        return m.matches();
    }

    private boolean isLong(String str) {
        Pattern pattern = Pattern.compile("[0-9]*");
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }

    public boolean isNumber(String string) {
        if (string == null) {
            return false;
        }
        Pattern pattern = Pattern.compile("^-?\\d+(\\.\\d+)?$");
        return pattern.matcher(string).matches();
    }

    public boolean isequal(Object value1, Object value2) {
        return (value1 == null ? "" : value1.toString().trim()).equals(value2 == null ? "" : value2.toString().trim());
    }

    public String geterr(JSONArray array) {
        String errmsg = "";
        for (int i = 0; i < array.size(); ++i) {
            JSONObject errrow = array.getJSONObject(i);
            errmsg = i == array.size() - 1 ? errmsg + "[" + errrow.getString("column") + "] " + errrow.getString("msg") : errmsg + "[" + errrow.getString("column") + "] " + errrow.getString("msg") + ",";
        }
        return errmsg;
    }

    public String checkRow(JSONObject row, JSONObject jsonparam, JSONArray array) throws Exception {
        JSONArray result = new JSONArray();
        String fields = jsonparam.getString("impfields");
        String fields_name = jsonparam.getString("impfields_name");
        String fields_type = jsonparam.getString("impfields_datatype");
        String fields_nonull = this.getParamWithCheck(jsonparam, "uniquecolumn", false, "") + "," + this.getParamWithCheck(jsonparam, "nonullfields", false, "");
        String field_norepeat = this.getParamWithCheck(jsonparam, "uniquecolumn", false, "") + "," + this.getParamWithCheck(jsonparam, "norepeatfields", false, "");
        String defaultparam = this.getParamWithCheck(jsonparam, "defaultparam", false, "");
        String defaultvalue = this.getParamWithCheck(jsonparam, "defaultvalue", false, "");
        String[] columns = fields.split(",");
        String[] columns_name = fields_name.split(",");
        String[] columns_type = fields_type.split(",");
        String[] columns_nonull = fields_nonull.split(",");
        String[] columns_norepeat = field_norepeat.split(",");
        String[] arr_defaultparam = defaultparam.split(",");
        String[] arr_defaultvalue = defaultvalue.split(",");
        for (int i = 0; i < columns.length; ++i) {
            String field = columns[i];
            String field_name = columns_name[i];
            JSONObject result_row = new JSONObject();
            result_row.put("column", (Object)field_name);
            if (field.equals("")) continue;
            for (String column_nonull : columns_nonull) {
                if (column_nonull.equals("") || !field.equals(column_nonull)) continue;
                if (row.get((Object)field) == null) {
                    result_row.put("msg", (Object)"is null");
                    result.add((Object)result_row);
                }
                if (!row.getString(field).trim().equals("")) continue;
                result_row.put("msg", (Object)"is null");
                result.add((Object)result_row);
            }
            if (row.get((Object)field) != null) {
                for (String nonull_fie : columns_nonull) {
                    if (!field.equals(nonull_fie)) continue;
                    if (columns_type[i].equals("D")) {
                        if (this.isDate(row.getString(field).trim())) continue;
                        result_row.put("msg", (Object)"format is wrong");
                        result.add((Object)result_row);
                        continue;
                    }
                    if (columns_type[i].equals("N")) {
                        if (this.isNumber(row.getString(field).trim())) continue;
                        result_row.put("msg", (Object)"format is wrong");
                        result.add((Object)result_row);
                        continue;
                    }
                    if (!columns_type[i].equals("L") || this.isLong(row.getString(field).trim())) continue;
                    result_row.put("msg", (Object)"format is wrong");
                    result.add((Object)result_row);
                }
                continue;
            }
            result_row.put("msg", (Object)"format is wrong");
            result.add((Object)result_row);
        }
        for (String column_repeat : columns_norepeat) {
            if (column_repeat.equals("")) continue;
            JSONObject result_row = new JSONObject();
            String[] column_r = column_repeat.split("#");
            String column_name = "";
            for (String column : column_r) {
                for (int i = 0; i < columns.length; ++i) {
                    if (!column.equals(columns[i])) continue;
                    column_name = column == column_r[column_r.length - 1] ? column_name + columns_name[i] : column_name + columns_name[i] + ",";
                }
            }
            result_row.put("column", (Object)column_name);
            int isrepeat = 0;
            for (int j = 0; j < array.size(); ++j) {
                int isrepeat_row = 0;
                JSONObject json_row = array.getJSONObject(j);
                for (String column : column_r) {
                    if (!this.isequal(row.get((Object)column), json_row.getString(column))) continue;
                    ++isrepeat_row;
                }
                if (isrepeat_row != column_r.length) continue;
                ++isrepeat;
            }
            if (isrepeat <= true) continue;
            result_row.put("msg", (Object)"is repeat");
            result.add((Object)result_row);
        }
        for (int i = 0; i < arr_defaultparam.length; ++i) {
            String paramrow = arr_defaultparam[i];
            if (paramrow.equals("")) continue;
            row.put(paramrow, (Object)arr_defaultvalue[i]);
        }
        String flag = "Y";
        if (result.size() > 0) {
            flag = this.geterr(result);
        }
        return flag;
    }

    public void checkStyle(JSONArray array, JSONObject jsonparam, JSONArray successList, JSONArray errList) throws Exception {
        for (int i = 0; i < array.size(); ++i) {
            JSONObject json_row = array.getJSONObject(i);
            String flag = this.checkRow(json_row, jsonparam, array);
            if (flag.equals("Y")) {
                successList.add((Object)json_row);
                continue;
            }
            json_row.put("errmsg", (Object)flag);
            errList.add((Object)json_row);
        }
    }

    public Object colTotrim(Object colvalue) {
        if (colvalue == null) {
            return null;
        }
        if (colvalue.toString().trim().equalsIgnoreCase("")) {
            return "";
        }
        Pattern pattern = Pattern.compile("^[-\\+]?[.\\d]*$");
        if (pattern.matcher(colvalue.toString()).matches()) {
            return colvalue;
        }
        return colvalue.toString().trim();
    }

    public Object colTocleanpoint(Object colvalue) {
        if (colvalue == null) {
            return null;
        }
        if (this.isNumber(colvalue.toString()) && colvalue.toString().indexOf(".") > 0 && Double.parseDouble(colvalue.toString()) == Double.parseDouble(colvalue.toString().substring(0, colvalue.toString().indexOf(".")))) {
            return colvalue.toString().substring(0, colvalue.toString().indexOf("."));
        }
        return colvalue;
    }

    public JSONArray impToRegular(JSONArray array) {
        JSONArray newarray = new JSONArray();
        for (int i = 0; i < array.size(); ++i) {
            JSONObject item = new JSONObject((Map)array.getJSONObject(i));
            Set keys = item.keySet();
            Iterator iterator = keys.iterator();
            while (iterator.hasNext()) {
                String keyname = iterator.next().toString();
                item.put(keyname, this.colTocleanpoint(this.colTotrim(item.get((Object)keyname))));
            }
            newarray.add((Object)item);
        }
        return newarray;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void doResponseServiceImp(ServiceSession session, String eid, String method, JSONObject impdata, JSONArray successList, JSONArray errList) throws Exception {
        ServiceResponse resp = RestClientUtils.getRestUtils().sendRequest(session, method, impdata.toJSONString());
        if (resp.getReturncode().equals("0")) {
            JSONObject jsonout = (JSONObject)resp.getData();
            errList.addAll((Collection)jsonout.getJSONArray("errList"));
            successList.addAll((Collection)jsonout.getJSONArray("successList"));
        }
    }

    public String downloadTemplate(ServiceSession session, JSONObject jsonparam) throws Exception {
        String excel;
        String modulecode = jsonparam.getString("billmoduleid");
        this.getLogger().info((Object)("\u4e0b\u8f7d\u5bfc\u5165\u6a21\u7248\uff0c" + modulecode + ",start...."));
        DataImportConfigServiceImpl dataImportConfig = new DataImportConfigServiceImpl();
        List<DataImportConfigBean> importconfigbean = dataImportConfig.getConfigByModule(session.getEnt_id(), modulecode);
        if (importconfigbean.size() <= 0) {
            return "";
        }
        String exceltype = null;
        exceltype = StringUtils.isEmpty((Object)jsonparam.get((Object)"filetype")) ? STATIC_XLSX : ("1".equals(excel = jsonparam.get((Object)"filetype").toString()) ? STATIC_XLS : STATIC_XLSX);
        ArrayList<String> filelist = new ArrayList<String>();
        if (importconfigbean.size() > 1) {
            int i = 0;
            for (DataImportConfigBean row : importconfigbean) {
                String[] fldlst = row.getImpfields().split(",");
                String[] disps = row.getImpfields_name().split(",");
                String tempfileName = "";
                tempfileName = row.getEname() + tempfileName + ++i;
                String file = this.createExcel(tempfileName, fldlst, disps, exceltype);
                filelist.add(file);
            }
        } else {
            String[] fldlst = importconfigbean.get(0).getImpfields().split(",");
            String[] disps = importconfigbean.get(0).getImpfields_name().split(",");
            String tempfileName = "";
            tempfileName = importconfigbean.get(0).getEname() + tempfileName;
            String file = this.createExcel(tempfileName, fldlst, disps, exceltype);
            filelist.add(file);
        }
        String reFile = "";
        reFile = filelist.size() > 1 ? this.makezip(filelist) : (String)filelist.get(0);
        return reFile;
    }

    public String getFilePath() {
        String osname = System.getProperties().getProperty("os.name");
        String head = this.createfilepath;
        if (osname.startsWith("Windows")) {
            head = "D:\\file\\";
            File dir = new File(head);
            if (!dir.exists() && !dir.mkdirs()) {
                head = "C:\\file\\";
            }
        } else {
            File dir = new File(head);
            if (!dir.exists()) {
                dir.mkdirs();
            }
        }
        return head;
    }

    public String makezip(List<String> filelist) throws IOException {
        String trackkey;
        SimpleDateFormat sdfymdCard = new SimpleDateFormat("yyyyMMddHHmmss");
        String filename = trackkey = sdfymdCard.format(new Date());
        ArrayList<File> files = new ArrayList<File>();
        for (int i = 0; i < filelist.size(); ++i) {
            File file = new File(filelist.get(i));
            files.add(file);
        }
        String head = this.getFilePath();
        String name = head + filename + ".rar";
        File file = new File(name);
        if (!file.exists()) {
            file.createNewFile();
        }
        FileOutputStream fous = new FileOutputStream(file);
        ZipOutputStream zipOut = new ZipOutputStream(fous);
        this.zipFile(files, zipOut);
        zipOut.close();
        fous.close();
        for (File temp : files) {
            if (!temp.isFile() || !temp.exists()) continue;
            temp.delete();
        }
        return name;
    }

    private void zipFile(List files, ZipOutputStream outputStream) {
        int size = files.size();
        for (int i = 0; i < size; ++i) {
            File file = (File)files.get(i);
            this.zipFile(file, outputStream);
        }
    }

    private void zipFile(File inputFile, ZipOutputStream ouputStream) {
        block7: {
            try {
                if (!inputFile.exists()) break block7;
                if (inputFile.isFile()) {
                    int nNumber;
                    FileInputStream IN = new FileInputStream(inputFile);
                    BufferedInputStream bins = new BufferedInputStream(IN, 512);
                    ZipEntry entry = new ZipEntry(inputFile.getName());
                    ouputStream.putNextEntry(entry);
                    byte[] buffer = new byte[512];
                    while ((nNumber = bins.read(buffer)) != -1) {
                        ouputStream.write(buffer, 0, nNumber);
                    }
                    bins.close();
                    IN.close();
                    break block7;
                }
                try {
                    File[] files = inputFile.listFiles();
                    for (int i = 0; i < files.length; ++i) {
                        this.zipFile(files[i], ouputStream);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void exportDataToExcel(String[] fldlst, String[] disps, String exceltype) {
        Sheet sheet = null;
        CellStyle columnHeadStyle = null;
        CellStyle cellStyle = null;
        Font f = null;
        if (fldlst == null) {
            fldlst = "".split(",");
        }
        if (disps == null) {
            disps = "".split(",");
        }
        DataFormat format = null;
        if (STATIC_XLSX.equals(exceltype)) {
            columnHeadStyle = this.xlsx.createCellStyle();
            format = this.xlsx.createDataFormat();
            f = this.xlsx.createFont();
            sheet = this.xlsx.createSheet("sheet");
            cellStyle = this.xlsx.createCellStyle();
        } else {
            columnHeadStyle = this.xls.createCellStyle();
            format = this.xls.createDataFormat();
            f = this.xls.createFont();
            sheet = this.xls.createSheet("sheet");
            cellStyle = this.xls.createCellStyle();
        }
        columnHeadStyle.setBorderBottom((short)1);
        columnHeadStyle.setBorderLeft((short)1);
        columnHeadStyle.setBorderRight((short)1);
        columnHeadStyle.setBorderTop((short)1);
        columnHeadStyle.setAlignment((short)2);
        columnHeadStyle.setVerticalAlignment((short)1);
        columnHeadStyle.setWrapText(true);
        f.setFontHeightInPoints((short)9);
        f.setBoldweight((short)700);
        columnHeadStyle.setFont(f);
        columnHeadStyle.setDataFormat(format.getFormat("@"));
        Row row = sheet.createRow(0);
        sheet.createFreezePane(0, 1, 0, 1);
        int i = 0;
        for (String s : fldlst) {
            Cell cell = row.createCell(i);
            cell.setCellStyle(columnHeadStyle);
            cell.setCellValue(disps[i]);
            sheet.setColumnWidth(i, 7000);
            sheet.setDefaultColumnStyle(i, columnHeadStyle);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String createExcel(String fileName, String[] fldlst, String[] disps, String exceltype) throws Exception {
        String filePath = this.getFilePath();
        File dir = new File(filePath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        String tempExcelFile = "";
        SimpleDateFormat sdfymdCard = new SimpleDateFormat("yyyyMMddHHmmss");
        fileName = fileName + sdfymdCard.format(new Date());
        tempExcelFile = STATIC_XLSX.equals(exceltype) ? filePath + fileName + ".xlsx" : filePath + fileName + ".xls";
        int rowMemory = 100;
        FileOutputStream fos = new FileOutputStream(tempExcelFile);
        if (STATIC_XLSX.equals(exceltype)) {
            try {
                this.xlsx = new SXSSFWorkbook(rowMemory);
                this.exportDataToExcel(fldlst, disps, STATIC_XLSX);
                this.xlsx.write((OutputStream)fos);
                fos.flush();
                fos.close();
            }
            finally {
                fos.flush();
                fos.close();
            }
        }
        try {
            this.xls = new HSSFWorkbook();
            this.exportDataToExcel(fldlst, disps, STATIC_XLS);
            this.xls.write((OutputStream)fos);
            fos.flush();
            fos.close();
        }
        finally {
            fos.flush();
            fos.close();
        }
        return tempExcelFile;
    }

    static interface errCode {
        public static final String TYPE = "format is wrong";
        public static final String ISNULL = "is null";
        public static final String ISREPEAT = "is repeat";
    }

    static interface separator {
        public static final String array = ",";
        public static final String field = "#";
    }
}

