/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.rest;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.util.SpringBeanFactory;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ServiceVersion {
    Logger logger = Logger.getLogger(ServiceVersion.class);
    boolean logstatus;
    String logformat;
    String ver;
    Map<String, JSONObject> elapsed = new HashMap<String, JSONObject>();
    long[] elapsedStep = new long[]{200L, 300L, 500L, 1000L, 3000L, 5000L};

    public String getLogFormat() {
        if (this.logformat == null) {
            return "default";
        }
        return this.logformat;
    }

    public void setLogFormat(String logFormat) {
        this.logformat = logFormat;
    }

    public ServiceVersion(String version, String openlog) {
        this.ver = version;
        this.logstatus = openlog.equalsIgnoreCase("y");
        this.setLogFormat("default");
    }

    public ServiceVersion(String version, String openlog, String logformat) {
        this.ver = version;
        this.logstatus = openlog.equalsIgnoreCase("y");
        this.setLogFormat(logformat);
    }

    public ServiceVersion(String version) {
        this.ver = version;
    }

    public String getVer() {
        return this.ver;
    }

    public boolean isLogstatus() {
        return this.logstatus;
    }

    public void setLogstatus(boolean logstatus) {
        this.logstatus = logstatus;
    }

    public void debugLog(Object message) {
        if (this.logstatus) {
            this.logger.info(message);
        }
    }

    public Map<String, JSONObject> getElapsed() {
        return this.elapsed;
    }

    public void setElapsed(Map<String, JSONObject> elapsed) {
        this.elapsed = elapsed;
    }

    public synchronized void writeElapsed(String key, long time) {
        try {
            if (time <= 0L) {
                return;
            }
            JSONObject json = this.elapsed.get(key);
            if (json == null) {
                json = new JSONObject();
                json.put("num", (Object)1);
                json.put("tot", (Object)time);
                json.put("avg", (Object)time);
                this.elapsed.put(key, json);
            } else {
                json.put("num", (Object)(json.getLong("num") + 1L));
                json.put("tot", (Object)(json.getLong("tot") + time));
                json.put("avg", (Object)(json.getLong("tot") / json.getLong("num")));
            }
            boolean exist = false;
            for (int i = 0; i < this.elapsedStep.length; ++i) {
                String str;
                if (time > this.elapsedStep[i]) continue;
                String string = str = i > 0 ? this.elapsedStep[i - 1] + "-" + this.elapsedStep[i] : "<=" + this.elapsedStep[i];
                if (json.containsKey((Object)str)) {
                    json.put(str, (Object)(json.getLong(str) + 1L));
                } else {
                    json.put(str, (Object)1);
                }
                exist = true;
                break;
            }
            if (!exist) {
                String str = ">" + this.elapsedStep[this.elapsedStep.length - 1];
                if (json.containsKey((Object)str)) {
                    json.put(str, (Object)(json.getLong(str) + 1L));
                } else {
                    json.put(str, (Object)1);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static ServiceVersion getInstance() {
        ServiceVersion sv = SpringBeanFactory.getBean("ServiceVersion", ServiceVersion.class);
        return sv;
    }

    public static String getVersion() {
        return ServiceVersion.getInstance().getVer();
    }
}

