/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.util;

import com.efuture.ocp.common.SerializeUtil.SerializeUtil;
import com.efuture.ocp.common.util.CacheUtils;
import com.efuture.ocp.common.util.WebPathUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Properties;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.log4j.Logger;
import org.springframework.util.StringUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class CacheUtilsRediscached
extends CacheUtils
implements Serializable {
    private JedisPool jedispool;
    private String cfgFile = null;
    private int cachetime = -1;
    public Logger logger = Logger.getLogger(CacheUtilsRediscached.class);

    public CacheUtilsRediscached() {
        this(null);
    }

    public CacheUtilsRediscached(String config) {
        this(config, -1);
    }

    public CacheUtilsRediscached(String config, int cachetime) {
        this.cfgFile = config;
        this.cachetime = cachetime;
    }

    private Jedis getJedis() {
        try {
            return (Jedis)this.jedispool.getResource();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private void returnJedis(Jedis jedis) {
        if (jedis != null) {
            this.jedispool.returnResource((Object)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String putData(String key, Object object, int timeout) {
        if (this.jedispool == null) {
            try {
                this.jedispool = this.CreateJedisPool();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return null;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        Jedis jedis = this.getJedis();
        try {
            if (timeout < 0) {
                timeout = this.cachetime > 0 ? this.cachetime : 0;
            }
            jedis.set(key.getBytes(), SerializeUtil.serialize(object));
            String string = key;
            return string;
        }
        catch (Exception e) {
            this.jedispool.returnBrokenResource((Object)jedis);
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            this.returnJedis(jedis);
            if (jedis.isConnected()) {
                jedis.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getData(String key) {
        if (this.jedispool == null) {
            try {
                this.jedispool = this.CreateJedisPool();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return null;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        Jedis jedis = this.getJedis();
        Object result = null;
        try {
            byte[] obj = jedis.get(key.getBytes());
            result = SerializeUtil.unserialize(obj);
        }
        catch (Exception e) {
            this.jedispool.returnBrokenResource((Object)jedis);
            e.printStackTrace();
        }
        finally {
            this.returnJedis(jedis);
            if (jedis.isConnected()) {
                jedis.disconnect();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteData(String key) {
        if (this.jedispool == null) {
            try {
                this.jedispool = this.CreateJedisPool();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return false;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        Jedis jedis = this.getJedis();
        try {
            jedis.del(key);
        }
        catch (Exception e) {
            this.jedispool.returnBrokenResource((Object)jedis);
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            this.returnJedis(jedis);
            if (jedis.isConnected()) {
                jedis.disconnect();
            }
        }
        return true;
    }

    public synchronized JedisPool CreateJedisPool() throws FileNotFoundException, IOException {
        String p;
        if (this.jedispool != null) {
            return this.jedispool;
        }
        String ini = null;
        String ini0 = null;
        if (StringUtils.isEmpty((Object)this.cfgFile)) {
            p = WebPathUtils.getWebRootClassPath();
            ini = p + "/redis.ini";
            ini0 = p + "/conf/redis.ini";
        } else if (this.cfgFile.startsWith("\\") || this.cfgFile.startsWith("/")) {
            p = WebPathUtils.getWebRootClassPath();
            ini = p + this.cfgFile;
            ini0 = p + "/conf" + this.cfgFile;
        } else {
            ini = this.cfgFile;
        }
        int maxActive = 100;
        int timeout = 5000;
        int maxIdle = 30;
        boolean testOnBorrow = true;
        String host = "localhost";
        int port = 6379;
        int maxWait = 5000;
        File input = new File(ini);
        if (ini0 != null && !input.exists()) {
            input = new File(ini0);
        }
        this.logger.info((Object)("redis.ini path:" + ini));
        if (input.exists()) {
            String smaxWait;
            String sport;
            String stestOnBorrow;
            String smaxIdle;
            String stimeout;
            String smaxActive;
            FileInputStream is = new FileInputStream(input);
            Properties p2 = new Properties();
            p2.load(is);
            ((InputStream)is).close();
            String sServer = p2.getProperty("redis.host");
            if (sServer != null) {
                host = sServer.trim();
            }
            if ((smaxActive = p2.getProperty("redis.maxActive")) != null) {
                maxActive = Integer.parseInt(smaxActive);
            }
            if ((stimeout = p2.getProperty("redis.timeout")) != null) {
                timeout = Integer.parseInt(stimeout);
            }
            if ((smaxIdle = p2.getProperty("redis.maxIdle")) != null) {
                maxIdle = Integer.parseInt(smaxIdle);
            }
            if ((stestOnBorrow = p2.getProperty("redis.testOnBorrow")) != null) {
                boolean bl = testOnBorrow = stestOnBorrow == null || !stestOnBorrow.equalsIgnoreCase("false");
            }
            if ((sport = p2.getProperty("redis.port")) != null) {
                port = Integer.parseInt(sport);
            }
            if ((smaxWait = p2.getProperty("redis.maxWait")) != null) {
                maxWait = Integer.parseInt(smaxWait);
            }
            this.logger.info((Object)("rediscached server:" + host + ":" + sport));
            JedisPoolConfig config = new JedisPoolConfig();
            config.setTestOnBorrow(true);
            config.setMaxActive(maxActive);
            config.setMaxIdle(maxIdle);
            config.setMaxWait((long)maxWait);
            this.jedispool = new JedisPool((GenericObjectPool.Config)config, host, port, timeout);
        } else {
            this.logger.warn((Object)"redis.ini not exits!");
            JedisPoolConfig config = new JedisPoolConfig();
            config.setTestOnBorrow(true);
            config.setMaxActive(maxActive);
            config.setMaxIdle(maxIdle);
            config.setMaxWait((long)maxWait);
            this.jedispool = new JedisPool((GenericObjectPool.Config)config, host, port, timeout);
            System.out.println("rediscached server-\u5730\u5740:localhost:" + port);
        }
        return this.jedispool;
    }

    @Override
    public boolean addData(String key, Object object, int timeout) {
        return false;
    }
}

