/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.util;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.rest.ServiceVersion;
import com.efuture.ocp.common.util.MD5Utils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.StringUtils;

public class SignUtils {
    private static final String ENABLEDEBUG = "Y";

    public static String getToken(String serviceName, String paraList, String secret) {
        return MD5Utils.MD5(serviceName.concat(paraList).concat(secret));
    }

    public static String getParaMapSignModeA(JSONObject jsonparam, String charset, String secret, String debugStatus) throws IOException {
        StringBuilder sb = new StringBuilder(secret);
        sb.append(SignUtils.getParamStrFromMapModeA(SignUtils.getJSONMap(jsonparam, charset)));
        sb.append(secret);
        byte[] bytes = MD5Utils.encryptMD5(sb.toString().getBytes(charset));
        String signKey = MD5Utils.byte2hex(bytes);
        if (ENABLEDEBUG.equalsIgnoreCase(debugStatus)) {
            ServiceVersion.getInstance().debugLog("SignStr=".concat(sb.toString()));
            ServiceVersion.getInstance().debugLog("SignKey=".concat(signKey));
        }
        return signKey;
    }

    public static String getParaMapSignModeB(JSONObject jsonparam, String charset, String secret, String debugStatus) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(SignUtils.getParamStrFromMapModeB(SignUtils.getJSONMap(jsonparam, charset)));
        sb.append("&key=".concat(secret));
        byte[] bytes = MD5Utils.encryptMD5(sb.toString().getBytes(charset));
        String signKey = MD5Utils.byte2hex(bytes);
        if (ENABLEDEBUG.equalsIgnoreCase(debugStatus)) {
            ServiceVersion.getInstance().debugLog("SignStr=".concat(sb.toString()));
            ServiceVersion.getInstance().debugLog("SignKey=".concat(signKey));
        }
        return signKey;
    }

    public static String urlToJson(String input, String encoding) throws UnsupportedEncodingException {
        String[] inputs = input.split("&");
        JSONObject json = new JSONObject();
        for (int i = 0; i < inputs.length; ++i) {
            String[] keyVal = inputs[i].split("=");
            json.put(keyVal[0], (Object)URLDecoder.decode(keyVal[1], encoding));
        }
        if (StringUtils.isEmpty((Object)json)) {
            return null;
        }
        return json.toJSONString();
    }

    public static Map<String, String> urlToMap(String input, String encoding) throws UnsupportedEncodingException {
        String[] inputs = input.split("&");
        HashMap<String, String> result = new HashMap<String, String>();
        for (int i = 0; i < inputs.length; ++i) {
            String[] keyVal = inputs[i].split("=");
            result.put(keyVal[0], URLDecoder.decode(keyVal[1], encoding));
        }
        return result;
    }

    public static Map<String, String> getQueryMap(HttpServletRequest request, String charset) throws IOException {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        String queryString = request.getQueryString();
        String[] params = queryString.split("&");
        for (int i = 0; i < params.length; ++i) {
            String key;
            String[] kv = params[i].split("=");
            if (kv.length == 2) {
                key = URLDecoder.decode(kv[0], charset);
                String value = URLDecoder.decode(kv[1], charset);
                queryMap.put(key, value);
                continue;
            }
            if (kv.length != 1) continue;
            key = URLDecoder.decode(kv[0], charset);
            queryMap.put(key, "");
        }
        return queryMap;
    }

    public static Map<String, String> getFormMap(HttpServletRequest request, Map<String, String> queryMap) throws IOException {
        HashMap<String, String> formMap = new HashMap<String, String>();
        Set keys = request.getParameterMap().keySet();
        for (Object tmp : keys) {
            String key = String.valueOf(tmp);
            if (queryMap.containsKey(key)) continue;
            String value = request.getParameter(key);
            if (StringUtils.isEmpty((Object)value)) {
                formMap.put(key, "");
                continue;
            }
            formMap.put(key, value);
        }
        return formMap;
    }

    public static Map<String, String> getJSONMap(JSONObject json, String charset) throws IOException {
        HashMap<String, String> jsonMap = new HashMap<String, String>();
        for (Map.Entry keyVal : json.entrySet()) {
            jsonMap.put((String)keyVal.getKey(), keyVal.getValue().toString());
        }
        return jsonMap;
    }

    private static String getParamStrFromMapModeA(Map<String, String> params) {
        StringBuilder sb = new StringBuilder();
        if (params != null && !params.isEmpty()) {
            Object[] keys = params.keySet().toArray(new String[0]);
            Arrays.sort(keys);
            for (int i = 0; i < keys.length; ++i) {
                Object name = keys[i];
                if ("sign".equals(name)) continue;
                sb.append((String)name);
                sb.append(params.get(name));
            }
        }
        return sb.toString();
    }

    private static String getParamStrFromMapModeB(Map<String, String> params) {
        StringBuilder sb = new StringBuilder();
        if (params != null && !params.isEmpty()) {
            Object[] keys = params.keySet().toArray(new String[0]);
            Arrays.sort(keys);
            for (int i = 0; i < keys.length; ++i) {
                Object name = keys[i];
                if ("sign".equals(name)) continue;
                if (sb.length() > 0) {
                    sb.append("&");
                }
                sb.append((String)name);
                sb.append("=");
                sb.append(params.get(name));
            }
        }
        return sb.toString();
    }
}

