/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.bpm;

import com.alibaba.fastjson.JSON;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.util.HttpUtils;
import com.efuture.ocp.common.util.RestClientUtils;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.ocp.common.util.Utils;
import java.util.Map;
import org.springframework.util.StringUtils;

public class BpmService {
    public static BpmService getBpmService() {
        return SpringBeanFactory.getBean("BpmService", BpmService.class);
    }

    public ServiceResponse submit(Map<String, Object> bpmdata) throws Exception {
        return this.callBpmService(bpmdata, "mss.bpm.submit");
    }

    public ServiceResponse reject(Map<String, Object> bpmdata) throws Exception {
        return this.callBpmService(bpmdata, "mss.bpm.reject");
    }

    public ServiceResponse approval(Map<String, Object> bpmdata) throws Exception {
        return this.callBpmService(bpmdata, "mss.bpm.approval");
    }

    public ServiceResponse repeal(Map<String, Object> bpmdata) throws Exception {
        return this.callBpmService(bpmdata, "mss.bpm.repeal");
    }

    public ServiceResponse gettask(Map<String, Object> bpmdata) throws Exception {
        return this.callBpmService(bpmdata, "mss.bpm.getusertask");
    }

    public ServiceResponse callBpmService(Map<String, Object> bpmdata, String service) throws Exception {
        String processdefkey;
        ServiceSession session = new ServiceSession();
        String bpmpara = JSON.toJSONString((Object)Utils.toNormalJSONObject(bpmdata));
        String url = RestClientUtils.getRestUtils().queryServiceURI(service + "." + bpmdata.get("processdefkey"));
        if (StringUtils.isEmpty((Object)url)) {
            url = service;
        }
        if ("WYC".equalsIgnoreCase(processdefkey = bpmdata.get("processdefkey").toString())) {
            String auth = bpmdata.get("auth").toString();
            bpmpara = bpmdata.get("sheet").toString();
            String rtn = HttpUtils.doPost(url, '[' + bpmpara + ']', auth);
            return null;
        }
        return RestClientUtils.getRestUtils().sendRequest(session, url, bpmpara);
    }

    static interface bpmservice {
        public static final String APPROVAL = "mss.bpm.approval";
        public static final String REJECT = "mss.bpm.reject";
        public static final String SUBMIT = "mss.bpm.submit";
        public static final String REPEAL = "mss.bpm.repeal";
        public static final String GETTASK = "mss.bpm.getusertask";
    }
}

