/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.rest;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.rest.ServiceRestReflect;
import com.efuture.ocp.common.rest.ServiceVersion;
import java.util.Date;
import org.apache.log4j.Logger;

public class ServiceLogs {
    public static String logFormat = "JSON";
    static Logger logger = Logger.getLogger(ServiceLogs.class);

    public static ServiceSession getSessionobj() {
        ServiceSession sessionobj = ServiceRestReflect.getLocale().get();
        if (sessionobj == null) {
            String tname = Thread.currentThread().getName();
            String rootkey = String.valueOf(new Date().getTime());
            if (tname.startsWith("rootkey")) {
                rootkey = tname.substring(7);
            }
            sessionobj = new ServiceSession();
            sessionobj.setUser_name("ASYNC");
            sessionobj.setRootkey(rootkey);
            sessionobj.setLogkey(String.valueOf(new Date().getTime()));
            sessionobj.setParentkey(rootkey);
            ServiceRestReflect.getLocale().set(sessionobj);
        }
        return sessionobj;
    }

    public static void logResponse(String logmsg, String rtncode) {
        ServiceSession sessionobj = ServiceLogs.getSessionobj();
        if (sessionobj != null) {
            sessionobj.setReturncode(rtncode);
            ServiceLogs.debuglog(sessionobj, "response", logmsg, sessionobj.getStarttime(), false);
        }
    }

    public static void logRequest(String logmsg) {
        ServiceSession sessionobj = ServiceLogs.getSessionobj();
        if (sessionobj != null) {
            sessionobj.setStarttime(System.currentTimeMillis());
            ServiceLogs.debuglog(sessionobj, "request", logmsg, 0L, false);
        }
    }

    public static void logCallStart(String url, String method, String request) {
        ServiceSession sessionobj = ServiceLogs.getSessionobj();
        if (sessionobj != null) {
            JSONObject logmsg = new JSONObject();
            logmsg.put("call_method", (Object)method);
            logmsg.put("call_url", (Object)url);
            logmsg.put("call_request", (Object)request);
            ServiceLogs.debuglog(sessionobj, "call_request", logmsg.toString(), 0L, false);
        }
    }

    public static void logCallError(String url, String method, String errcode, String errmsg, long starttime) {
        ServiceSession sessionobj = ServiceLogs.getSessionobj();
        if (sessionobj != null) {
            JSONObject logmsg = new JSONObject();
            logmsg.put("call_method", (Object)method);
            logmsg.put("call_url", (Object)url);
            logmsg.put("call_returncode", (Object)errcode);
            logmsg.put("call_response", (Object)errmsg);
            sessionobj.setReturncode(errcode);
            ServiceLogs.debuglog(sessionobj, "call_response", logmsg.toString(), starttime, true);
        }
    }

    public static void logCallSuccess(String url, String method, long starttime) {
        ServiceSession sessionobj = ServiceLogs.getSessionobj();
        if (sessionobj != null) {
            JSONObject logmsg = new JSONObject();
            logmsg.put("call_method", (Object)method);
            logmsg.put("call_url", (Object)url);
            logmsg.put("call_returncode", (Object)"0");
            ServiceLogs.debuglog(sessionobj, "call_response", logmsg.toString(), starttime, false);
        }
    }

    public static void logConsumeMqStart(String topic, String key, String othermsg) {
        ServiceSession sessionobj = ServiceLogs.getSessionobj();
        JSONObject logmsg = new JSONObject();
        logmsg.put("topic", (Object)topic);
        logmsg.put("keyvalue", (Object)key);
        logmsg.put("othermsg", (Object)othermsg);
        ServiceLogs.debuglog(sessionobj, "mqconsumer_start", logmsg.toString(), 0L, false);
    }

    public static void logConsumeMqError(String topic, String key, String errcode, String othermsg, long starttime) {
        ServiceSession sessionobj = ServiceLogs.getSessionobj();
        JSONObject logmsg = new JSONObject();
        logmsg.put("topic", (Object)topic);
        logmsg.put("keyvalue", (Object)key);
        logmsg.put("othermsg", (Object)othermsg);
        logmsg.put("mq_returncode", (Object)errcode);
        sessionobj.setReturncode(errcode);
        ServiceLogs.debuglog(sessionobj, "mqconsumer_error", logmsg.toString(), starttime, true);
    }

    public static void logConsumeMqSuccess(String topic, String key, String othermsg, long starttime) {
        ServiceSession sessionobj = ServiceLogs.getSessionobj();
        JSONObject logmsg = new JSONObject();
        logmsg.put("topic", (Object)topic);
        logmsg.put("keyvalue", (Object)key);
        logmsg.put("othermsg", (Object)othermsg);
        logmsg.put("mq_returncode", (Object)"0");
        ServiceLogs.debuglog(sessionobj, "mqconsumer_succ", logmsg.toString(), starttime, false);
    }

    public static void logSendMqStart(String topic, String key, String othermsg) {
        ServiceSession sessionobj = ServiceLogs.getSessionobj();
        JSONObject logmsg = new JSONObject();
        logmsg.put("topic", (Object)topic);
        logmsg.put("keyvalue", (Object)key);
        logmsg.put("othermsg", (Object)othermsg);
        ServiceLogs.debuglog(sessionobj, "mqsend_start", logmsg.toString(), 0L, false);
    }

    public static void logSendMqError(String topic, String key, String errcode, String sendresult, String othermsg, long starttime) {
        ServiceSession sessionobj = ServiceLogs.getSessionobj();
        JSONObject logmsg = new JSONObject();
        logmsg.put("topic", (Object)topic);
        logmsg.put("keyvalue", (Object)key);
        logmsg.put("othermsg", (Object)othermsg);
        logmsg.put("sendresult", (Object)sendresult);
        logmsg.put("mq_returncode", (Object)errcode);
        sessionobj.setReturncode(errcode);
        ServiceLogs.debuglog(sessionobj, "mqsend_error", logmsg.toString(), starttime, true);
    }

    public static void logSendMqSuccess(String topic, String key, String sendresult, String othermsg, long starttime) {
        ServiceSession sessionobj = ServiceLogs.getSessionobj();
        JSONObject logmsg = new JSONObject();
        logmsg.put("topic", (Object)topic);
        logmsg.put("keyvalue", (Object)key);
        logmsg.put("othermsg", (Object)othermsg);
        logmsg.put("sendresult", (Object)sendresult);
        logmsg.put("mq_returncode", (Object)"0");
        ServiceLogs.debuglog(sessionobj, "mqsend_succ", logmsg.toString(), starttime, false);
    }

    private static String getDefaultFormatstr(ServiceSession sessionobj, String logtype, String logmsg, long starttime) {
        StringBuffer sb = new StringBuffer();
        sb.append("rootkey: ");
        sb.append(sessionobj.getRootkey());
        if (logtype.equalsIgnoreCase("request")) {
            sb.append("[" + sessionobj.getRemoteaddr() + " - " + sessionobj.getLogkey() + "]: ");
            sb.append(sessionobj.getMethod() + " , ");
            sb.append("REQUEST  : ");
            sb.append(logmsg);
            sb.append(" , entid : ");
            sb.append(sessionobj.getEnt_id());
        } else if (logtype.equalsIgnoreCase("response")) {
            sb.append("[" + sessionobj.getRemoteaddr() + " - " + sessionobj.getLogkey() + "]: ");
            sb.append(sessionobj.getMethod() + " , ");
            sb.append("ELAPSED  : " + (System.currentTimeMillis() - starttime) + " ms , ");
            sb.append("RESPONSE : ");
            sb.append(logmsg);
        } else {
            sb.append("[" + sessionobj.getRemoteaddr() + " - " + sessionobj.getLogkey() + "]: ");
            sb.append(sessionobj.getMethod() + " , ");
            sb.append(logtype + "  : ");
            sb.append(logmsg);
            sb.append(" , url : ");
            sb.append(sessionobj.getUrl());
        }
        return sb.toString();
    }

    private static String getJsonFormatstr(ServiceSession sessionobj, String logtype, String logmsg, long starttime) {
        JSONObject rtn = (JSONObject)JSONObject.toJSON((Object)sessionobj);
        rtn.put("logtype", (Object)logtype);
        rtn.put("logmsg", (Object)logmsg);
        if (starttime != 0L) {
            rtn.put("elapsed", (Object)(System.currentTimeMillis() - starttime));
        }
        return rtn.toString();
    }

    public static void debuglog(ServiceSession sessionobj, String logtype, String logmsg, long starttime, boolean iserr) {
        String msg = logmsg;
        msg = ServiceVersion.getInstance().getLogFormat().equalsIgnoreCase("json") ? ServiceLogs.getJsonFormatstr(sessionobj, logtype, logmsg, starttime) : ServiceLogs.getDefaultFormatstr(sessionobj, logtype, logmsg, starttime);
        if (iserr) {
            logger.error((Object)msg);
        } else {
            logger.info((Object)msg);
        }
    }

    public static void debuglog(String logtype, String logmsg, long starttime) {
        ServiceSession sessionobj = ServiceLogs.getSessionobj();
        String msg = logmsg;
        msg = ServiceVersion.getInstance().getLogFormat().equalsIgnoreCase("json") ? ServiceLogs.getJsonFormatstr(sessionobj, logtype, logmsg, starttime) : ServiceLogs.getDefaultFormatstr(sessionobj, logtype, logmsg, starttime);
        logger.info((Object)msg);
    }

    public static void truedebuglog(String logtype, String logmsg, long starttime) {
        ServiceSession sessionobj = ServiceLogs.getSessionobj();
        String msg = logmsg;
        String logFromat = "json";
        msg = logFromat.equalsIgnoreCase("json") ? ServiceLogs.getJsonFormatstr(sessionobj, logtype, logmsg, starttime) : ServiceLogs.getDefaultFormatstr(sessionobj, logtype, logmsg, starttime);
        logger.debug((Object)msg);
    }

    public static interface LOGTYPE {
        public static final String RESPONSE = "response";
        public static final String REQUEST = "request";
        public static final String DBSTART = "db_start";
        public static final String DBSUCC = "db_succ";
        public static final String DBERROR = "db_error";
        public static final String CALL_REQUEST = "call_request";
        public static final String CALL_RESPONSE = "call_response";
        public static final String MQSEND_start = "mqsend_start";
        public static final String MQSEND_error = "mqsend_error";
        public static final String MQSEND_succ = "mqsend_succ";
        public static final String MQCONSUMER_start = "mqconsumer_start";
        public static final String MQCONSUMER_error = "mqconsumer_error";
        public static final String MQCONSUMER_succ = "mqconsumer_succ";
    }
}

