/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.util;

import com.efuture.ocp.common.entity.AbstractEntityBean;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.util.BeanField;
import com.efuture.omd.storage.FMybatisTemplate;
import com.efuture.omd.storage.parser.QueryExtractor;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.annotation.Transient;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component(value="batchinsservice")
public class BatchInsService {
    @Value(value="${efuture.batchinsert.batch_rows:1000}")
    private int BATCH_ROWS = 1000;

    public Object getColData(FMybatisTemplate storage, Object o, String type2) throws ParseException {
        SimpleDateFormat timefmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (type2.contains("long")) {
            o = StringUtils.isEmpty((Object)o) ? 0L : Long.parseLong(o.toString());
        } else if (type2.contains("int")) {
            o = StringUtils.isEmpty((Object)o) ? 0 : Integer.parseInt(o.toString());
        } else if (type2.contains("float")) {
            o = Float.valueOf(StringUtils.isEmpty((Object)o) ? 0.0f : Float.parseFloat(o.toString()));
        } else if (type2.contains("double")) {
            o = StringUtils.isEmpty((Object)o) ? 0.0 : Double.parseDouble(o.toString());
        } else if (type2.contains("short")) {
            o = StringUtils.isEmpty((Object)o) ? (short)0 : Short.parseShort(o.toString());
        } else if (type2.contains("boolean")) {
            if (!(o instanceof Boolean)) {
                o = StringUtils.isEmpty((Object)o) ? Boolean.valueOf(false) : Boolean.valueOf("true".equalsIgnoreCase(o.toString()) || "Y".equalsIgnoreCase(o.toString()));
            }
        } else if (type2.contains("date")) {
            if (StringUtils.isEmpty((Object)o)) {
                o = null;
            } else {
                String s = timefmt.format(o);
                o = storage.getDBType() == QueryExtractor.DBTYPE.ORACLE ? "to_date('" + s + "', 'yyyy-MM-dd hh24:mi:ss')" : "'" + s + "'";
            }
        } else if (type2.contains("string")) {
            o = o == null ? String.valueOf(o) : "'" + String.valueOf(o).replace("'", "").replace("\"", "") + "'";
        }
        return o;
    }

    public void batchInsertWithChild(FMybatisTemplate storage, Class objClass, List<Object> lists, int batch_rows) throws Exception {
        if (lists.size() <= 0) {
            return;
        }
        QueryExtractor.DBTYPE dbtype = storage.getDBType();
        if (dbtype != QueryExtractor.DBTYPE.ORACLE && dbtype != QueryExtractor.DBTYPE.MYSQL) {
            throw new Exception("unsupport DBMS Type!");
        }
        String tbl = AbstractEntityBean.fetchAnnotationTableName(objClass);
        StringBuffer sb = new StringBuffer();
        AbstractEntityBean.fetchAllDeclaredField(objClass, sb);
        List<String> flds = Arrays.asList(sb.toString().split(","));
        Object rows = lists.get(0);
        for (String col : flds) {
            Field fld = AbstractEntityBean.fetchDeclaredField(objClass, col);
            if (fld == null || fld.getAnnotation(Transient.class) == null) continue;
            Class<?> cls = fld.getType();
            if (cls.getName().equals(List.class.getName())) {
                System.out.println(cls.getName());
                System.out.println(cls.getTypeParameters());
            }
            Object value = fld.get(rows);
            System.out.println(fld.getName());
            System.out.println(cls.getClass().getName());
        }
    }

    public <T> void batchInsert(FMybatisTemplate storage, Class<?> objClass, List<T> lists) throws Exception {
        this.batchInsert(storage, objClass, lists, this.BATCH_ROWS);
    }

    public void batchInsert(FMybatisTemplate storage, List<Map<String, Object>> lists, String tableName, int batch_rows) throws Exception {
        if (lists.size() <= 0) {
            return;
        }
        HashSet<BeanField> beanFields = new HashSet<BeanField>();
        Map<String, Object> firstRow = lists.get(0);
        Set<String> flds = firstRow.keySet();
        for (String col : flds) {
            BeanField bf = new BeanField();
            bf.setColName(col);
            if (firstRow.get(col) != null) {
                bf.setColType(firstRow.get(col).getClass().toString().toLowerCase());
            } else {
                bf.setColType("string");
            }
            beanFields.add(bf);
        }
        this.batchInsert(storage, beanFields, lists, tableName, batch_rows);
    }

    public <T> void batchInsert(FMybatisTemplate storage, Set<BeanField> beanFields, List<T> lists, String tableName, int batch_rows) throws IllegalAccessException, ParseException, RuntimeException {
        SqlSessionTemplate db = storage.getSqlSessionTemplate();
        QueryExtractor.DBTYPE dbtype = storage.getDBType();
        if (dbtype != QueryExtractor.DBTYPE.ORACLE && dbtype != QueryExtractor.DBTYPE.MYSQL) {
            throw new ServiceException("5000", "unsupport DBMS Type!", new Object[0]);
        }
        int tot_page = (int)Math.ceil((float)lists.size() / (float)batch_rows);
        StringBuffer tabsql = new StringBuffer();
        tabsql.append("insert into ").append(tableName).append("(");
        for (BeanField col : beanFields) {
            tabsql.append(col.getColName()).append(",");
        }
        tabsql.deleteCharAt(tabsql.length() - 1);
        tabsql.append(")");
        for (int page = 0; page < tot_page; ++page) {
            StringBuffer sql = new StringBuffer();
            sql.append(tabsql);
            boolean firstrow = true;
            for (int row = batch_rows * page; row < Math.min(lists.size(), batch_rows * (page + 1)); ++row) {
                T bean = lists.get(row);
                if (dbtype == QueryExtractor.DBTYPE.ORACLE || dbtype == QueryExtractor.DBTYPE.SQLITE) {
                    if (!firstrow) {
                        sql.append(" union all ");
                    }
                    sql.append(" select ");
                    for (BeanField col : beanFields) {
                        sql.append(this.getColData(storage, col.getColValue(bean), col.getColType()));
                        sql.append(",");
                    }
                    sql.deleteCharAt(sql.length() - 1);
                    sql.append(" from dual");
                } else if (dbtype == QueryExtractor.DBTYPE.MYSQL) {
                    if (firstrow) {
                        sql.append(" values ");
                    } else {
                        sql.append(",");
                    }
                    sql.append("(");
                    for (BeanField col : beanFields) {
                        sql.append(this.getColData(storage, col.getColValue(bean), col.getColType()));
                        sql.append(",");
                    }
                    sql.deleteCharAt(sql.length() - 1);
                    sql.append(")");
                }
                firstrow = false;
            }
            db.insert("mybatis.sql.insert", (Object)sql.toString());
        }
    }

    public <T> void batchInsert(FMybatisTemplate storage, Class<?> objClass, List<T> lists, int batch_rows) throws Exception {
        SqlSessionTemplate db = storage.getSqlSessionTemplate();
        if (lists.size() <= 0) {
            return;
        }
        QueryExtractor.DBTYPE dbtype = storage.getDBType();
        if (dbtype != QueryExtractor.DBTYPE.ORACLE && dbtype != QueryExtractor.DBTYPE.MYSQL) {
            throw new Exception("unsupport DBMS Type!");
        }
        String tbl = AbstractEntityBean.fetchAnnotationTableName(objClass);
        StringBuffer sb = new StringBuffer();
        AbstractEntityBean.fetchAllDeclaredField(objClass, sb);
        List<String> flds = Arrays.asList(sb.toString().split(","));
        HashSet<BeanField> beanFields = new HashSet<BeanField>();
        for (String col : flds) {
            Field fld = AbstractEntityBean.fetchDeclaredField(objClass, col);
            if (fld == null || fld.getAnnotation(Transient.class) != null) continue;
            BeanField bf = new BeanField();
            bf.setColName(col);
            bf.setField(fld);
            bf.setColType(fld.getType().getName().toLowerCase());
            beanFields.add(bf);
        }
        int tot_page = (int)Math.ceil((float)lists.size() / (float)batch_rows);
        StringBuffer tabsql = new StringBuffer();
        tabsql.append("insert into ").append(tbl).append("(");
        for (BeanField col : beanFields) {
            tabsql.append(col.getColName()).append(",");
        }
        tabsql.deleteCharAt(tabsql.length() - 1);
        tabsql.append(")");
        for (int page = 0; page < tot_page; ++page) {
            StringBuffer sql = new StringBuffer();
            sql.append(tabsql);
            boolean firstrow = true;
            for (int row = batch_rows * page; row < Math.min(lists.size(), batch_rows * (page + 1)); ++row) {
                T bean = lists.get(row);
                if (dbtype == QueryExtractor.DBTYPE.ORACLE || dbtype == QueryExtractor.DBTYPE.SQLITE) {
                    if (!firstrow) {
                        sql.append(" union all ");
                    }
                    sql.append(" select ");
                    for (BeanField col : beanFields) {
                        sql.append(this.getColData(storage, col.getField().get(bean), col.getColType()));
                        sql.append(",");
                    }
                    sql.deleteCharAt(sql.length() - 1);
                    sql.append(" from dual");
                } else if (dbtype == QueryExtractor.DBTYPE.MYSQL) {
                    if (firstrow) {
                        sql.append(" values ");
                    } else {
                        sql.append(",");
                    }
                    sql.append("(");
                    for (BeanField col : beanFields) {
                        sql.append(this.getColData(storage, col.getField().get(bean), col.getColType()));
                        sql.append(",");
                    }
                    sql.deleteCharAt(sql.length() - 1);
                    sql.append(")");
                }
                firstrow = false;
            }
            db.insert("mybatis.sql.insert", (Object)sql.toString());
        }
    }
}

