/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.Cache;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.Cache.CheckRepeatAnnotation;
import com.efuture.ocp.common.autorollback.AutoRollbackAspect;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.language.MessageSourceHelper;
import com.efuture.ocp.common.util.CacheUtils;
import java.util.Date;
import org.apache.log4j.Logger;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Aspect
@Component
public class CheckRepeatAspect {
    private static final Logger logger = Logger.getLogger(AutoRollbackAspect.class);

    private String getKey(ProceedingJoinPoint point, CheckRepeatAnnotation around) {
        String keyname = around.KeyName();
        int argindex = around.KeyArgIndex();
        String className = point.getTarget().getClass().getSimpleName();
        String methodName = point.getSignature().getName();
        Object[] args = point.getArgs();
        StringBuffer sb = new StringBuffer();
        if (argindex != -1 && args.length > argindex) {
            Object arg = args[argindex];
            JSONObject jsonarg = arg instanceof JSONObject ? (JSONObject)arg : (JSONObject)JSONObject.toJSON((Object)arg);
            if (StringUtils.isEmpty((Object)keyname)) {
                sb.append("_").append(JSONObject.toJSON((Object)arg));
            } else {
                String[] keys = keyname.split(",");
                StringBuffer sbkey = new StringBuffer();
                for (String key : keys) {
                    Object value;
                    if (key == null || (value = jsonarg.get((Object)key)) == null) continue;
                    sbkey.append("-").append(key).append(":").append(value.toString());
                }
                if (sbkey.length() > 0) {
                    sb.append("_").append(sbkey.toString());
                } else {
                    sb.append("_").append(jsonarg.toJSONString());
                }
            }
        } else {
            for (Object arg : args) {
                if (arg == null) continue;
                sb.append("_").append(JSONObject.toJSON((Object)arg));
            }
        }
        return className.concat("_").concat(methodName).concat(sb.toString());
    }

    @Around(value="@annotation(around)")
    public Object round(ProceedingJoinPoint point, CheckRepeatAnnotation around) throws Throwable {
        String cacheKey;
        boolean exist;
        String className = point.getTarget().getClass().getSimpleName();
        String methodName = point.getSignature().getName();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)MessageSourceHelper.formatMessage("\u5f00\u59cb\u68c0\u67e5\u91cd\u590d\u8c03\u7528:className->{0};methodName->{1}", className, methodName));
        }
        if (exist = this.checkexist(cacheKey = this.getKey(point, around))) {
            throw new ServiceException("20000", "\u91cd\u590d\u8c03\u7528", new Object[0]);
        }
        Object result = null;
        try {
            result = point.proceed();
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            CacheUtils.getCacheUtils().deleteData(cacheKey);
        }
        return result;
    }

    public boolean checkexist(String key) {
        boolean addSuccess = false;
        try {
            addSuccess = CacheUtils.getCacheUtils().addData(key, new Date(), 3000);
        }
        catch (Exception e) {
            addSuccess = true;
        }
        return !addSuccess;
    }
}

