/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.autorollback;

import com.efuture.ocp.common.autorollback.RollBackOperationData;
import com.efuture.ocp.common.autorollback.RollbackHandle;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.ocp.common.util.UniqueID;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.util.StringUtils;

public class AutoRollBackService {
    private static final ThreadLocal<List<RollBackOperationData>> operationList = new ThreadLocal();
    private static final ThreadLocal<Long> LocalTrans = new ThreadLocal();
    private static String rollbackhandleobject = "rollbackhandle";
    private static String autoRollbackList = "";
    public static String isEnable = "Y";
    public static Logger logger = Logger.getLogger(AutoRollBackService.class);

    public static Long opentrans() {
        List<Long> curtransary = UniqueID.getUniqueIDArray(10);
        Long curtransid = curtransary.get(4);
        LocalTrans.set(curtransid);
        return curtransid;
    }

    public static Long gettransid() {
        return LocalTrans.get();
    }

    public static boolean needAutoRollback(RollBackOperationData data) {
        String urlkey = data.getUrlkey();
        if (StringUtils.isEmpty((Object)"urlkey")) {
            return false;
        }
        return autoRollbackList.toLowerCase().indexOf(urlkey.toLowerCase()) > -1;
    }

    public static void addOperation(RollBackOperationData data) {
        if (data == null) {
            return;
        }
        if (!AutoRollBackService.needAutoRollback(data)) {
            return;
        }
        List<RollBackOperationData> oplist = operationList.get();
        if (oplist == null) {
            oplist = new ArrayList<RollBackOperationData>();
        }
        oplist.add(data);
        operationList.set(oplist);
    }

    public static void addRestOperation(ServiceSession ss, String url, String urlkey, Object param) {
        RollBackOperationData data = new RollBackOperationData();
        data.setUrl(url);
        data.setUrlkey(urlkey);
        data.setParam(param.toString());
        data.setSession(ss);
        AutoRollBackService.addOperation(data);
    }

    public static void rollback() {
        try {
            RollbackHandle rb;
            if (SpringBeanFactory.containsBean(rollbackhandleobject) && (rb = SpringBeanFactory.getBean(rollbackhandleobject, RollbackHandle.class)) != null && operationList.get() != null) {
                rb.dorollback(operationList.get());
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u81ea\u52a8\u51b2\u6b63\u53d1\u751f\u9519\u8bef->", (Throwable)e);
            operationList.remove();
            LocalTrans.remove();
        }
        finally {
            operationList.remove();
            LocalTrans.remove();
        }
    }

    public static void clean() {
        operationList.remove();
        LocalTrans.remove();
    }

    public static boolean IsEnable() {
        if (isEnable.equalsIgnoreCase("Y") && LocalTrans.get() != null && LocalTrans.get() != 0L) {
            if (SpringBeanFactory.containsBean(rollbackhandleobject)) {
                return true;
            }
            logger.info((Object)"\u542f\u7528\u4e86\u81ea\u52a8\u51b2\u6b63,\u4f46\u662f\u6ca1\u6709\u914d\u7f6e\u51b2\u6b63\u5904\u7406\u5bf9\u8c61!");
            return false;
        }
        return false;
    }

    public static void setIsEnable(String isEnable) {
        AutoRollBackService.isEnable = isEnable;
    }

    public static String getAutoRollbackList() {
        return autoRollbackList;
    }

    public static void setAutoRollbackList(String autoRollbackList) {
        AutoRollBackService.autoRollbackList = autoRollbackList;
    }
}

