/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.filter;

import com.efuture.ocp.common.filter.GzipRequestWrapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GzipResponseWrapper
extends HttpServletResponseWrapper {
    public static final Logger LOGGER = LoggerFactory.getLogger(GzipRequestWrapper.class);
    private HttpServletResponse response;
    private GZipOutputStream gzipOutputStream;
    private PrintWriter writer;

    public GzipResponseWrapper(HttpServletResponse response) {
        super(response);
        this.response = response;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.gzipOutputStream == null) {
            this.gzipOutputStream = new GZipOutputStream(this.response);
        }
        return this.gzipOutputStream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer == null) {
            this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)((Object)new GZipOutputStream(this.response)), "UTF-8"));
        }
        return this.writer;
    }

    public void setContentLength(int contentLength) {
    }

    public void flushBuffer() throws IOException {
        this.gzipOutputStream.flush();
    }

    public void finishResponse() throws IOException {
        if (this.gzipOutputStream != null) {
            this.gzipOutputStream.close();
        }
        if (this.writer != null) {
            this.writer.close();
        }
    }

    public class GZipOutputStream
    extends ServletOutputStream {
        private HttpServletResponse response;
        private GZIPOutputStream gzipOutputStream;
        private ByteArrayOutputStream byteArrayOutputStream;

        public GZipOutputStream(HttpServletResponse response) throws IOException {
            this.response = response;
            this.byteArrayOutputStream = new ByteArrayOutputStream();
            this.gzipOutputStream = new GZIPOutputStream(this.byteArrayOutputStream);
        }

        public void write(int b) throws IOException {
            this.gzipOutputStream.write(b);
        }

        public void close() throws IOException {
            this.gzipOutputStream.finish();
            byte[] content = this.byteArrayOutputStream.toByteArray();
            this.response.addHeader("Content-Encoding", "gzip");
            this.response.addHeader("Content-Length", Integer.toString(content.length));
            ServletOutputStream out = this.response.getOutputStream();
            out.write(content);
            out.close();
        }

        public void flush() throws IOException {
            this.gzipOutputStream.flush();
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.gzipOutputStream.write(b, off, len);
        }

        public void write(byte[] b) throws IOException {
            this.gzipOutputStream.write(b);
        }
    }
}

