/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.util.DateUtils;
import com.efuture.ocp.common.util.PrecisionUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.util.StringUtils;

public class DataUtils {
    public static String nvl(String BeanVal, String ... DefaultVal) {
        if (StringUtils.isEmpty((Object)BeanVal)) {
            for (String val : DefaultVal) {
                if (StringUtils.isEmpty((Object)val)) continue;
                return val;
            }
            return null;
        }
        return BeanVal;
    }

    public static double nvl(double BeanVal, double ... DefaultVal) {
        if (StringUtils.isEmpty((Object)BeanVal) || BeanVal == -1.0) {
            for (double val : DefaultVal) {
                if (StringUtils.isEmpty((Object)val) || val == -1.0) continue;
                return val;
            }
            return 0.0;
        }
        return BeanVal;
    }

    public static int nvl(int BeanVal, int ... DefaultVal) {
        if (StringUtils.isEmpty((Object)BeanVal) || BeanVal == 0) {
            for (int val : DefaultVal) {
                if (StringUtils.isEmpty((Object)val) || val == 0) continue;
                return val;
            }
            return 0;
        }
        return BeanVal;
    }

    public static long nvl(long BeanVal, long ... DefaultVal) {
        if (StringUtils.isEmpty((Object)BeanVal) || BeanVal == 0L) {
            for (long val : DefaultVal) {
                if (StringUtils.isEmpty((Object)val) || val == 0L) continue;
                return val;
            }
            return 0L;
        }
        return BeanVal;
    }

    public static Object checkNull(Object obj, String colName) throws Exception {
        if (StringUtils.isEmpty((Object)obj)) {
            throw new Exception(colName.concat(" must provide!"));
        }
        if (obj instanceof JSONArray && ((JSONArray)obj).size() <= 0) {
            throw new Exception(colName.concat(" must contain content!"));
        }
        return obj;
    }

    public static Object checkValid(Object obj, String colName, String validVals) throws Exception {
        if (StringUtils.isEmpty((Object)obj)) {
            throw new Exception(colName.concat(" must provide!"));
        }
        if (StringUtils.isEmpty((Object)validVals)) {
            return obj;
        }
        if (">0".equals(validVals)) {
            if (PrecisionUtils.doubleCompare(Double.parseDouble(obj.toString()), 0.0, 4) <= 0) {
                throw new Exception(colName.concat(" is invalid, must be >0 !"));
            }
        } else if (">=0".equals(validVals)) {
            if (PrecisionUtils.doubleCompare(Double.parseDouble(obj.toString()), 0.0, 4) < 0) {
                throw new Exception(colName.concat(" is invalid, must be >=0 !"));
            }
        } else {
            List<String> vals = Arrays.asList(validVals.split(","));
            if (!vals.contains(obj)) {
                throw new Exception(colName.concat(" is invalid, must in [" + validVals + "]!"));
            }
        }
        return obj;
    }

    public static void setDefaultValue(Object obj, String defaultValue) throws Exception {
    }

    public static String rpad(String src, int len, char ch) {
        int diff = len - src.length();
        if (diff <= 0) {
            return src;
        }
        char[] charr = new char[len];
        System.arraycopy(src.toCharArray(), 0, charr, 0, src.length());
        for (int i = src.length(); i < len; ++i) {
            charr[i] = ch;
        }
        return new String(charr);
    }

    public static String lpad(String src, int len, char ch) {
        int diff = len - src.length();
        if (diff <= 0) {
            return src;
        }
        char[] charr = new char[len];
        System.arraycopy(src.toCharArray(), 0, charr, diff, src.length());
        for (int i = 0; i < diff; ++i) {
            charr[i] = ch;
        }
        return new String(charr);
    }

    public static JSONArray AddToArray(String key, JSONArray arr) {
        JSONArray result = new JSONArray();
        JSONObject jsonObj = new JSONObject();
        jsonObj.put(key, (Object)arr);
        result.add((Object)jsonObj);
        return result;
    }

    public static String Add_Days(JSONObject json, String key, int days) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if (StringUtils.isEmpty((Object)json) || !json.containsKey((Object)key)) {
            return null;
        }
        try {
            return sdf.format(DateUtils.addDays((Date)sdf.parse(json.getString(key)), (int)days));
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Map<String, Object> cloneMap(Map<String, Object> map) {
        ConcurrentHashMap<String, Object> result = new ConcurrentHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            result.put(entry.getKey().toString(), entry.getValue());
        }
        return result;
    }

    public static String getJsonData(JSONObject param, String key, boolean checknull, String defaultVal) throws Exception {
        if (StringUtils.isEmpty((Object)param) || !param.containsKey((Object)key) || StringUtils.isEmpty((Object)param.get((Object)key))) {
            if (checknull) {
                throw new ServiceException("10000", "\u3010{0}\u3011 is Null", key);
            }
            return defaultVal;
        }
        return param.getString(key);
    }

    public static int getJsonData(JSONObject param, String key, boolean checknull, int defaultVal) throws Exception {
        if (StringUtils.isEmpty((Object)param) || !param.containsKey((Object)key) || StringUtils.isEmpty((Object)param.get((Object)key))) {
            if (checknull) {
                throw new ServiceException("10000", "\u3010{0}\u3011 is Null", key);
            }
            return defaultVal;
        }
        return param.getInteger(key);
    }

    public static long getJsonData(JSONObject param, String key, boolean checknull, long defaultVal) throws Exception {
        if (StringUtils.isEmpty((Object)param) || !param.containsKey((Object)key) || StringUtils.isEmpty((Object)param.get((Object)key))) {
            if (checknull) {
                throw new ServiceException("10000", "\u3010{0}\u3011 is Null", key);
            }
            return defaultVal;
        }
        return param.getLongValue(key);
    }

    public static double getJsonData(JSONObject param, String key, boolean checknull, double defaultVal) throws Exception {
        if (StringUtils.isEmpty((Object)param) || !param.containsKey((Object)key) || StringUtils.isEmpty((Object)param.get((Object)key))) {
            if (checknull) {
                throw new ServiceException("10000", "\u3010{0}\u3011 is Null", key);
            }
            return defaultVal;
        }
        return param.getDoubleValue(key);
    }
}

