/**
 * Copyright (C), 2007-2014, eFuture 北京富基融通科技有限公司 FileName: BaseComponent.java
 * Author: 亮 Date: 2014-3-27 上午10:17:09 Description: History:
 * <author> <time> <version> <description>
 * 
 */
package com.efuture.ocp.common.component;

import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.datasync.DataSyncUtils;
import com.efuture.ocp.common.entity.AbstractEntityBean;
import com.efuture.ocp.common.entity.BeanConstant;
import com.efuture.ocp.common.entity.OperationLogBean;
import com.efuture.ocp.common.exception.AlreadyExistException;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.language.MessageSourceHelper;
import com.efuture.ocp.common.language.ResponseCode;
import com.efuture.ocp.common.util.BeanField;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.ocp.common.util.StorageUtils;
import com.efuture.ocp.common.util.UniqueID;
import com.efuture.ocp.common.util.Utils;
import com.efuture.omd.storage.FMybatisTemplate;
import com.efuture.omd.storage.FStorageOperations;
import com.efuture.omd.storage.parser.QueryExtractor.DBTYPE;

/**
 * @author 亮
 * @description 服务组件基类
 * 
 */
public class BasicComponent extends BaseService
{
    public final static String StorageOperation = "StorageOperation";

    private String StorageOperation_other = "";

    public void setStorageOperation_other(String sokey)
    {
        StorageOperation_other = sokey;
    }

    public String getStorageOperationKey()
    {
        if (!StringUtils.isEmpty(StorageOperation_other) && SpringBeanFactory.containsBean(StorageOperation_other))
        {
            return StorageOperation_other;
        }
        else
        {
            return StorageOperation;
        }
    }

    /**
     * 获取数据库操作操作对象
     * 
     * @return
     */
    public FStorageOperations getStorageOperations()
    {
        return SpringBeanFactory.getBean(getStorageOperationKey(), FStorageOperations.class);
    }

    public <T> T getStorageOperations(Class<T> clazz)
    {
        return SpringBeanFactory.getBean(getStorageOperationKey(), clazz);
    }

    /**
     * 效验Bean操作，继承类可以覆盖
     * 
     * @throws ServiceException
     */
    protected void onAddValid(FStorageOperations storage, AbstractEntityBean bean, String id, String... uniques) throws Exception
    {
        // Bean验证
        bean.validateBean();

        // 检查重复字段
        if (storage != null)
        {
            for (int i = 0; uniques != null && i < uniques.length; i++)
            {
                String[] uks = uniques[i].split(",");
                if (uks.length <= 0) continue;

                String code = null;
                java.lang.reflect.Field fld = null;
                Criteria criteria = Criteria.where("ent_id").is(bean.getEnt_id());
                for (String k : uks)
                {
                    code = k.trim();
                    fld = bean.fetchDeclaredField(code);
                    Object obj = fld.get(bean);
                    if (StringUtils.isEmpty(obj)) continue;
                    criteria = criteria.and(code).is(obj);
                }
                Query query = new Query(criteria);
                printDebug(String.format("Bean:[%1$s] Operate:[doAdd(%2$s) valid dup] MongoSyntax:[%3$s]", this.getClass().getCanonicalName(), bean.fetchAnnotationTableName(),
                        query));
                Object existbean = storage.selectOne(query, bean.getClass());

                if (existbean != null) { throw new AlreadyExistException(ResponseCode.Failure.ALREADY_EXISTS, "{0} {1} [{2}] already exists",
                        MessageSourceHelper.getMessage(bean.fetchAnnotationTableName(), bean.getLang()), code, fld.get(bean)); }
            }
        }
    }

    /**
     * 通用Bean模式单表新增
     * 
     * @param bean
     *            需要存储的Bean
     * @param id
     *            唯一关键字字段列名【如品牌的bid、账户的aid】,必须是Long类型，如果未设置，则由插入时自动生成
     * @param uniques
     *            需要检查在数据库中是否重复的字段【注意是判断的单字段内容是否重复，例如编码重复、名称重复两个判断为[code,name]】
     * @return
     * @throws Exception
     */
    @Transactional(propagation = Propagation.REQUIRED)
    public long doAdd(AbstractEntityBean bean, String id, String... uniques) throws Exception
    {
        FStorageOperations storage = null;
        try
        {
            // 生成ID,不能通过判断来生成ID,避免UI传入ID
            java.lang.reflect.Field idfld = bean.fetchDeclaredField(id);
            if (idfld.getLong(bean) <= 0) idfld.set(bean, UniqueID.getUniqueID());

            // 得到数据源
            storage = getStorageOperations();

            // Add验证
            onAddValid(storage, bean, id, uniques);

            // 插入数据库
            printDebug(String.format("Bean:[%1$s] Operate:[doAdd(%2$s)] MongoSyntax:[%3$s->%4$20d]", this.getClass().getCanonicalName(), bean.fetchAnnotationTableName(),
                    bean.getEnt_id(), idfld.getLong(bean)));
            storage.insert(bean);

            // 记录更新日志
            if (bean != null && isOperationLog())
            {
                Set<String> keys = new HashSet<String>();
                StringBuffer sb = new StringBuffer();
                bean.fetchAllDeclaredField(sb);
                String[] ss = sb.toString().split(",");
                for (int i = 0; i < ss.length; i++)
                    keys.add(ss[i]);
                String[] ks = new String[keys.size()];
                OperationLogBean log = createOperationLog("ADD", "用户 [" + bean.getCreator() + "] 新增 " + id + " = [" + idfld.get(bean) + "] 的数据", bean, bean, keys.toArray(ks));
                if (log != null) storage.insert(log);
            }
            doSyncData(bean);
            // 返回ID列
            return idfld.getLong(bean);
        }
        finally
        {
            if (storage != null) storage.destroy();
        }
    }

    protected void onOriginalUpdateValid(AbstractEntityBean original, AbstractEntityBean bean, Set<String> keys, String id, String... uniques) throws Exception
    {
        // 发布状态不能修改
        // if
        // (BeanConstant.Status.PUBLISH.equalsIgnoreCase(original.getStatus())
        // &&
        // (keys != null && !keys.contains("status") ||
        // BeanConstant.Status.PUBLISH.equalsIgnoreCase(bean.getStatus())))
        // {
        // Field idfld = bean.fetchDeclaredField(id);
        // throw new ServiceException(ResponseCode.Failure.ALREADY_PUBLISH,"{0}
        // {1} [{2}] already publish,can not
        // update",MessageSourceHelper.getMessage(bean.fetchAnnotationTableName(),bean.getLang()),id,idfld.get(bean));
        // }
    }

    protected AbstractEntityBean onUpdateValid(FStorageOperations storage, AbstractEntityBean bean, Set<String> keys, String id, String... uniques) throws Exception
    {
        List<String> vk = new ArrayList<String>();
        vk.add("ent_id");
        vk.add(id);
        if (keys != null) for (String k : keys)
            vk.add(k);

        // Bean验证
        bean.validateBeanForSpecified(vk.toArray(new String[vk.size()]));

        // 获得原始对象
        AbstractEntityBean original = null;
        if (storage != null)
        {
            // 获得原始对象
            java.lang.reflect.Field idfld = bean.fetchDeclaredField(id);
            Criteria criteria = Criteria.where("ent_id").is(bean.getEnt_id()).and(id).is(idfld.get(bean));
            Query query = new Query(criteria);
            original = storage.selectOne(query, bean.getClass());

            // 检查数据是否允许修改
            if (original != null) onOriginalUpdateValid(original, bean, keys, id, uniques);

            // 检查重复字段,值相同但是ID不同，说明值已存在
            for (int i = 0; uniques != null && i < uniques.length; i++)
            {
                String[] uks = uniques[i].split(",");
                if (uks.length <= 0) continue;

                // 更新字段中有需要检查重复的字段
                String code = uks[uks.length - 1].trim();
                if (keys.contains(code))
                {
                    java.lang.reflect.Field fld = null;
                    criteria = Criteria.where("ent_id").is(bean.getEnt_id());
                    for (String k : uks)
                    {
                        code = k.trim();
                        fld = bean.fetchDeclaredField(code);
                        Object obj = null;
                        if (!keys.contains(code) && original != null) obj = fld.get(original);
                        else obj = fld.get(bean);
                        if (StringUtils.isEmpty(obj)) continue;
                        criteria = criteria.and(code).is(obj);
                    }
                    criteria = criteria.and(id).ne(bean.fetchDeclaredField(id).get(bean));
                    query = new Query(criteria);
                    printDebug(String.format("Bean:[%1$s] Operate:[doUpdate(%2$s) valid dup] MongoSyntax:[%3$s]", this.getClass().getCanonicalName(),
                            bean.fetchAnnotationTableName(), query));
                    Object existbean = storage.selectOne(query, bean.getClass());

                    if (existbean != null) { throw new AlreadyExistException(ResponseCode.Failure.ALREADY_EXISTS, "{0} {1} [{2}] already exists",
                            MessageSourceHelper.getMessage(bean.fetchAnnotationTableName(), bean.getLang()), code, fld.get(bean)); }
                }
            }
        }

        return original;
    }

    /**
     * 通用Bean模式单表修改
     * 
     * @param bean
     *            需要更新的Bean
     * @param keys
     *            需要更新的字段列表。例如需要更新password字段，则set内容为password字段名
     * @param id
     *            唯一关键字字段列名【如品牌的bid、账户的aid】,必须是Long类型，如果未设置，则由插入时自动生成
     * @param uniques
     *            需要检查在数据库中是否重复的字段【注意是判断的单字段内容是否重复，例如编码重复、名称重复两个判断为[code,name]】
     * @return
     * @throws Exception
     */
    @Transactional(propagation = Propagation.REQUIRED)
    public Object doUpdate(AbstractEntityBean bean, Set<String> keys, String id, String... uniques) throws Exception
    {
        AbstractEntityBean original = execUpdate(bean, keys, id, uniques);

        if (original != null)
        {
            java.lang.reflect.Field fld = bean.fetchDeclaredField(id);
            return fld.get(original);
        }
        else
        {
            return 0;
        }
    }

    @Transactional(propagation = Propagation.REQUIRED)
    public AbstractEntityBean execUpdate(AbstractEntityBean bean, Set<String> keys, String id, String... uniques) throws Exception
    {
        FStorageOperations storage = null;
        try
        {
            // 不指定更新列就是Bean的所有列
            if (keys == null)
            {
                keys = new HashSet<String>();
                StringBuffer sb = new StringBuffer();
                bean.fetchAllDeclaredField(sb);
                String[] ss = sb.toString().split(",");
                for (int i = 0; i < ss.length; i++)
                    keys.add(ss[i]);
            }
            else
            {
                // 需要更新时间戳和修改人
                if (!(keys instanceof HashSet)) keys = new HashSet<String>(keys);

                if (!keys.contains("timestamp")) keys.add("timestamp");
                if (!keys.contains("modifier_id")) keys.add("modifier_id");
                if (!keys.contains("modifier")) keys.add("modifier");
            }

            // 得到数据源
            storage = getStorageOperations();

            // update验证
            AbstractEntityBean original = onUpdateValid(storage, bean, keys, id, uniques);

            // 再按ID找存在的对象
            java.lang.reflect.Field fld = bean.fetchDeclaredField(id);
            Query query = new Query(Criteria.where("ent_id").is(bean.getEnt_id()).and(id).is(fld.get(bean)));
            Update upt = StorageUtils.createUpdateFormBean(bean, keys);
            printDebug(String.format("Bean:[%1$s] Operate:[doUpdate(%2$s)/update] MongoSyntax:[%3$s]", this.getClass().getCanonicalName(), bean.fetchAnnotationTableName(), query));
            if (storage.update(query, upt, bean.getClass()) <= 0)
            {
                throw new ServiceException(ResponseCode.Failure.NOT_EXIST, "{0} {1} [{2}] does not exist",
                        MessageSourceHelper.getMessage(bean.fetchAnnotationTableName(), bean.getLang()), id, fld.get(bean));
            }
            else
            {
                // 记录更新日志
                if (original != null && isOperationLog())
                {
                    String[] ks = new String[keys.size()];
                    OperationLogBean log = createOperationLog("UPDATE", "用户 [" + bean.getModifier() + "] 更新 " + id + " = [" + fld.get(bean) + "] 的数据", original, bean,
                            keys.toArray(ks));
                    if (log != null) storage.insert(log);
                }
                doSyncData(bean);
                return original;
            }
        }
        finally
        {
            if (storage != null) storage.destroy();
        }
    }

    private void doSyncData(AbstractEntityBean bean)
    {
        DataSyncUtils.sync(bean);
    }

    protected void onOriginalDeleteValid(AbstractEntityBean original, AbstractEntityBean bean, String id, String... keys) throws Exception
    {
        // 发布状态不能删除
        // if
        // (BeanConstant.Status.PUBLISH.equalsIgnoreCase(original.getStatus()))
        // {
        // java.lang.reflect.Field idfld = bean.fetchDeclaredField(id);
        // throw new ServiceException(ResponseCode.Failure.ALREADY_PUBLISH,"{0}
        // {1} [{2}] already publish,can not
        // delete",MessageSourceHelper.getMessage(bean.fetchAnnotationTableName(),bean.getLang()),id,idfld.get(bean));
        // }
    }

    protected AbstractEntityBean onDeleteValid(FStorageOperations storage, AbstractEntityBean bean, String id, String... keys) throws Exception
    {
        // Bean验证
        List<String> vk = new ArrayList<String>();
        vk.add("ent_id");
        vk.add(id);
        if (keys != null) for (String k : keys)
            vk.add(k);

        // Bean验证
        bean.validateBeanForSpecified(vk.toArray(new String[vk.size()]));

        // 获得原始对象
        AbstractEntityBean original = null;
        if (storage != null)
        {
            // 获得原始对象
            java.lang.reflect.Field idfld = bean.fetchDeclaredField(id);
            Criteria criteria = Criteria.where("ent_id").is(bean.getEnt_id()).and(id).is(idfld.get(bean));
            if (keys != null)
            {
                for (String k : keys)
                {
                    java.lang.reflect.Field fd = bean.fetchDeclaredField(k);
                    criteria = criteria.and(k).is(fd.get(bean));
                }
            }
            Query query = new Query(criteria);
            original = storage.selectOne(query, bean.getClass());

            // 发布状态不能修改
            if (original != null) onOriginalDeleteValid(original, bean, id, keys);
        }

        return original;
    }

    /**
     * 通用Bean模式单表删除
     * 
     * @param bean
     *            需要更新的Bean
     * @param id
     *            唯一关键字字段列名【如品牌的bid、账户的aid】,必须是Long类型，如果未设置，则由插入时自动生成
     * @param code
     *            如果传入id名称为空，则通过编码删除
     * @return
     * @throws Exception
     */
    @Transactional(propagation = Propagation.REQUIRED)
    public Object doDelete(AbstractEntityBean bean, String id, String... keys) throws Exception
    {
    	
        AbstractEntityBean original = execDelete(bean, id, keys);

        if (original != null)
        {
            java.lang.reflect.Field fld = bean.fetchDeclaredField(id);
            return fld.get(original);
        }
        else
        {
            return 0;
        }
    }

    @Transactional(propagation = Propagation.REQUIRED)
    public AbstractEntityBean execDelete(AbstractEntityBean bean, String id, String... keys) throws Exception
    {
        FStorageOperations storage = null;
        try
        {
            // 得到数据源
            storage = getStorageOperations();

            // delete验证
            AbstractEntityBean original = onDeleteValid(storage, bean, id, keys);

            // 按ID找存在的对象
            java.lang.reflect.Field fld = bean.fetchDeclaredField(id);
            Criteria criteria = Criteria.where("ent_id").is(bean.getEnt_id()).and(id).is(fld.get(bean));
            if (keys != null && keys.length != 0)
            {
                for (String k : keys)
                {
                    java.lang.reflect.Field fd = bean.fetchDeclaredField(k);
                    criteria = criteria.and(k).is(fd.get(bean));
                }
            }
            Query query = new Query(criteria);
            printDebug(String.format("Bean:[%1$s] Operate:[doDelete(%2$s)] MongoSyntax:[%3$s]", this.getClass().getCanonicalName(), bean.fetchAnnotationTableName(), query));
            storage.delete(query, bean.getClass());

            // 记录删除日志
            if (original != null && isOperationLog())
            {
                if (keys.length == 0)
                {
                    StringBuffer sb = new StringBuffer();
                    original.fetchAllDeclaredField(sb);
                    keys = sb.toString().split(",");
                }
                OperationLogBean log = createOperationLog("DELETE", "用户 [" + bean.getModifier() + "] 删除 " + id + " = [" + fld.get(bean) + "] 的数据", original, bean, keys);
                if (log != null) storage.insert(log);
            }

            return original;
        }
        finally
        {
            if (storage != null) storage.destroy();
        }
    }

    protected boolean isOperationLog()
    {
        return SpringBeanFactory.containsBean("OperationLog");
    }

    protected OperationLogBean createOperationLog(String oper, String message, AbstractEntityBean originalbean, AbstractEntityBean newbean, String... keys)
    {
        try
        {
            OperationLogBean operlog = SpringBeanFactory.getBean("OperationLog", OperationLogBean.class);
            if (operlog == null) return null;

            // 设置修改人、修改时间
            if (newbean != null) operlog.initUpdateMember(newbean);
            else operlog.initUpdateMember(originalbean);

            String[] uniquekeys = null;
            String idkey = (String) AbstractEntityBean.fetchDeclaredField(originalbean.getClass(), "ID_KEY").get(null);
            Field uniquefld = AbstractEntityBean.fetchDeclaredField(originalbean.getClass(), "UNIQUE_KEYS");
            if (uniquefld != null) uniquekeys = (String[]) uniquefld.get(null);

            operlog.setOper(oper);
            operlog.setMessage(message);
            operlog.setTablename(AbstractEntityBean.fetchAnnotationTableName(originalbean.getClass()));
            operlog.setDataid(AbstractEntityBean.fetchDeclaredField(originalbean.getClass(), idkey).getLong(originalbean));

            if ("ADD".equalsIgnoreCase(oper))
            {
                operlog.setModifier_id(newbean.getCreator_id());
                operlog.setModifier(newbean.getCreator());
            }
            else
            {
                operlog.setModifier_id(newbean.getModifier_id());
                operlog.setModifier(newbean.getModifier());
            }

            // 原值,记录唯一键
            Map<String, Object> map = new HashMap<String, Object>();
            // if (uniquekeys != null)
            // {
            // for (String key : uniquekeys)
            // {
            // String[] uks = key.split(",");
            // if (uks.length <= 0) continue;
            //
            // for (String k : uks)
            // {
            // k = k.trim();
            // Field fld = originalbean.fetchDeclaredField(k);
            // if (fld != null && !idkey.equalsIgnoreCase(k))
            // map.put(k,fld.get(originalbean));
            // }
            // }
            // }

            // 修改记录新值
            if (keys != null)
            {
                Map<String, Object> newmap = new HashMap<String, Object>();

                // 找到发生改变的值进行记录
                for (String k : keys)
                {
                    k = k.trim();

                    // 忽略字段
                    if ("timestamp".equalsIgnoreCase(k)) continue;
                    if ("creator_id".equalsIgnoreCase(k)) continue;
                    if ("creator".equalsIgnoreCase(k)) continue;
                    if ("modifier_id".equalsIgnoreCase(k)) continue;
                    if ("modifier".equalsIgnoreCase(k)) continue;
                    Map<String, Object> ignoreMap = operlog.getIgnore();
                    if (ignoreMap != null && ignoreMap.containsKey(operlog.getTablename()))
                    {
                        String ignore = ignoreMap.get(operlog.getTablename()).toString();
                        if ("*".equals(ignore) || Utils.stringArrayContainsKey(ignore.split(","), k, true)) continue;
                    }

                    // 指定字段
                    Map<String, Object> assignMap = operlog.getAssign();
                    if (assignMap != null && assignMap.containsKey(operlog.getTablename()))
                    {
                        String assign = assignMap.get(operlog.getTablename()).toString();
                        if (!"*".equals(assign) && !Utils.stringArrayContainsKey(assign.split(","), k, true) && !Utils.stringArrayContainsKey(uniquekeys, k, true)) continue;
                    }

                    Field fld = originalbean.fetchDeclaredField(k);
                    if (fld != null && !idkey.equalsIgnoreCase(k))
                    {
                        Object originalobj = fld.get(originalbean);
                        Object newobj = fld.get(newbean);

                        if (newobj instanceof ArrayList) continue;

                        if ("ADD".equalsIgnoreCase(oper))
                        {
                            newmap.put(k, newobj);
                        }
                        else if ("UPDATE".equalsIgnoreCase(oper))
                        {
                            // 原值<>新值才记录
                            if (!String.valueOf(originalobj).equals(String.valueOf(newobj)))
                            {
                                map.put(k, originalobj);
                                newmap.put(k, newobj);
                            }
                        }
                        else
                        {
                            map.put(k, originalobj);
                        }

                    }
                }

                // 新值
                if (newmap.size() > 0) operlog.setNew_value(JSONObject.toJSONString(newmap));
            }

            // 原值
            if (map.size() > 0) operlog.setOriginal_value(JSONObject.toJSONString(map));

            if (operlog.getNew_value() == null && operlog.getOriginal_value() == null && ("UPDATE".equalsIgnoreCase(oper))) operlog = null;

            return operlog;
        }
        catch (Exception ex)
        {
            return null;
        }
    }

    /**
     * 通用单表查询，返回List<map>结果集，如果未指定返回之短，则返回所有字段；否则返回指定字段的结果集
     * 
     * @param jsonparam
     *            查询参数
     * @param objClass
     *            返回类
     * @param total
     *            返回记录数
     * @return
     * @throws Exception
     */
    @SuppressWarnings("unchecked")
    public List<Map<String, Object>> doSearchForMap(JSONObject jsonparam, Class<?> objClass, StringBuffer total) throws Exception
    {
        // 限定返回字段
        if (!jsonparam.containsKey(BeanConstant.QueryField.PARAMKEY_FIELDS))
        {
            StringBuffer sb = new StringBuffer();
            AbstractEntityBean.fetchAllDeclaredField(objClass, sb);

            jsonparam.put(BeanConstant.QueryField.PARAMKEY_FIELDS, sb.toString());
        }

        return (List<Map<String, Object>>) doGet(jsonparam, objClass, total);
    }

    /**
     * 通用单表查询，返回单行结果
     * 
     * @param jsonparam
     *            查询参数
     * @param objClass
     *            返回类
     * @return
     * @throws Exception
     */
    public Map<String, Object> doSearchOneForMap(JSONObject jsonparam, Class<?> objClass) throws Exception
    {
        // 限制只查1行数据
        jsonparam.put(BeanConstant.QueryField.PARAMKEY_PAGESIZE, 1);

        List<Map<String, Object>> list = doSearchForMap(jsonparam, objClass, null);
        if (list != null && list.size() > 0) return list.get(0);
        else return null;
    }

    /**
     * 通用单表查询，返回List<bean>
     * 
     * @param jsonparam
     *            查询参数
     * @param objClass
     *            返回类
     * @param total
     *            返回记录数
     * @return
     * @throws Exception
     */
    @SuppressWarnings("unchecked")
    public <T> List<T> doSearch(JSONObject jsonparam, Class<T> objClass, StringBuffer total) throws Exception
    {
        // 不限定返回字段
        jsonparam.remove(BeanConstant.QueryField.PARAMKEY_FIELDS);

        return (List<T>) doGet(jsonparam, objClass, total);
    }

    /**
     * 通用单表查询，返回单行结果
     * 
     * @param jsonparam
     *            查询参数
     * @param objClass
     *            返回类
     * @return
     * @throws Exception
     */
    public <T> T doSearchOne(JSONObject jsonparam, Class<T> objClass) throws Exception
    {
        // 限制只查1行数据
        jsonparam.put(BeanConstant.QueryField.PARAMKEY_PAGESIZE, 1);

        List<T> list = doSearch(jsonparam, objClass, null);
        if (list != null && list.size() > 0) return list.get(0);
        else return null;
    }

    // 通用单表查询
    protected List<?> doGet(JSONObject jsonparam, Class<?> objClass, StringBuffer total) throws Exception
    {
        FStorageOperations storage = null;
        try
        {
            // 得到数据源
            storage = getStorageOperations();

            // 不返回总行数也没有设定分页大小则不分页
            Query query = null;
            if (total == null && !jsonparam.containsKey(BeanConstant.QueryField.PARAMKEY_PAGESIZE)) query = StorageUtils.createQueryFormJson(jsonparam, objClass, false);
            else query = StorageUtils.createQueryFormJson(jsonparam, objClass);

            // 指定返回字段则返回
            List<?> list = null;
            if (jsonparam.containsKey(BeanConstant.QueryField.PARAMKEY_FIELDS) && !StringUtils.isEmpty(jsonparam.get(BeanConstant.QueryField.PARAMKEY_FIELDS)))
            {
                printDebug(String.format("Bean:[%1$s] Operate:[doGet(%2$s)Map] MongoSyntax:[%3$s]", this.getClass().getCanonicalName(),
                        AbstractEntityBean.fetchAnnotationTableName(objClass), query));
                list = storage.select(query, AbstractEntityBean.fetchAnnotationTableName(objClass));
            }
            else
            {
                printDebug(String.format("Bean:[%1$s] Operate:[doGet(%2$s)Bean] MongoSyntax:[%3$s]", this.getClass().getCanonicalName(),
                        AbstractEntityBean.fetchAnnotationTableName(objClass), query));
                list = storage.select(query, objClass);
            }

            // 设置总数
            if (total != null)
            {
                total.delete(0, total.length());
                if (list == null || list.size() <= 0) total.append("0");
                else if (query.getLimit() > 0)
                {
                    total.append(storage.count(query, objClass));
                }
                else
                {
                    total.append(list.size());
                }
            }
            return list;
        }
        finally
        {
            if (storage != null) storage.destroy();
        }
    }

    // 分解导出字段
    protected void analyzeExportFields(String specfld, StringBuffer flds, List<String> fldlst, Map<String, String> disps, Map<String, String> fmts)
    {
        // fields="fld1:XXXX:fmt,fld2:XXXXX:fmt,fld3:XXXXX:fmt";
        String[] fields = specfld.split(",");
        for (String s : fields)
        {
            String[] ss = s.split(":");
            flds.append(ss[0].trim() + ",");
            fldlst.add(ss[0].trim());
            if (ss.length > 1)
            {
                disps.put(ss[0].trim(), ss[1].trim());
                if (ss.length > 2) fmts.put(ss[0].trim(), ss[2].trim().replace(";", ","));
            }
            else
            {
                disps.put(ss[0].trim(), ss[0].trim());
            }
        }
    }

    // 生成XLS导出
    protected String createExportXLS(List<Map<String, Object>> list, List<String> fldlst, Map<String, String> disps, Map<String, String> fmts)
    {
        // 生成XLS文件的XML
        StringBuffer sb = new StringBuffer();
        sb.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\r\n");
        sb.append("<table cellspacing=\"0\" cellpadding=\"5\" rules=\"all\" border=\"1\">\r\n");

        // 生成列头
        sb.append("<tr style=\"font-weight: bold; color:red; white-space: nowrap;\">\r\n");
        for (String s : fldlst)
            sb.append(String.format("<td>%1$s</td>\r\n", disps.get(s)));
        sb.append("</tr>\r\n");

        // 填写数据
        if (list != null)
        {
            for (Map<String, Object> mp : list)
            {
                sb.append("<tr>\r\n");
                for (String s : fldlst)
                {
                    Object obj = mp.get(s);
                    if (obj == null) sb.append(String.format("<td style=\"vnd.ms-excel.numberformat:@\">%1$s</td>\r\n", ""));
                    else
                    {
                    	
                        String style = fmts.get(s);
                        if (obj instanceof Date)
                        {
                            if (StringUtils.isEmpty(style)) style = "yyyy-mm-dd";
                       /*     // long date = ((Date) obj).getTime() / 86400000 + 25569; // 毫秒转为天,JAVA的日期型从1970-1-1开始，excle从1900-1-1开始
                            long date = ((Date) obj).getTime() / 86400000 + 25570; // 毫秒转为天,JAVA的日期型从1970-1-1开始，excle从1900-1-1开始
                            sb.append(String.format("<td style=\"vnd.ms-excel.numberformat:" + style + "\">%1$s</td>\r\n", date));
                            }else{  
                            	int idx = obj.toString().lastIndexOf(".");
                            	//obj=org.apache.commons.lang3.StringUtils.substringBefore(obj.toString(), ".");
                                sb.append(String.format("<td style=\"vnd.ms-excel.numberformat:@\">%1$s</td>\r\n", obj.toString().substring(0,idx)));
                            }             */   
                            style = "@";
                            sb.append(String.format("<td style=\"vnd.ms-excel.numberformat:" + style + "\">%1$s</td>\r\n", new SimpleDateFormat("yyyy-MM-dd").format((Date) obj)));
                            }
                        else
                        {
                            if (StringUtils.isEmpty(style))
                            {
                                if (obj instanceof Integer || obj instanceof Long || obj instanceof Short) style = "0";
                                else if (obj instanceof Double || obj instanceof Float) style = "#,##0.00";
                                else style = "@";
                            }
                            sb.append(String.format("<td style=\"vnd.ms-excel.numberformat:" + style + "\">%1$s</td>\r\n", obj));
                        }
                    }
                }
                sb.append("</tr>\r\n");
            }
        }
        sb.append("</table>\r\n");

        // 返回
        return sb.toString();
    }

    protected String getParam(JSONObject param, String key, String defaultVal) throws Exception
    {
        if (!param.containsKey(key) || StringUtils.isEmpty(param.get(key))) return defaultVal;

        return param.getString(key);
    }

    protected String getParamWithCheck(JSONObject param, String key, boolean checknull, String defaultVal) throws Exception
    {
        if (!param.containsKey(key) || StringUtils.isEmpty(param.get(key)))
        {
            if (checknull)
            {
                throw new ServiceException(ResponseCode.FAILURE, "【{0}】 is Null", key);
            }
            else
            {
                return defaultVal;
            }
        }
        return param.getString(key);
    }
    
    protected int getParamWithCheck(JSONObject param, String key, boolean checknull, int defaultVal) throws Exception
    {
        if (!param.containsKey(key) || StringUtils.isEmpty(param.get(key)))
        {
            if (checknull)
            {
                throw new ServiceException(ResponseCode.FAILURE, "【{0}】 is Null", key);
            }
            else
            {
                return defaultVal;
            }
        }
        return param.getInteger(key);
    }
    
    protected long getParamWithCheck(JSONObject param, String key, boolean checknull, long defaultVal) throws Exception
    {
        if (!param.containsKey(key) || StringUtils.isEmpty(param.get(key)))
        {
            if (checknull)
            {
                throw new ServiceException(ResponseCode.FAILURE, "【{0}】 is Null", key);
            }
            else
            {
                return defaultVal;
            }
        }
        return param.getLongValue(key);
    }
    
    protected double getParamWithCheck(JSONObject param, String key, boolean checknull, double defaultVal) throws Exception
    {
        if (!param.containsKey(key) || StringUtils.isEmpty(param.get(key)))
        {
            if (checknull)
            {
                throw new ServiceException(ResponseCode.FAILURE, "【{0}】 is Null", key);
            }
            else
            {
                return defaultVal;
            }
        }
        return param.getDoubleValue(key);
    }
    
    
    public Object getColData(FMybatisTemplate storage, Object o, String type2)
    {
        SimpleDateFormat timefmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (type2.contains("long")) o = StringUtils.isEmpty(o)?0:Long.parseLong(o.toString());
        else
        if (type2.contains("int")) o = StringUtils.isEmpty(o)?0:Integer.parseInt(o.toString());    
        else
        if (type2.contains("float")) o = StringUtils.isEmpty(o)?0:Float.parseFloat(o.toString());    
        else
        if (type2.contains("double")) o = StringUtils.isEmpty(o)?0:Double.parseDouble(o.toString());    
        else
        if (type2.contains("short")) o = StringUtils.isEmpty(o)?0:Short.parseShort(o.toString());
        else
        if (type2.contains("boolean"))
        {
            if (o instanceof Boolean);
            else 
            {
                if (StringUtils.isEmpty(o)) o = false;
                else o = ("true".equalsIgnoreCase(o.toString()) || "Y".equalsIgnoreCase(o.toString()));
            }
        }
        else 
        if (type2.contains("date")) 
        {
            if (StringUtils.isEmpty(o)) o = null;
            else
            {
                String s = timefmt.format(o);
                if (storage.getDBType() == DBTYPE.ORACLE)
                {
                    o = "to_date('" + s + "', 'yyyy-MM-dd hh24:mi:ss')";
                }
                else
                {
                    o = "'" + s + "'";
                }
            }
        }
        else
        if (type2.contains("string"))
        {
            if (o == null)
                o = String.valueOf(o);
            else
                o = "'" + String.valueOf(o).replace("'", "’") + "'";
        }
        return o;
    }
    
   
    @SuppressWarnings("rawtypes")
    public <T> void batchInsert(FMybatisTemplate storage, Class<?> objClass, List<T> lists) throws Exception
    {
        batchInsert(storage, objClass, lists, 1000);
    }
    
    @SuppressWarnings("rawtypes")
    public <T> void batchInsert(FMybatisTemplate storage, Class<?> objClass, List<T> lists, int batch_rows) throws Exception
    {
        if (lists.size()<=0) return;
        SqlSessionTemplate db = storage.getSqlSessionTemplate();
        DBTYPE dbtype = storage.getDBType();
        if (!(dbtype == DBTYPE.ORACLE || dbtype == DBTYPE.MYSQL || dbtype == DBTYPE.SQLITE))
        {
            throw new Exception("unsupport DBMS Type!");
        }
        String tbl = AbstractEntityBean.fetchAnnotationTableName(objClass);
        StringBuffer sb = new StringBuffer();
        AbstractEntityBean.fetchAllDeclaredField(objClass, sb);
        List<String> flds = Arrays.asList(sb.toString().split(","));
        Set<BeanField> beanFields = new HashSet<BeanField>();
        
        for (String col: flds)
        {
            java.lang.reflect.Field fld = AbstractEntityBean.fetchDeclaredField(objClass,col);
            // Transient表示存储时忽略的列
            if (fld != null && fld.getAnnotation(Transient.class) == null)
            {
                BeanField bf = new BeanField();
                bf.setColName(col);
                bf.setField(fld);
                bf.setColType(fld.getType().getName().toLowerCase());
                beanFields.add(bf);
            }
        }
        int tot_page = (int) Math.ceil((float) lists.size() / batch_rows);
        
        StringBuffer tabsql = new StringBuffer();
        tabsql.append("insert into ").append(tbl).append("(");
        for (BeanField col: beanFields)
        {
            tabsql.append(col.getColName()).append(",");
        }
        tabsql.deleteCharAt(tabsql.length()-1);
        tabsql.append(")");
        
        for (int page = 0; page < tot_page; page++)
        {
            StringBuffer sql = new StringBuffer();
            sql.append(tabsql);
            boolean firstrow = true;
            for (int row = batch_rows * page; row < Math.min(lists.size(), batch_rows * (page+1)); row++)
            {
                Object bean = lists.get(row);

                if (dbtype == DBTYPE.ORACLE)
                {
                    if (!firstrow) sql.append(" union all ");
                    sql.append(" select ");
                    for (BeanField col: beanFields)
                    {
                        sql.append(getColData(storage, col.getField().get(bean), col.getColType()));
                        sql.append(",");
                    }
                    sql.deleteCharAt(sql.length()-1);
                    sql.append(" from dual" );
                }
                else if (dbtype == DBTYPE.MYSQL)
                {
                    if (firstrow) 
                        sql.append(" values ");
                    else
                        sql.append(",");
                    sql.append("(");
                    for (BeanField col: beanFields)
                    {
                        sql.append(getColData(storage, col.getField().get(bean), col.getColType()));
                        sql.append(",");
                    }
                    sql.deleteCharAt(sql.length()-1);
                    sql.append(")" );
                }
                else if (dbtype == DBTYPE.SQLITE)
                {
                    if (!firstrow) sql.append(" union all ");
                    sql.append(" select ");
                    for (BeanField col: beanFields)
                    {
                        sql.append(getColData(storage, col.getField().get(bean), col.getColType()));
                        sql.append(",");
                    }
                    sql.deleteCharAt(sql.length()-1);
                    sql.append(" " );
                }
                else
                {
                    ;
                }
                firstrow = false;
            }
            db.insert("mybatis.sql.insert", sql.toString());
        }
        return;
    }
}

    

