package com.efuture.ocp.common.component;

import java.util.HashMap;
import java.util.Map;

import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import com.efuture.omd.storage.FMybatisTemplate;

@Component
public class GlobRuleSrvimpl extends BasicComponent implements GlobRuleSrv {

	@Transactional(propagation = Propagation.REQUIRES_NEW)
	@Override
	public long getlast(long ent_id, String ruleid, String ruletypestr,
			String datestr, long keynum) {
		String globruledet = "globruledet";
		long startseqno = 0;
		long endseqno = 0;
		Criteria criteria = Criteria.where("ent_id").is(ent_id).and("ruleid")
				.is(ruleid).and("ruletypestr").is(ruletypestr);
		Query query = new Query(criteria);
		Update upt = new Update();
		upt.set("ruleid", ruleid);
		FMybatisTemplate storage = null;
		storage = getStorageOperations(FMybatisTemplate.class);
		if (storage.update(query, upt, globruledet) <= 0) {
			Map<String, Object> data = new HashMap<String, Object>();
			data.put("ent_id", ent_id);
			data.put("ruleid", ruleid);
			data.put("ruletypestr", ruletypestr);
			endseqno = keynum;
			data.put("rulecurseqno", String.valueOf(endseqno));
			data.put("ruletypeday", datestr);
			storage.insert(data, globruledet);
		} else {
			Map<String, Object> map = storage.selectOne(query, globruledet);
			if (!datestr.equals(map.get("ruletypeday"))) {
				endseqno = keynum;
			} else {
				startseqno = Long.parseLong(map.get("rulecurseqno").toString());
				endseqno = startseqno + keynum;
			}
			upt = new Update();
			upt.set("rulecurseqno", String.valueOf(endseqno));
			upt.set("ruletypeday", datestr);
			storage.update(query, upt, globruledet);
		}
		return startseqno;
	}

	@Override
	@Transactional(propagation = Propagation.REQUIRES_NEW)
	public long getnext(long ent_id, String ruleid, String ruletypestr,
			String datestr) {
		return getlast(ent_id, ruleid, ruletypestr, datestr, 1L) + 1;
	}

	@Override
	@Transactional(propagation = Propagation.REQUIRES_NEW)
	public String getrulekey(long ent_id, String ruleid, String moduleid,
			String type, String level) {
		// TODO 根据GLOBRULE生成规则单号
		return null;
	}

	@Override
	public Map<String, Object> getrule(long ent_id, String ruleid) {
		// TODO 查询GLOBRULE配置信息
		return null;
	}

}
