package com.efuture.ocp.common.dict;

import java.util.HashMap;
import java.util.List;
import java.util.Map;


import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;


import com.efuture.ocp.common.component.BasicComponent;
import com.efuture.ocp.common.util.EnvironmentParaUtils;
import com.efuture.omd.storage.FMybatisTemplate;

@Component("mdmdbservice")
public class MdmServiceDBImpl extends BasicComponent implements MdmService {

	@Value("${efuture.report.mdmdb:omcmdm}")
	String mdmdb = "omcmdm";

	@Value("${efuture.report.MdmStorageOperation:}")
	String MdmStorageOperation = "";

	@Value("${efuture.report.mdmkeys:}")
	String mdmkeys = "mf,cat,pp,sup";

	private HashMap<String, String> tableInfo = new HashMap<String, String>();

	private HashMap<String, String> tableDefConfig = new HashMap<String, String>();

	boolean ibinit = false;

	public MdmServiceDBImpl() {
		super();
		tableDefConfig.put("mf", "v_manaframe,jygs,code,name,parent_id,4");
		tableDefConfig.put("category", "v_category,jygs,code,name,parent_id,4");
		tableDefConfig.put("pp", "v_brand,jygs,code,name");
		tableDefConfig.put("sup", "v_vendor,jygs,code,name");
	}

	public void init() {
		if (!ibinit) {
			if (MdmStorageOperation != null && !MdmStorageOperation.isEmpty()) {
				this.setStorageOperation_other(MdmStorageOperation);
			}

			String[] mdmkeyArray = mdmkeys.split(",");
			for (int i = 0; i < mdmkeyArray.length; i++) {
				String mdmkey = mdmkeyArray[i];
				String configkey = "efuture.report.mdm." + mdmkey;

				tableInfo.put(mdmkey, EnvironmentParaUtils.getEnvPra(configkey, tableDefConfig.get(mdmkey)));
			}
			ibinit = true;
		}

	}

	public String getTableInfo(String dicttype) {
		return tableInfo.get(dicttype);
	}

	public String getFromDb(long ent_id, String dicttype, String jygs, String dictcode) {

		String tableinfo = getTableInfo(dicttype);

		if (tableinfo == null || tableinfo.equals("")) {
			return dictcode;
		}
		String[] t = tableinfo.split(",");
		if (t.length < 4) {
			return dictcode;
		}
		String tablename = t[0];
		String jygscol = t[1];
		String codecol = t[2];
		String namecol = t[3];
		Criteria criteria = Criteria.where("ent_id").is(ent_id);
		if (jygscol != null && !jygscol.equals("")) {
			criteria.and(jygscol).is(jygs);
		}
		criteria.and(codecol).is(dictcode);
		Query query = new Query(criteria);
		query.fields().include(namecol);
		FMybatisTemplate storage = (FMybatisTemplate) getStorageOperations();
		List<Map<String, Object>> dname = storage.select(query, tablename);
		if (dname != null && dname.size() >= 1) {
			return dname.get(0).get(namecol).toString();
		} else {
			return dictcode;
		}
	}

	@Override
	public Map<String, Object> getMdmRowData(long ent_id, String dicttype, String jygs, String dictcode) {
		init();
		String tableinfo = getTableInfo(dicttype);

		if (tableinfo == null || tableinfo.equals("")) {
			return null;
		}
		String[] t = tableinfo.split(",");
		String tablename = t[0];
		String jygscol = t[1];
		String codecol = t[2];
		String namecol = t[3];
		Criteria criteria = Criteria.where("ent_id").is(ent_id);
		if (jygscol != null && !jygscol.equals("")) {
			criteria.and(jygscol).is(jygs);
		}
		criteria.and(codecol).is(dictcode);
		Query query = new Query(criteria);
		// query.fields().include(namecol);
		FMybatisTemplate storage = (FMybatisTemplate) getStorageOperations();
		List<Map<String, Object>> dname = storage.select(query, tablename);

		if (dname != null && dname.size() >= 1) {
			return dname.get(0);
		} else {
			Map<String, Object> rtn = new HashMap<String, Object>();
			rtn.put(namecol, dictcode);
			return rtn;
		}
	}

	@Override
	public boolean hasType(String dicttype) {
		init();
		return tableInfo.containsKey(dicttype);
	}

	@Override
	public String getMdmName(Map<String, Object> dict, String dicttype) {
		init();
		String tableinfo = getTableInfo(dicttype);
		String[] t = tableinfo.split(",");
		String namecol = t[3];
		if (dict.get(namecol) != null) {
			return dict.get(namecol).toString();
		} else {
			return null;
		}

	}

	@Override
	public String getMdmNameCol(String dicttype) {
		init();
		String tableinfo = getTableInfo(dicttype);

		if (tableinfo == null || tableinfo.equals("")) {
			return null;
		}
		String[] t = tableinfo.split(",");
		String namecol = t[3];
		return namecol;
	}

	@Override
	public String getMdmPcodeCol(String dicttype) {
		init();
		String tableinfo = getTableInfo(dicttype);

		if (tableinfo == null || tableinfo.equals("")) {
			return null;
		}
		String[] t = tableinfo.split(",");
		String pcodecol = t[4];
		return pcodecol;
	}

	@Override
	public int getMaxLevel(String dicttype) {
		init();
		String tableinfo = getTableInfo(dicttype);
		if (tableinfo == null || tableinfo.isEmpty()) {
			return 1;
		}
		String[] t = tableinfo.split(",");
		if (t.length < 6) {
			return 1;
		}
		String max = t[5];
		if (NumberUtils.isNumber(max)) {
			return NumberUtils.toInt(max);
		}
		return 1;
	}
}
