package com.efuture.ocp.common.distributedLock;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.language.ResponseCode;
import com.efuture.ocp.common.rest.ServiceLogs;

@Aspect
@Component
public class DistributedLockAspect {

	@Autowired
	DistributedLockHandle lockHandle;

	@Autowired
	DistributedLockKeyHandle keyHandle;

	@Around("@annotation(around)")
	public Object round(ProceedingJoinPoint point, DLock around) throws Throwable {
		ServiceLogs.truedebuglog("DistributedLock", "开始执行", 0);
		String lockKey = "";
		try {
			lockKey = keyHandle.getKey(point, around);
		} catch (Exception e) {
			ServiceLogs.errLog("DistributedLock", e, "获取锁的key失败");
			throw new ServiceException(ResponseCode.EXCEPTION, "获取锁的key失败[{0}]", e.getMessage());
		}
		ServiceLogs.truedebuglog("DistributedLock", "获取到Key:" + lockKey, 0);
		int lockExpire = around.lockExpire();
		boolean locked = false;
		try {
			locked = lockHandle.tryLock(lockKey, lockExpire);
		} catch (Exception e) {
			ServiceLogs.errLog("DistributedLock", e, "获取锁失败[{0}]");
			throw new ServiceException(ResponseCode.EXCEPTION, "获取锁失败[{0}]", lockKey);
		}
		if (!locked) {
			throw new ServiceException(ResponseCode.EXCEPTION, "获取锁失败[{0}]", lockKey);
		}

		Object result = null;
		try {
			result = point.proceed();
		} catch (Throwable e) {
			lockHandle.unlock(lockKey);
			throw e;
		} finally {
			lockHandle.unlock(lockKey);
		}
		return result;

	}
}
