package com.efuture.ocp.common.distributedLock;

import org.springframework.stereotype.Component;

import com.efuture.ocp.common.util.CacheUtils;

@Component("dLockHandleByCacheUtils")
public class DistributedLockHandleByCacheUtils extends AbstractDistributedLockHandle {

	@Override
	public boolean doNaiveCachePut(String key, long id, int lockExpire) {
		return CacheUtils.getCacheUtils().addData(key, id, lockExpire);
	}

	@Override
	public void doNaiveCacheDelete(String key) {
		CacheUtils.getCacheUtils().deleteData(key);

	}

	@Override
	public long doNaiveCacheGet(String key) {
		Object val = CacheUtils.getCacheUtils().getData(key);
		if (val == null) {
			return 0;
		}
		return Long.valueOf(val.toString());
	}

}
