/**
 * Copyright (C), 2007-2014, eFuture 北京富基融通科技有限公司
 * FileName:	EntityBean.java
 * Author:		亮
 * Date:		2014-4-1 下午4:01:39
 * Description:	
 * History:
 * <author>		<time>			<version>		<description>
 * 
 */
package com.efuture.ocp.common.entity;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

import javax.validation.ConstraintViolation;

import org.springframework.data.annotation.Transient;
import org.springframework.util.StringUtils;

import com.efuture.ocp.common.exception.BeanValidateException;
import com.efuture.ocp.common.language.MessageSourceHelper;
import com.efuture.ocp.common.util.ValidatorUtils;

/**
 * @author		亮
 * @description	
 * 
 */
public abstract class AbstractEntityBean implements Serializable
{
    private static final long serialVersionUID = -61572915813771273L;
    
    protected long ent_id;                                     //企业ID,使用long在where条件时效率更高
   
    @Transient
    protected Date timestamp;                                  //时间戳
    
    
//	protected String status = BeanConstant.Status.NORMAL;      //状态
    @Transient
    protected String status;
    
    @Transient
	protected String lang;                                     //语言类型
    
    @Transient
    protected String note;                                     //备注
        
    @Transient
	protected long creator_id;                                 //创建者ID
    
    @Transient
	protected String creator;                                  //创建者名称
    
    @Transient
	protected long modifier_id;                                //修改者ID
    
    @Transient
	protected String modifier;                                 //修改者名称
	
	/**
     * @return ent_id
     */
    public long getEnt_id()
    {
        return ent_id;
    }

    /**
     * @param ent_id 要设置的 ent_id
     */
    public void setEnt_id(long ent_id)
    {
        this.ent_id = ent_id;
    }

    /**
     * @return note
     */
    public String getNote()
    {
        return note;
    }

    /**
     * @param note 要设置的 note
     */
    public void setNote(String note)
    {
        this.note = note;
    }

    /**
     * @return status
     */
    public String getStatus()
    {
        return status;
    }

    /**
     * @param status 要设置的 status
     */
    public void setStatus(String status)
    {
        this.status = status;
    }

    /**
     * @return lang
     */
    public String getLang()
    {
        return lang;
    }

    /**
     * @param lang 要设置的 lang
     */
    public void setLang(String lang)
    {
        this.lang = lang;
    }

    /**
     * @return creator_id
     */
    public long getCreator_id()
    {
        return creator_id;
    }

    /**
     * @param creator_id 要设置的 creator_id
     */
    public void setCreator_id(long creator_id)
    {
        this.creator_id = creator_id;
    }

    /**
     * @return creator
     */
    public String getCreator()
    {
        return creator;
    }

    /**
     * @param creator 要设置的 creator
     */
    public void setCreator(String creator)
    {
        this.creator = creator;
    }

    /**
     * @return modifier_id
     */
    public long getModifier_id()
    {
        return modifier_id;
    }

    /**
     * @param modifier_id 要设置的 modifier_id
     */
    public void setModifier_id(long modifier_id)
    {
        this.modifier_id = modifier_id;
    }

    /**
     * @return modifier
     */
    public String getModifier()
    {
        return modifier;
    }

    /**
     * @param modifier 要设置的 modifier
     */
    public void setModifier(String modifier)
    {
        this.modifier = modifier;
    }   
    
    /**
     * @return timestamp
     */
    public Date getTimestamp()
    {
        return timestamp;
    }

    /**
     * @param timestamp 要设置的 timestamp
     */
    public void setTimestamp(Date timestamp)
    {
        this.timestamp = timestamp;
    }
    
    ////////////////////////////  Bean 工具   /////////////////////////////

    // 新增操作时初始化通用成员方法
	public void initInsertMember(ServiceSession session)
	{
		this.setEnt_id(session.getEnt_id());
/*		
		this.setCreator_id(session.getUser_id());
		this.setCreator(session.getUser_name());
		this.setTimestamp(new Date());
        this.setStatus(BeanConstant.Status.NORMAL);
        this.setLang(session.getLocale());
*/        
	}

    public void initInsertMember(AbstractEntityBean bean)
    {
        this.setEnt_id(bean.getEnt_id());
/*        
        this.setCreator_id(bean.getCreator_id());
        this.setCreator(bean.getCreator());
        this.setTimestamp(new Date());
        this.setStatus(BeanConstant.Status.NORMAL);
        this.setLang(bean.getLang());
*/        
    }
	   
    // 更新操作时初始化通用成员方法
    public void initUpdateMember(ServiceSession session)
    {
        this.setEnt_id(session.getEnt_id());
/*        
        this.setModifier_id(session.getUser_id());
        this.setModifier(session.getUser_name());
        this.setTimestamp(new Date());
        this.setLang(session.getLocale());
*/        
    }
    
    public void initUpdateMember(AbstractEntityBean bean)
    {
        this.setEnt_id(bean.getEnt_id());
/*        
        this.setModifier_id(bean.getModifier_id());
        this.setModifier(bean.getModifier());
        this.setTimestamp(new Date());
        this.setLang(bean.getLang());
*/        
    }
    
    public String fetchAnnotationTableName()
    {
        return fetchAnnotationTableName(this.getClass());
    }
    
    public static String fetchAnnotationTableName(Class<?> cl)
    {
        Annotation[] annos = cl.getAnnotations();
        for (Annotation ann : annos)
        {
            if (ann instanceof org.springframework.data.mongodb.core.mapping.Document)
            {
                return ((org.springframework.data.mongodb.core.mapping.Document)ann).collection();
            }
        }
      
        String name = cl.getName();
        name = name.substring(name.lastIndexOf(".")+1).toLowerCase();
        return name.endsWith("bean")?name.substring(0,name.length()-4):name;
    }
      
    public java.lang.reflect.Field fetchDeclaredField(String fieldName)
    {
        return fetchDeclaredField(this.getClass(),fieldName);
    }
    
    public static java.lang.reflect.Field fetchDeclaredField(Class<?> classDefine,String fieldName) 
    {
        java.lang.reflect.Field field = null;
        
        try
        {
            field = classDefine.getDeclaredField(fieldName);
            field.setAccessible(true);
        }
        catch (NoSuchFieldException e)
        {
            if (classDefine.getSuperclass() != null) { return fetchDeclaredField(classDefine.getSuperclass(), fieldName); }
        }
        return field;
    }
    
    public StringBuffer fetchAllDeclaredField(StringBuffer sb)
    {
        return fetchAllDeclaredField(this.getClass(),sb);
    }
    
    public static StringBuffer fetchAllDeclaredField(Class<?> classDefine,StringBuffer sb) 
    {
        java.lang.reflect.Field[] flds = classDefine.getDeclaredFields();
        
        for (java.lang.reflect.Field fld : flds)
        {
            // 静态成员
            if (Modifier.isStatic(fld.getModifiers())) continue;
            String fldname = fld.getName();
            sb.append(fldname+",");
        }
        if (classDefine.getSuperclass() != null) fetchAllDeclaredField(classDefine.getSuperclass(),sb);
        
        if (sb.length() > 0 && sb.charAt(sb.length()-1) == ',') sb.deleteCharAt(sb.length()-1);
        return sb;
    }
    
    public static Map<String,String> fetchSelectField(Class<?> classDefine,Map<String,String> fldmap) 
    {
        java.lang.reflect.Field[] flds = classDefine.getDeclaredFields();
        
        for (java.lang.reflect.Field fld : flds)
        {
            // 静态成员
            if (Modifier.isStatic(fld.getModifiers())) continue;
            String fldname = fld.getName();
            String fldvalue = fldname;
            
            boolean istransient = false;
            Annotation[] annos = fld.getAnnotations();
            for (Annotation ann : annos)
            {
                if (ann instanceof org.springframework.data.annotation.Transient) istransient = true;
                
                // 指定字段
                if (ann instanceof org.springframework.data.mongodb.core.mapping.Field)
                {
                    fldvalue = ((org.springframework.data.mongodb.core.mapping.Field)ann).value();
                    if (!StringUtils.isEmpty(fldvalue))
                    {
                        fldvalue = fldvalue + " as " + fldname;
                        istransient = false;
                    }
                    else fldvalue = fldname;
                }
            }
            if (istransient) continue;
            
            fldmap.put(fldname,fldvalue);
        }
        if (classDefine.getSuperclass() != null) fetchSelectField(classDefine.getSuperclass(),fldmap);
        
        return fldmap;
    }
    
    public void validateBean(Class<?> groupClazz) throws BeanValidateException
    {
    	Set<ConstraintViolation<Object>> msgs = ValidatorUtils.validate(this,groupClazz);
    	if(msgs!=null && msgs.size() > 0)
    	{
    		ConstraintViolation<Object> cv = msgs.iterator().next();
    		throw new BeanValidateException(cv.getPropertyPath().toString(),formatValidateMessage(cv,null));
    	}
    }    
    
    public void validateBean(String... ignores) throws BeanValidateException
    {
        validateBean(this,ignores);
    }
    
    /**
     * 执行Bean效验
     * @param object    效验对象
     * @param ignores   跳过指定的效验
     * @throws BeanValidateException
     */
    public static void validateBean(Object object,String... ignores) throws BeanValidateException
    {
        Set<ConstraintViolation<Object>> msgs = ValidatorUtils.validate(object);
        if (msgs != null && msgs.size() > 0) 
        {
            Iterator<ConstraintViolation<Object>> it = msgs.iterator();
            while(it.hasNext())
            {
                ConstraintViolation<Object> cv = it.next();
                String key = cv.getPropertyPath().toString();
                
                boolean exist = false;
                for (int i=0;ignores != null && i<ignores.length;i++)
                {
                    if (key.equalsIgnoreCase(ignores[i]))
                    {
                        exist = true;
                        break;
                    }
                }
                if (!exist) 
                {
                    throw new BeanValidateException(key,formatValidateMessage(cv,object));
                }
            }
        }
    }
    
    private static String formatValidateMessage(ConstraintViolation<?> cv,Object object)
    {
        StringBuffer msg = new StringBuffer();

        String type = cv.getConstraintDescriptor().getAnnotation().annotationType().getSimpleName();
        
        // defaut msg
        msg.append(cv.getPropertyPath().toString());
        msg.append(" is [" + cv.getInvalidValue()+"],");
        msg.append(cv.getMessage());

        // 语言集
        String locale = null;
        if (object != null)
        {
            if (object instanceof AbstractEntityBean) locale = ((AbstractEntityBean)object).getLang();
            else locale = object.toString();
        }
        
        // locale msg
        return MessageSourceHelper.getDefault().getMessage(type,msg.toString(),locale!=null?new Locale(locale):null,
               cv.getPropertyPath().toString(),cv.getInvalidValue(),cv.getMessage());
    }
    
    public void validateBeanForSpecified(String... specflds) throws BeanValidateException
    {
        validateBeanForSpecified(this,specflds);
    }
    
    /**
     * 效验Bean的表达式
     * @param object
     * @param specflds
     * @throws BeanValidateException
     */
    public static void validateBeanForSpecified(Object object,String... specflds) throws BeanValidateException
    {
        Set<ConstraintViolation<Object>> msgs = ValidatorUtils.validate(object);
        if (msgs != null && msgs.size() > 0) 
        {
            Iterator<ConstraintViolation<Object>> it = msgs.iterator();
            while(it.hasNext())
            {
                ConstraintViolation<Object> cv = it.next();
                String key = cv.getPropertyPath().toString();
                
                boolean exist = false;
                for (int i=0;specflds != null && i<specflds.length;i++)
                {
                    if (key.equalsIgnoreCase(specflds[i]))
                    {
                        exist = true;
                        break;
                    }
                }
                if (exist) 
                {
                    throw new BeanValidateException(key,formatValidateMessage(cv,object));
                }
            }
        }
    }
}
