package com.efuture.ocp.common.fileio;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.StringUtils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.util.UniqueID;
import com.efuture.ocp.common.util.Utils;
import com.efuture.ocp.common.component.BasicComponentService;
import com.efuture.ocp.common.component.GlobRuleSrvimpl;
import com.efuture.ocp.common.entity.AbstractEntityBean;
import com.efuture.ocp.common.entity.FileImportObject;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.language.ResponseCode;
import com.efuture.ocp.common.util.ExcelUtils;
import com.efuture.ocp.common.util.PrecisionUtils;
import com.efuture.ocp.common.util.RestClientUtils;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.ocp.common.fileio.DataImportConfigBean;
import com.efuture.ocp.common.fileio.FileImportService;
import com.efuture.omd.storage.FMybatisTemplate;

public class FileImportSrvl extends BasicComponentService implements FileImportService {
	
	private static final String STATIC_XLS = "XLS";
	private static final String STATIC_XLSX = "XLSX";

	private static final String SimpleDateFormat = null;
	private SXSSFWorkbook xlsx = null;
	private HSSFWorkbook xls = null;

	private String createfilepath = null;
	public String getCreatefilepath() {
		return createfilepath;
	}
	public void setCreatefilepath(String createfilepath) {
		this.createfilepath = createfilepath;
	}


	
	interface separator {
		final String array = ",";
		final String field = "#";
	}
	
	interface errCode {
		final String TYPE = "format is wrong";	//数据格式不对
		final String ISNULL = "is null";		//为空
		final String ISREPEAT = "is repeat";	//有重复的
	}

	@Override
	public ServiceResponse getConfig(ServiceSession session, JSONObject jsonparam) throws Exception {
		DataImportConfigServiceImpl dataImportConfig = new DataImportConfigServiceImpl();
		return dataImportConfig.search(session, jsonparam);
	}

	@Override
	public JSONObject beforeFileImport(ServiceSession session,JSONObject jsonparam,List<FileImportObject> list) throws Exception
	{
		long starttime = System.currentTimeMillis();
        getLogger().info("import start: " + starttime);
        if(StringUtils.isEmpty(jsonparam.get("eid"))) 
        	if(!StringUtils.isEmpty(jsonparam.get("billmoduleid"))) jsonparam.put("eid", jsonparam.get("billmoduleid"));
        	else throw new ServiceException(ResponseCode.FAILURE,"{0} or {1} does not exist", "eid", "billmoduleid");
        	
        DataImportConfigServiceImpl dataImportConfig = new DataImportConfigServiceImpl();
        DataImportConfigBean exportConfig = dataImportConfig.getConfig(session.getEnt_id(),jsonparam.getString("eid"),null);
        if(exportConfig == null) throw new ServiceException(ResponseCode.FAILURE,"导入配置不存在"); 
        String impfields = exportConfig.getImpfields();
        String imptype = exportConfig.getEid();
        long maxrow = -1;

        //导入配置检查
        checkConfig(exportConfig);
        
        getLogger().info("import start: " + starttime + " imptype: "+imptype);
        //配置转json对象
        JSONObject jsonconfig = (JSONObject) Utils.toNormalJSONObject(exportConfig);
        JSONArray errList = new JSONArray();
        JSONArray successList = new JSONArray();
        JSONArray ary = null;
        JSONArray array = null;
        //得到文档内容
        for (FileImportObject fio : list)
        {
            // JSONArray ary = null;
            if (fio.getFilename().toLowerCase().endsWith(".xlsx")) ary = ExcelUtils.XLSXtoJSONArray(fio.getStream(), impfields, maxrow);
            else ary = ExcelUtils.XLStoJSONArray(fio.getStream(), impfields, maxrow);
            if (array != null) array.addAll(ary);
            else array = ary;
        }
        
        //初步处理从excel读到的数据（去空格）
        array = impToRegular(array);
        //文档格式检验,通过则保存
        checkStyle(array,jsonconfig,successList,errList);
        array = (JSONArray)successList.clone();
        successList.clear();
        
        JSONObject out = new JSONObject();
        if(array.size() > 0) 	out.put("imparray", array);
        if(errList.size() > 0) 	out.put("errList", errList);
        out.put("impconfig", jsonconfig);
        
		return out;
	}

	public void checkConfig(DataImportConfigBean config) throws Exception{
		String impfields = config.getImpfields();
		String impname =  config.getImpfields_name();
		String imptype = config.getImpfields_datatype();
		String defaultparam = config.getDefaultparam();
		String defaultvalue = config.getDefaultvalue();
		if(StringUtils.isEmpty(impfields) || StringUtils.isEmpty(impname) || StringUtils.isEmpty(imptype) ){
			throw new ServiceException(ResponseCode.FAILURE,"导入配置:impfields、impfields_name、impfields_datatype 不能为空");
		}
		if(impfields.split(separator.array).length != impname.split(separator.array).length ){
			throw new ServiceException(ResponseCode.FAILURE,"导入配置:impfields、impfields_name 不匹配");
		}
		if(impfields.split(separator.array).length != imptype.split(separator.array).length ){
			throw new ServiceException(ResponseCode.FAILURE,"导入配置:impfields、impfields_datatype 不匹配");
		}

		if(!StringUtils.isEmpty(defaultparam)){
			if(defaultparam.split(separator.array).length != defaultvalue.split(separator.array).length ){
				throw new ServiceException(ResponseCode.FAILURE,"导入配置:defaultparam、defaultvalue 不匹配");
			}
		}
	}
	
	/**
     * 功能：判断字符串是否为日期格式
     * 
     * @param str
     * @return
     */
	public boolean isDate(String strDate) {
        Pattern pattern = Pattern
                .compile("^((\\d{2}(([02468][048])|([13579][26]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))(\\s(((0?[0-9])|([1-2][0-3]))\\:([0-5]?[0-9])((\\s)|(\\:([0-5]?[0-9])))))?$");
        Matcher m = pattern.matcher(strDate);
        if (m.matches()) {
            return true;
        } else {
            return false;
        }
    }
	
	/**
     * 功能：判断字符串是否为整数
     * 
     * @param str
     * @return
     */
    private boolean isLong(String str) {
        //Pattern pattern = Pattern.compile("[0-9]*");
     // 就是判断是否为整数(正负)  
        Pattern pattern =   
        		Pattern.compile("[0-9]*"); 
        Matcher isNum = pattern.matcher(str);
        if (isNum.matches()) {
            return true;
        } else {
            return false;
        }
    }
	
    /**
     * 判断一个字符串是否是数字。
     * 
     * @param string
     * @return
     */
    public boolean isNumber(String string) {
        if (string == null)
            return false;
        Pattern pattern = Pattern.compile("^-?\\d+(\\.\\d+)?$");
        return pattern.matcher(string).matches();
    }
    
    public boolean isequal(Object value1,Object value2){
		return ((value1 == null) ? "" : value1.toString().trim()).equals((value2 == null) ? "" : value2.toString().trim());
	}
    
    public String geterr(JSONArray array){
    	String errmsg = "";
    	for (int i=0;i<array.size();i++){
    		JSONObject errrow = array.getJSONObject(i);
    		if(i == array.size() -1 ){
    			errmsg += "["+errrow.getString("column")+"] "+errrow.getString("msg");
    		}else{
    			errmsg += "["+errrow.getString("column")+"] "+errrow.getString("msg")+",";
    		}
    	}
    	return errmsg;
    }
	
	//校验数据格式、非空列、不可重复数据、
	public String checkRow(JSONObject row,JSONObject jsonparam,JSONArray array) throws Exception{
		JSONArray result = new JSONArray();
		
		String fields = jsonparam.getString("impfields");
		String fields_name = jsonparam.getString("impfields_name");
		String fields_type = jsonparam.getString("impfields_datatype");
		String fields_nonull = getParamWithCheck(jsonparam ,"uniquecolumn" , false,"" )  + separator.array + getParamWithCheck(jsonparam ,"nonullfields" , false,"" );
		String field_norepeat = getParamWithCheck(jsonparam ,"uniquecolumn" , false,"" ) + separator.array + getParamWithCheck(jsonparam ,"norepeatfields" , false,"" );
		String defaultparam = getParamWithCheck(jsonparam ,"defaultparam" , false,"" );
		String defaultvalue = getParamWithCheck(jsonparam ,"defaultvalue" , false,"" );
		
		String [] columns = fields.split(separator.array);
		String [] columns_name = fields_name.split(separator.array);
		String [] columns_type = fields_type.split(separator.array);
		String [] columns_nonull = fields_nonull.split(separator.array);
		String [] columns_norepeat = field_norepeat.split(separator.array);
		String [] arr_defaultparam = defaultparam.split(separator.array);
		String [] arr_defaultvalue = defaultvalue.split(separator.array);

		for (int i=0;i<columns.length;i++){
			String field = columns[i];
			String field_name = columns_name[i];
			JSONObject result_row = new JSONObject();
			result_row.put("column", field_name);

			//检验数据类型
			if(!field.equals("")){
				//检验非空列
				for(String column_nonull : columns_nonull){
					if(!column_nonull.equals("")){
						if (field.equals(column_nonull)){
							if(row.get(field) == null) {
								result_row.put("msg", errCode.ISNULL);
								result.add(result_row) ;
							}
							if(row.getString(field).trim().equals("")) {
								result_row.put("msg", errCode.ISNULL);
								result.add(result_row);
							}
						}
					}
				}

				//数据类型
				if (row.get(field) != null ) {
					for(String nonull_fie : columns_nonull){
						if(field.equals(nonull_fie)){
							if(columns_type[i].equals("D")){
								if(!isDate(row.getString(field).trim())){
									result_row.put("msg", errCode.TYPE);
									result.add(result_row);
								}
							}else if(columns_type[i].equals("N")){
								if(!isNumber(row.getString(field).trim())) {
									result_row.put("msg", errCode.TYPE);
									result.add(result_row);
								}
							}else if(columns_type[i].equals("L")){
								if(!isLong(row.getString(field).trim())) {
									result_row.put("msg", errCode.TYPE);
									result.add(result_row);
								}
							}
						}
					}
				}else{
					result_row.put("msg", errCode.TYPE);
					result.add(result_row);
				}
			}
		}
		
		//数据判重
		for(String column_repeat : columns_norepeat){
			if(column_repeat.equals("")) continue;
			JSONObject result_row = new JSONObject();
			
			String [] column_r = column_repeat.split(separator.field);
			
			//取重复列配置的名称
			String column_name = "";
			for(String column : column_r){
				for(int i=0;i<columns.length;i++){
					if (column.equals(columns[i])){
						if(column == column_r[column_r.length-1] ) column_name += columns_name[i];
						else column_name += columns_name[i]+",";
					}
				}
			}
			result_row.put("column", column_name);
			
			int isrepeat = 0;	//0-不重复/其他-重复
			for(int j=0;j<array.size();j++){
				int isrepeat_row = 0;	//单号是否重复,0-不重复/其他-重复
				JSONObject json_row = array.getJSONObject(j);
				for(String column : column_r){
					if(isequal(row.get(column),json_row.getString(column))){
						isrepeat_row++;
					}
				}
				
				if(isrepeat_row == column_r.length){
					isrepeat++;
				}
			}
			
			if(isrepeat > 1){
				result_row.put("msg",errCode.ISREPEAT);
				result.add(result_row);
			}
			
		}

		//增加默认参数
		for(int i=0;i<arr_defaultparam.length;i++){
			String paramrow = arr_defaultparam[i];
			if(!paramrow.equals("")) row.put(paramrow,arr_defaultvalue[i]);
		}
		
		String flag = "Y";
		if(result.size() > 0)  flag = geterr(result);
		
		return flag;
	}
	
	//导入文档格式检验
	public void checkStyle(JSONArray array,JSONObject jsonparam,JSONArray successList,JSONArray errList) throws Exception {
		for(int i=0;i<array.size();i++){
			JSONObject json_row = array.getJSONObject(i);
			String flag = checkRow(json_row,jsonparam,array);
			if(flag.equals("Y")) {
				successList.add(json_row);
			}else{
				json_row.put("errmsg", flag);
				errList.add(json_row);
			}
		}
		//return errList;
	}
	
	//格式化-去空格
	public Object colTotrim(Object colvalue){
		if(colvalue == null) return null;
		if(colvalue.toString().trim().equalsIgnoreCase("")) return "";
		Pattern pattern = Pattern.compile("^[-\\+]?[.\\d]*$"); 
		if (pattern.matcher(colvalue.toString()).matches())  return colvalue;
		return colvalue.toString().trim();
	}

	//格式化-数值时，尽量清除小数点(100.00 --> 100)
	public Object colTocleanpoint(Object colvalue){
		if(colvalue == null) return null;
		if(isNumber(colvalue.toString()) && colvalue.toString().indexOf(".") > 0) {
			if(Double.parseDouble(colvalue.toString()) ==  Double.parseDouble( colvalue.toString().substring(0,colvalue.toString().indexOf(".")) ) ){
				return colvalue.toString().substring(0,colvalue.toString().indexOf("."));
			}
		}
		return colvalue;
	}
	
	//处理读取到的excel数据
	public JSONArray impToRegular(JSONArray array){
		JSONArray newarray = new JSONArray();
		for (int i = 0; i < array.size(); i++){
			JSONObject item = new JSONObject(array.getJSONObject(i));
			Set<String> keys = item.keySet();
			Iterator iterator = keys.iterator();
			while(iterator.hasNext()){
				String keyname = iterator.next().toString();
				item.put(keyname, colTocleanpoint(colTotrim(item.get(keyname)) ));
			}
			newarray.add(item);
		}
		return newarray;
	}
	
	@Transactional(propagation = Propagation.REQUIRED)
	public void doResponseServiceImp(ServiceSession session,String eid,String method,JSONObject impdata,JSONArray successList,JSONArray errList) throws Exception{
		ServiceResponse resp;
		//resp = RestClientUtils.getRestUtils().sendRequest(session,method, impdata.toJSONString(),"DataImp_"+eid+"->");
		resp = RestClientUtils.getRestUtils().sendRequest(session,method, impdata.toJSONString());
		if (resp.getReturncode().equals("0")) {
			JSONObject jsonout = (JSONObject) resp.getData();
			errList.addAll(jsonout.getJSONArray("errList"));
			successList.addAll(jsonout.getJSONArray("successList"));
		}
	}
	
    public String downloadTemplate(ServiceSession session, JSONObject jsonparam) throws Exception{

        String modulecode = jsonparam.getString("billmoduleid");
        getLogger().info("下载导入模版，"+modulecode+",start....");
    	DataImportConfigServiceImpl dataImportConfig = new DataImportConfigServiceImpl();
    	List<DataImportConfigBean> importconfigbean =  dataImportConfig.getConfigByModule(session.getEnt_id(), modulecode);
    	if (importconfigbean.size() <= 0)  return "";
    	
    	String exceltype = null;
		if (StringUtils.isEmpty(jsonparam.get("filetype"))) {
			exceltype =STATIC_XLSX;
		} else {
			String excel = jsonparam.get("filetype").toString();
			if ("1".equals(excel)) {
				exceltype = STATIC_XLS;
			} else {
				exceltype =STATIC_XLSX;
			}
		}
		
		List<String> filelist = new ArrayList<String>();
		if (importconfigbean.size() > 1) {
			int i = 0;
			for(DataImportConfigBean row : importconfigbean ){
				i++;
				String[] fldlst = row.getImpfields().split(",");
				String[] disps = row.getImpfields_name().split(",");
				String tempfileName = "";
				tempfileName = row.getEname()+ tempfileName + i ;
				String file = createExcel( tempfileName,fldlst,disps, exceltype);
				filelist.add(file);
			}
		} else {
				String[] fldlst = importconfigbean.get(0).getImpfields().split(",");
				String[] disps = importconfigbean.get(0).getImpfields_name().split(",");
				String tempfileName = "";
				tempfileName = importconfigbean.get(0).getEname() + tempfileName;
				String file = createExcel( tempfileName, fldlst, disps ,exceltype);
				filelist.add(file);
		}
    
		String reFile = "";
		if (filelist.size() > 1) {
			reFile = makezip(filelist);
		} else {
			reFile = filelist.get(0);
		}
		return reFile;
    	
    }
    
    public String getFilePath() {
		String osname = System.getProperties().getProperty("os.name");
		String head = createfilepath;
		if (osname.startsWith("Windows")) {
			head = "D:\\file\\";
			File dir = new File(head);
			if (!dir.exists()) {
				if (!dir.mkdirs()) {
					head = "C:\\file\\";
				}
			}
		}else{
			File dir = new File(head);
			if (!dir.exists()) {
				dir.mkdirs();
			}
		}
		return head;
	}
    
    public String makezip(List<String> filelist) throws IOException {

		SimpleDateFormat sdfymdCard = new SimpleDateFormat("yyyyMMddHHmmss");
		String trackkey = sdfymdCard.format(new Date());

		String filename = trackkey;

		List<File> files = new ArrayList<File>();
		for (int i = 0; i < filelist.size(); i++) {
			File file = new File(filelist.get(i));
			files.add(file);
		}

		String head = getFilePath();
		String name = head + filename + ".rar";
		File file = new File(name);
		if (!file.exists()) {
			file.createNewFile();
		}
		FileOutputStream fous = new FileOutputStream(file);
		/**
		 * 打包的方法我们会用到ZipOutputStream这样一个输出流, 所以这里我们把输出流转换一下
		 */
		ZipOutputStream zipOut = new ZipOutputStream(fous);
		/**
		 * 这个方法接受的就是一个所要打包文件的集合， 还有一个ZipOutputStream
		 */
		zipFile(files, zipOut);
		zipOut.close();
		fous.close();

		// 删除文件
		for (File temp : files) {
			if (temp.isFile() && temp.exists()) {
				temp.delete();
			}
		}
		return name;

	}
    
    /**
	 * 把接受的全部文件打成压缩包
	 * 
	 * @param List
	 *            <File>;
	 * @param org
	 *            .apache.tools.zip.ZipOutputStream
	 */
	private void zipFile(List files, ZipOutputStream outputStream) {
		int size = files.size();
		for (int i = 0; i < size; i++) {
			File file = (File) files.get(i);
			zipFile(file, outputStream);
		}
	}
	
	/**
	 * 根据输入的文件与输出流对文件进行打包
	 * 
	 * @param File
	 * @param org
	 *            .apache.tools.zip.ZipOutputStream
	 */
	private void zipFile(File inputFile, ZipOutputStream ouputStream) {
		try {
			if (inputFile.exists()) {
				/**
				 * 如果是目录的话这里是不采取操作的， 至于目录的打包正在研究中
				 */
				if (inputFile.isFile()) {
					FileInputStream IN = new FileInputStream(inputFile);
					BufferedInputStream bins = new BufferedInputStream(IN, 512);
					// org.apache.tools.zip.ZipEntry
					ZipEntry entry = new ZipEntry(inputFile.getName());
					ouputStream.putNextEntry(entry);
					// 向压缩文件中输出数据
					int nNumber;
					byte[] buffer = new byte[512];
					while ((nNumber = bins.read(buffer)) != -1) {
						ouputStream.write(buffer, 0, nNumber);
					}
					// 关闭创建的流对象
					bins.close();
					IN.close();
				} else {
					try {
						File[] files = inputFile.listFiles();
						for (int i = 0; i < files.length; i++) {
							zipFile(files[i], ouputStream);
						}
					} catch (Exception e) {
						e.printStackTrace();
					}
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
    
    private void exportDataToExcel (String[] fldlst,String[] disps,String exceltype) {
		Sheet sheet = null;
		CellStyle columnHeadStyle = null;
		CellStyle cellStyle = null;
		Font f = null;
		if (fldlst == null) {
			fldlst = "".split(",");
		} 
		if (disps == null) {
			disps = "".split(",");
		}

		DataFormat format = null;
		if (STATIC_XLSX.equals(exceltype)) {
			columnHeadStyle = xlsx.createCellStyle();
			format = xlsx.createDataFormat();
			f =xlsx.createFont();// 字体
			sheet = xlsx.createSheet("sheet");
			cellStyle = xlsx.createCellStyle();
		} else {
			columnHeadStyle = xls.createCellStyle();
			format = xls.createDataFormat();
			f =xls.createFont();// 字体
			sheet = xls.createSheet("sheet");
			cellStyle = xls.createCellStyle();
		}
		columnHeadStyle.setBorderBottom(HSSFCellStyle.BORDER_THIN);// 下边框
		columnHeadStyle.setBorderLeft(HSSFCellStyle.BORDER_THIN);// 左边框
		columnHeadStyle.setBorderRight(HSSFCellStyle.BORDER_THIN);// 右边框
		columnHeadStyle.setBorderTop(HSSFCellStyle.BORDER_THIN);// 上边框
		columnHeadStyle.setAlignment(HSSFCellStyle.ALIGN_CENTER);
		columnHeadStyle.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);
		columnHeadStyle.setWrapText(true);
		f.setFontHeightInPoints((short) 9);// 字号
		f.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);// BOLDWEIGHT_BOLD);// 加粗
		columnHeadStyle.setFont(f);

		//设置文本格式
		columnHeadStyle.setDataFormat(format.getFormat("@"));
		
		
		Row row;
		Cell cell;
		row = sheet.createRow(0);
		sheet.createFreezePane(0, 1, 0, 1);
		int i = 0;
		for (String s : fldlst) {
			cell = row.createCell(i);
			cell.setCellStyle(columnHeadStyle);
			cell.setCellValue(disps[i]);
			sheet.setColumnWidth(i, (int) 7000);
			sheet.setDefaultColumnStyle(i,columnHeadStyle);
			i++;
		}
		
	}
    
    protected String createExcel(String fileName, String[] fldlst,
    		String[] disps,String exceltype) throws Exception {
		String filePath = getFilePath();
		File dir = new File(filePath);
		if (!dir.exists()) {  
			dir.mkdirs();
        }
		String tempExcelFile = "";
		SimpleDateFormat sdfymdCard = new SimpleDateFormat("yyyyMMddHHmmss");
		fileName = fileName + sdfymdCard.format(new Date());
		if (STATIC_XLSX.equals(exceltype)) {
			tempExcelFile = filePath + fileName + ".xlsx";
		} else  {
			tempExcelFile = filePath + fileName + ".xls";
		}
		
		int rowMemory = 100;
		FileOutputStream fos = new FileOutputStream(tempExcelFile);
		if (STATIC_XLSX.equals(exceltype)) {
			try {
				xlsx = new SXSSFWorkbook(rowMemory);
				exportDataToExcel(fldlst, disps,STATIC_XLSX);
				xlsx.write(fos);
				fos.flush();
				fos.close();
			} finally {
				fos.flush();
				fos.close();
			}
		} else {
			try {
				xls = new HSSFWorkbook();
			    exportDataToExcel(fldlst, disps, STATIC_XLS);
				xls.write(fos);
				fos.flush();
				fos.close();
			} finally {
				fos.flush();
				fos.close();
			}
		}
		
		// 返回
		return tempExcelFile;
	}
}
