/**
 * Copyright (C), 2007-2016, eFuture 北京富基融通科技有限公司 FileName: ExecutorWrapper.java
 * Author: F Date: 2016年2月2日 下午2:19:08 Description: History: <author> <time>
 * <version> <description>
 * 
 */
package com.efuture.ocp.common.filter;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.MappedStatement.Builder;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.log4j.Logger;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.ast.statement.SQLUnionQueryTableSource;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlOutputVisitor;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectQueryBlock;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleOutputVisitor;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitorAdapter;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.user.UserDataRangeSrv;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.ocp.user.DataRange;
import com.efuture.ocp.user.UserTokenInfo;
import com.efuture.omd.storage.FMybatisTemplate;
import com.efuture.omd.storage.FStorageOperations;

/**
 * @author F
 * @description
 * 
 */
@Intercepts({ @Signature(type = Executor.class, method = "query", args = { MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class }) })
public class ExecutorOraclePolicyWrapper implements Interceptor {

	private static Logger sqlLog = Logger.getLogger("sqlLog");
	private String dbType;

	@Override
	public Object intercept(Invocation invocation) throws Throwable {
		// sqlLog.info("invoke intercept");
		/**
		 * 如果当前上下文设置不执行数据范围,则直接返回执行
		 */
	
		FMybatisTemplate storage = null;
		MappedStatement mappedStatement = (MappedStatement) invocation.getArgs()[0];
		String sql = "";
		try {
			 
		 	if(UserDataRangeSrv.getRangeisexec()){
				return invocation.proceed();
			}
		 	
		 	storage=(FMybatisTemplate) SpringBeanFactory.getBean("StorageOperation", FStorageOperations.class);
		    SqlSessionTemplate sqlsession = storage.getSqlSessionTemplate();
			if (!UserDataRangeSrv.getlocalisrange()) {
				setOpercontext(sqlsession,"1","1");
				if (storage != null)
					storage.destroy();
				return invocation.proceed();
			}
			
						
			UserTokenInfo tokeninfo = UserDataRangeSrv.getlocaluser();
			String userid = tokeninfo.getUserid();
			String postid = tokeninfo.getPostid();

			if(postid.equals("1")){
				setOpercontext(sqlsession,"1","1");
				if (storage != null)
					storage.destroy();
				return invocation.proceed();
			}
			Object parameter = null;
			if (invocation.getArgs().length > 1) {
				parameter = invocation.getArgs()[1];
			}

			BoundSql boundSql = mappedStatement.getBoundSql(parameter);
			sql = boundSql.getSql();
			System.out.println("解析sql："+sql);
		
			
		    UserDataRangeSrv.setRangeisexec(true);
		    setOpercontext(sqlsession,postid,userid);
		} catch (Exception e) {
			// TODO: handle exception
			invocation.getArgs()[0] = mappedStatement;
			JSONObject errorJson = new JSONObject();
			errorJson.put("unresolved sql", sql);
			sqlLog.error(errorJson.toJSONString());
			e.printStackTrace();
		}finally {
			if (storage != null)
				storage.destroy();
		}
		
		return invocation.proceed();
	}
    public void setOpercontext(SqlSessionTemplate sqlsession,String postid,String userid){
    	Map<String, Object> map = new HashMap<String, Object>();
        map.put("accnt", userid);
        map.put("post", postid);
        sqlsession.update("Setopercontext", map);
    }
	@Override
	public Object plugin(Object target) {
		return Plugin.wrap(target, this);
	}

	@Override
	public void setProperties(Properties properties) {
		this.dbType = properties.getProperty("dbType");
		if (this.dbType == null || this.dbType.equals("")) {
			this.dbType = "mysql";
		}
	}

}
