package com.efuture.ocp.common.filter;

import java.util.List;

import org.apache.ibatis.builder.StaticSqlSource;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.Configuration;

public class FtSqlSource extends StaticSqlSource implements SqlSource
{
    private String sql;
    private List<ParameterMapping> parameterMappings;
    private Configuration configuration;
    private BoundSql boundSql;
    
    public FtSqlSource(Configuration configuration, String sql, BoundSql boundSql )
    {
        super(configuration, sql, boundSql.getParameterMappings());
        this.sql = sql;
        this.parameterMappings = boundSql.getParameterMappings();;
        this.configuration = configuration;
        this.boundSql = boundSql;
    }

    
    
    @Override
    public BoundSql getBoundSql(Object parameterObject)
    {
        FtBoundSql bs = new FtBoundSql(this.configuration, this.sql, this.parameterMappings, parameterObject); 
        bs.setoldboundsql(this.boundSql);
        return bs;
    }

}
