package com.efuture.ocp.common.syspara;

/**
 * 系统公共参数
 * 
 * @author zhouwd
 *
 */
public enum PublicSystemPara implements SystemPara {
	/**
	 * 日志是否记录SQL语句
	 */
	LOG_LOGSQL("log.logsql", "日志是否记录SQL语句","N"), 
	/**
	 * 缓存服务器列表
	 */
	CACHE_SERVERLIST("cache.serverList", "缓存服务器列表","127.0.0.1:11211");

	String key;
	String desc;
	String defaultVal = "";

	private PublicSystemPara(String key, String desc, String defaultVal) {
		this.key = key;
		this.desc = desc;
		this.defaultVal = defaultVal;
	}

	private PublicSystemPara(String key, String desc) {
		this.key = key;
		this.desc = desc;
	}

	@Override
	public String getKey() {
		return this.key;
	}

	@Override
	public String getDesc() {
		return this.desc;
	}

	@Override
	public String getPreParaStr() {
		return "efuture";
	}

	@Override
	public String getDefaultVal() {
		return defaultVal;
	}

}
