package com.efuture.ocp.common.syspara;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import com.efuture.ocp.common.util.EnvironmentParaUtils;

public interface SystemPara {

	public String getKey();

	public String getDesc();

	public String getPreParaStr();

	public String getDefaultVal();

//	static ConcurrentHashMap<String, Map<String, String>> paraKey = new ConcurrentHashMap<String, Map<String, String>>();
//
//	default public void regPara(String key, String desc, String defaultVal) {
//		Map<String, String> para = new HashMap<String, String>();
//		para.put("desc", desc);
//		para.put("defaultVal", defaultVal);
//		paraKey.put(key, para);
//	}

	default public String getVal(long entId) {
		String key = this.getPreParaStr() + "." + this.getKey();
		return EnvironmentParaUtils.getEnvPra(entId, key.toLowerCase(), this.getDefaultVal());
	}

	default public String getVal(long entId, String postfix, String defaultVal) {
		String key = this.getPreParaStr() + "." + this.getKey() + "." + postfix;
		return EnvironmentParaUtils.getEnvPra(entId, key.toLowerCase(), defaultVal);
	}

	default public String getVal(long entId, String postfix) {
		String key = this.getPreParaStr() + "." + this.getKey() + "." + postfix;
		return EnvironmentParaUtils.getEnvPra(entId, key.toLowerCase(), this.getDefaultVal());
	}
}
