package com.efuture.ocp.common.user;

import java.util.List;

import org.springframework.util.StringUtils;

import com.efuture.ocp.common.util.CacheUtils;
import com.efuture.ocp.common.util.EnvironmentParaUtils;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.ocp.user.DataRange;
import com.efuture.ocp.user.UserService;
import com.efuture.ocp.user.UserTokenInfo;

/**
 * 数据范围上下文服务 根据token设置当前进程的用户和数据范围，供SQL处理时调用
 * 
 * @author zhouwudong
 *
 */
public class UserDataRangeSrv {
	// 上下文 用户信息
	private static final ThreadLocal<UserTokenInfo> LOCAL_USERINFO = new ThreadLocal<UserTokenInfo>();
	// 上下文 数据范围
	private static final ThreadLocal<List<DataRange>> LOCAL_DataRange = new ThreadLocal<List<DataRange>>();
	// 上下文 token
	private static final ThreadLocal<String> LOCAL_TOKEN = new ThreadLocal<String>();
	// 上下文 是否启用数据范围
	private static final ThreadLocal<Boolean> LOCAL_ISRANGE = new ThreadLocal<Boolean>();

	// 上下文是否已执行过数据范围
	private static final ThreadLocal<Boolean> RangeIsExec = new ThreadLocal<Boolean>();

	// 整个是否启用数据范围上下文服务
	private static boolean OPENRANGE = true;
	// 用户服务
	private static UserService us;
	// 缓存前缀
	private static final String TOKEN_MEMKEY = "ocptoken-";

	/**
	 * 设置当前进程的TOKEN,并初始化 在rest入口调用
	 * 
	 * @param token
	 */
	public static void setlocaltoken(String token) {
		LOCAL_TOKEN.set(token);
		LOCAL_DataRange.remove();
		LOCAL_USERINFO.remove();
		RangeIsExec.set(false);
		if (StringUtils.isEmpty(token)) {
			LOCAL_ISRANGE.set(false);
		} else {
			LOCAL_ISRANGE.set(true);
		}

	}

	public static boolean getlocalisrange() {
		if (!OPENRANGE)
			return OPENRANGE;
		Boolean b = LOCAL_ISRANGE.get();
		if (null == b)
			return false;
		return b;
	}

	public static boolean getRangeisexec() {
		Boolean b = RangeIsExec.get();
		if (null == b)
			return false;
		return b;
	}

	public static void setRangeisexec(boolean exec) {
		RangeIsExec.set(exec);
	}

	public static void setlocalisrange(boolean isrange) {
		LOCAL_ISRANGE.set(isrange);
	}

	public static String getlocaltoken() {
		return LOCAL_TOKEN.get();
	}

	public static UserTokenInfo getlocaluser() {
		if (!OPENRANGE)
			return null;
		return getuserinfo();
	}

	public static UserTokenInfo getuserinfo() {
		UserTokenInfo info = LOCAL_USERINFO.get();
		if (null == info) {
			String token = getlocaltoken();
			if (token.isEmpty()) {
				return null;
			}
			info = getuserinfo(token);
			LOCAL_USERINFO.set(info);
		}
		return LOCAL_USERINFO.get();
	}

	public static List<DataRange> getlocaldatarange() {
		if (!OPENRANGE)
			return null;
		List<DataRange> dr = LOCAL_DataRange.get();
		if (null == dr || dr.size() < 1) {
			UserTokenInfo info = getlocaluser();
			if (null == info) {
				return null;
			}
			dr = getDataRangeBytoken(info.getToken());
			LOCAL_DataRange.set(dr);
		}
		return dr;
	}

	public static UserTokenInfo getuserinfo(String token) {
		if (!OPENRANGE)
			return null;
		if (StringUtils.isEmpty(token))
			return null;
		String key = TOKEN_MEMKEY + token;
		UserTokenInfo info = (UserTokenInfo) CacheUtils.getCacheUtils().getData(key);
		if (null == info) {
			UserService us = getServerSrv();
			info = us.getuserinfo(token);
			if (null == info)
				return null;
			CacheUtils.getCacheUtils().putData(key, info, CacheUtils.CacheTimeOut.Day);
		}
		return info;
	}

	private static UserService getServerSrv() {
		if (null == us) {
			String protalKey = EnvironmentParaUtils.getEnvPra("com.efuture.portalkey", "");
			// String userService = userService_cloud
			String userService = EnvironmentParaUtils.getEnvPra("userService_" + protalKey, "UserServerSrv");
			if (SpringBeanFactory.containsBean(userService)) {
				us = SpringBeanFactory.getBean(userService, UserService.class);
			} else {
				us = SpringBeanFactory.getBean("UserServerSrv", UserService.class);
			}

		}
		return us;
	}

	public static List<DataRange> getDataRangeBytoken(String token) {
		if (!OPENRANGE)
			return null;
		UserTokenInfo info = getuserinfo(token);
		if (null == info)
			return null;
		return info.getDatarange();

	}

	public static boolean isOpenrange() {
		return OPENRANGE;
	}

	public static void setOpenrange(boolean openrange) {
		OPENRANGE = openrange;
	}

}
