package com.efuture.ocp.common.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.annotation.Transient;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import com.efuture.ocp.common.entity.AbstractEntityBean;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.omd.storage.FMybatisTemplate;
import com.efuture.omd.storage.parser.QueryExtractor.DBTYPE;

@Component("batchinsservice")
public class BatchInsService {

	@Value("${efuture.batchinsert.batch_rows:1000}")
	private int BATCH_ROWS = 1000;

	public Object getColData(String dbtype, Object o, String type2) throws ParseException {
		SimpleDateFormat timefmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		if (type2.contains("long"))
			o = StringUtils.isEmpty(o) ? 0 : Long.parseLong(o.toString());
		else if (type2.contains("int"))
			o = StringUtils.isEmpty(o) ? 0 : Integer.parseInt(o.toString());
		else if (type2.contains("float"))
			o = StringUtils.isEmpty(o) ? 0 : Float.parseFloat(o.toString());
		else if (type2.contains("double"))
			o = StringUtils.isEmpty(o) ? 0 : Double.parseDouble(o.toString());
		else if (type2.contains("short"))
			o = StringUtils.isEmpty(o) ? 0 : Short.parseShort(o.toString());
		else if (type2.contains("boolean")) {
			if (o instanceof Boolean)
				;
			else {
				if (StringUtils.isEmpty(o))
					o = false;
				else
					o = ("true".equalsIgnoreCase(o.toString()) || "Y".equalsIgnoreCase(o.toString()));
			}
		} else if (type2.contains("date")) {
			if (StringUtils.isEmpty(o))
				o = null;
			else {
				// 2014-04-04T16:00:00.000Z 格式做标准转换
				// String s = o.toString();
				String s = timefmt.format(o);
				if (dbtype.equals(DBTYPE.ORACLE.toString())) {
					o = "to_date('" + s + "', 'yyyy-MM-dd hh24:mi:ss')";
				} else {
					o = "'" + s + "'";
				}
			}
		} else if (type2.contains("string")) {
			if (o == null)
				o = String.valueOf(o);
			else
				o = "'" + String.valueOf(o).replace("'", "").replace("\"", "") + "'";
		}
		return o;
	}

	@SuppressWarnings({ "rawtypes", "unused" })
	public void batchInsertWithChild(FMybatisTemplate storage, Class objClass, List<Object> lists, int batch_rows)
			throws Exception {
		if (lists.size() <= 0)
			return;
		DBTYPE dbtype = storage.getDBType();
		if (!(dbtype == DBTYPE.ORACLE || dbtype == DBTYPE.MYSQL)) {
			throw new Exception("unsupport DBMS Type!");
		}
		String tbl = AbstractEntityBean.fetchAnnotationTableName(objClass);
		StringBuffer sb = new StringBuffer();
		AbstractEntityBean.fetchAllDeclaredField(objClass, sb);
		List<String> flds = Arrays.asList(sb.toString().split(","));

		Object rows = lists.get(0);

		for (String col : flds) {
			java.lang.reflect.Field fld = AbstractEntityBean.fetchDeclaredField(objClass, col);
			// Transient 中查找子表
			if (fld != null && fld.getAnnotation(Transient.class) != null) {
				Class cls = fld.getType();

				if (cls.getName().equals(List.class.getName())) {
					System.out.println(cls.getName());
					System.out.println(cls.getTypeParameters());

				}
				Object value = fld.get(rows);

				System.out.println(fld.getName());

				System.out.println(cls.getClass().getName());
			}
		}

	}

	public <T> void batchInsert(FMybatisTemplate storage, Class<?> objClass, List<T> lists) throws Exception {
		batchInsert(storage, objClass, lists, BATCH_ROWS);
	}

	public void batchInsert(FMybatisTemplate storage, List<Map<String, Object>> lists, String tableName, int batch_rows)
			throws Exception {
		if (lists.size() <= 0) {
			return;
		}

		Set<BeanField> beanFields = new HashSet<BeanField>();
		Map<String, Object> firstRow = lists.get(0);
		Set<String> flds = firstRow.keySet();
		for (String col : flds) {
			BeanField bf = new BeanField();
			bf.setColName(col);
			if (firstRow.get(col) != null) {
				bf.setColType(firstRow.get(col).getClass().toString().toLowerCase());
			} else {
				bf.setColType("string");
			}

			beanFields.add(bf);
		}
		batchInsert(storage, beanFields, lists, tableName, batch_rows);
	}

	private String getlineSeparator() {
		return System.getProperty("line.separator");
	}

	public <T> String getBatchInsSql(List<Map<String, Object>> lists, String tableName, String dbtype, int batch_rows)
			throws Exception {
		if (lists.size() <= 0) {
			return null;
		}

		Set<BeanField> beanFields = new HashSet<BeanField>();
		Map<String, Object> firstRow = lists.get(0);
		Set<String> flds = firstRow.keySet();
		for (String col : flds) {
			BeanField bf = new BeanField();
			bf.setColName(col);
			if (firstRow.get(col) != null) {
				bf.setColType(firstRow.get(col).getClass().toString().toLowerCase());
			} else {
				bf.setColType("string");
			}

			beanFields.add(bf);
		}
		System.out.println(DBTYPE.ORACLE.toString());
		System.out.println(DBTYPE.MYSQL.toString());
		// DBTYPE dbtype = storage.getDBType();
		if (!(dbtype.equalsIgnoreCase(DBTYPE.ORACLE.toString()) || dbtype.equalsIgnoreCase(DBTYPE.MYSQL.toString()))) {
			throw new ServiceException("5000", "unsupport DBMS Type!");
		}

		int tot_page = (int) Math.ceil((float) lists.size() / batch_rows);

		StringBuffer tabsql = new StringBuffer();
		tabsql.append("insert into ").append(tableName).append("(");
		for (BeanField col : beanFields) {
			tabsql.append(col.getColName()).append(",");
		}
		tabsql.deleteCharAt(tabsql.length() - 1);
		tabsql.append(")");
		String tablesql = tabsql.toString();
		StringBuilder sql = new StringBuilder();
		for (int page = 0; page < tot_page; page++) {
			sql.append(getInsSql(tablesql, beanFields, lists, dbtype, tableName, batch_rows, page));
			sql.append(getlineSeparator());
		}
		return sql.toString();

	}

	public <T> String getInsSql(String tabsql, Set<BeanField> beanFields, List<T> lists, String dbtype,
			String tableName, int batch_rows, int page)
			throws IllegalAccessException, ParseException, RuntimeException {
		StringBuffer sql = new StringBuffer();
		sql.append(tabsql);
		boolean firstrow = true;
		for (int row = batch_rows * page; row < Math.min(lists.size(), batch_rows * (page + 1)); row++) {
			Object bean = lists.get(row);

			if (dbtype.equalsIgnoreCase(DBTYPE.ORACLE.toString())
					|| dbtype.equalsIgnoreCase(DBTYPE.SQLITE.toString())) {
				if (!firstrow)
					sql.append(" union all ");
				sql.append(" select ");
				for (BeanField col : beanFields) {
					sql.append(getColData(dbtype, col.getColValue(bean), col.getColType()));
					sql.append(",");
				}
				sql.deleteCharAt(sql.length() - 1);
				sql.append(" from dual");
			} else if (dbtype.equalsIgnoreCase(DBTYPE.MYSQL.toString())) {
				if (firstrow)
					sql.append(" values ");
				else
					sql.append(",");
				sql.append("(");
				for (BeanField col : beanFields) {
					sql.append(getColData(dbtype, col.getColValue(bean), col.getColType()));
					sql.append(",");
				}
				sql.deleteCharAt(sql.length() - 1);
				sql.append(")");
			} else {
				;
			}
			firstrow = false;
		}
		return sql.toString();
	}

	public <T> void batchInsert(FMybatisTemplate storage, Set<BeanField> beanFields, List<T> lists, String tableName,
			int batch_rows) throws IllegalAccessException, ParseException, RuntimeException {
		SqlSessionTemplate db = storage.getSqlSessionTemplate();
		DBTYPE dbtype = storage.getDBType();
		if (!(dbtype == DBTYPE.ORACLE || dbtype == DBTYPE.MYSQL)) {
			throw new ServiceException("5000", "unsupport DBMS Type!");
		}

		int tot_page = (int) Math.ceil((float) lists.size() / batch_rows);

		StringBuffer tabsql = new StringBuffer();
		tabsql.append("insert into ").append(tableName).append("(");
		for (BeanField col : beanFields) {
			tabsql.append(col.getColName()).append(",");
		}
		tabsql.deleteCharAt(tabsql.length() - 1);
		tabsql.append(")");

		for (int page = 0; page < tot_page; page++) {
			StringBuffer sql = new StringBuffer();
			sql.append(tabsql);
			boolean firstrow = true;
			for (int row = batch_rows * page; row < Math.min(lists.size(), batch_rows * (page + 1)); row++) {
				Object bean = lists.get(row);

				if (dbtype == DBTYPE.ORACLE || dbtype == DBTYPE.SQLITE) {
					if (!firstrow)
						sql.append(" union all ");
					sql.append(" select ");
					for (BeanField col : beanFields) {
						sql.append(getColData(storage.getDBType().toString(), col.getColValue(bean), col.getColType()));
						sql.append(",");
					}
					sql.deleteCharAt(sql.length() - 1);
					sql.append(" from dual");
				} else if (dbtype == DBTYPE.MYSQL) {
					if (firstrow)
						sql.append(" values ");
					else
						sql.append(",");
					sql.append("(");
					for (BeanField col : beanFields) {
						sql.append(getColData(storage.getDBType().toString(), col.getColValue(bean), col.getColType()));
						sql.append(",");
					}
					sql.deleteCharAt(sql.length() - 1);
					sql.append(")");
				} else {
					;
				}
				firstrow = false;
			}
			db.insert("mybatis.sql.insert", sql.toString());
		}
	}

	public <T> void batchInsert(FMybatisTemplate storage, Class<?> objClass, List<T> lists, int batch_rows)
			throws Exception {
		SqlSessionTemplate db = storage.getSqlSessionTemplate();
		if (lists.size() <= 0)
			return;
		DBTYPE dbtype = storage.getDBType();
		if (!(dbtype == DBTYPE.ORACLE || dbtype == DBTYPE.MYSQL)) {
			throw new Exception("unsupport DBMS Type!");
		}
		String tbl = AbstractEntityBean.fetchAnnotationTableName(objClass);
		StringBuffer sb = new StringBuffer();
		AbstractEntityBean.fetchAllDeclaredField(objClass, sb);
		List<String> flds = Arrays.asList(sb.toString().split(","));
		Set<BeanField> beanFields = new HashSet<BeanField>();

		for (String col : flds) {
			java.lang.reflect.Field fld = AbstractEntityBean.fetchDeclaredField(objClass, col);
			// Transient表示存储时忽略的列
			if (fld != null && fld.getAnnotation(Transient.class) == null) {
				BeanField bf = new BeanField();
				bf.setColName(col);
				bf.setField(fld);
				bf.setColType(fld.getType().getName().toLowerCase());
				beanFields.add(bf);
			}
		}
		int tot_page = (int) Math.ceil((float) lists.size() / batch_rows);

		StringBuffer tabsql = new StringBuffer();
		tabsql.append("insert into ").append(tbl).append("(");
		for (BeanField col : beanFields) {
			tabsql.append(col.getColName()).append(",");
		}
		tabsql.deleteCharAt(tabsql.length() - 1);
		tabsql.append(")");

		for (int page = 0; page < tot_page; page++) {
			StringBuffer sql = new StringBuffer();
			sql.append(tabsql);
			boolean firstrow = true;
			for (int row = batch_rows * page; row < Math.min(lists.size(), batch_rows * (page + 1)); row++) {
				Object bean = lists.get(row);

				if (dbtype == DBTYPE.ORACLE || dbtype == DBTYPE.SQLITE) {
					if (!firstrow)
						sql.append(" union all ");
					sql.append(" select ");
					for (BeanField col : beanFields) {
						sql.append(
								getColData(storage.getDBType().toString(), col.getField().get(bean), col.getColType()));
						sql.append(",");
					}
					sql.deleteCharAt(sql.length() - 1);
					sql.append(" from dual");
				} else if (dbtype == DBTYPE.MYSQL) {
					if (firstrow)
						sql.append(" values ");
					else
						sql.append(",");
					sql.append("(");
					for (BeanField col : beanFields) {
						sql.append(
								getColData(storage.getDBType().toString(), col.getField().get(bean), col.getColType()));
						sql.append(",");
					}
					sql.deleteCharAt(sql.length() - 1);
					sql.append(")");
				} else {
					;
				}
				firstrow = false;
			}
			db.insert("mybatis.sql.insert", sql.toString());
		}
		return;
	}

}
