/**
 * 
 */
package com.efuture.ocp.common.util;

import java.util.Calendar;
import java.util.Date;

/**
 * @author wudong
 * @description 日期工具类
 */
public class DateUtils extends org.apache.commons.lang3.time.DateUtils {
	/**
	 * 得到当前日期 不含时间
	 * 
	 * @return date
	 */
	public static Date gettoday() {
		return trunctoday(new Date());
	}
	/**
	 * 截断日期到天
	 * @param d
	 * @return Date
	 */
	public static Date trunctoday(Date d) {
		return truncate(d, Calendar.DAY_OF_MONTH);
	}
	/**
	 * 得到两个日期之间的天数（包含最后一天）
	 * @param startDate
	 * @param endDate
	 * @return 天数
	 */
	public static long getDaysBetween(Date startDate, Date endDate) {
		return (trunctoday(startDate).getTime() - trunctoday(endDate).getTime())
				/ (1000 * 60 * 60 * 24) + 1;
	}
	/**
	 * 返回日期是星期几
	 * @param date
	 * @return
	 */
	public static long getDayOfWeek(Date date){
		return toCalendar(date).get(Calendar.DAY_OF_WEEK);
	}
}
