package com.efuture.ocp.common.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

public class IniReader
{
    protected HashMap<String, Map<String, String>> sections = new HashMap<String, Map<String, String>>();
    private transient String currentSecion;
    private transient Map<String, String> current;
    private boolean ibinit = false;

    public IniReader()
    {

    }

    public IniReader(String filename) throws IOException
    {
        init(filename);
    }

    public void init(String filename) throws IOException
    {
    	InputStreamReader isr = new InputStreamReader(new FileInputStream(filename), "UTF-8");
    	BufferedReader reader = new BufferedReader(isr);
        //BufferedReader reader = new BufferedReader(new FileReader(filename));
        read(reader);
        reader.close();
        ibinit = true;
    }

    protected void read(BufferedReader reader) throws IOException
    {
        String line;
        while ((line = reader.readLine()) != null)
        {
            parseLine(line);
        }
    }

    protected void parseLine(String line)
    {
        line = line.trim();
        if (line.matches("\\[\\w+\\]"))
        {
            currentSecion = line.replaceFirst("\\[(.*)\\]", "$1");
            current = new HashMap<String, String>();
            sections.put(currentSecion, current);
        }
        else if (line.matches(".*=.*"))
        {
            if (current != null)
            {
                int i = line.indexOf('=');
                String name = line.substring(0, i);
                String value = line.substring(i + 1);
                current.put(name, value);
            }
        }
    }

    public Map<String, String> getsection(String section)
    {
        Map<String, String> p = sections.get(section);
        if (p == null) { return null; }
        return p;

    }

    public String getValue(String section, String name)
    {
        Map<String, String> p = sections.get(section);
        if (p == null) { return null; }
        String value = p.get(name);
        return value;
    }

    public boolean isinit()
    {
        return ibinit;
    }

}
