package com.efuture.ocp.common.util;

import org.springframework.context.ApplicationContext;


/**
 * 保存Spring的上下文
 * @author 肖志文
 *
 */
public class OmcApplicationContext {
	
	private static OmcApplicationContext instance;
	
	/**
	 * 在系统启动时把spring的上下文保存在此处用于后面使用
	 */
	private ApplicationContext context;

	public synchronized static OmcApplicationContext getInstance() {
		if (instance == null) {
			instance = new OmcApplicationContext();
		}
		return instance;
	}

	public void setContext(ApplicationContext context) {
		this.context = context;
	}
	public ApplicationContext getContext() {
		return context;
	}
	public Object getBean(String bean) {
		return context.getBean(bean);
	}
	public <T> T getBean(String bean, Class<T> cls) {
		return context.getBean(bean, cls);
	}
}
