package com.efuture.ocp.common.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;

import javax.annotation.PostConstruct;

import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;

/**
 * 生成唯一序号19位，格式：32位二进制时间(LONG型) + 20位二进制序号(0~999999循环的整数) + 3位十进制整数(机器号)
 * 
 * @author 亮
 * 
 */
public class UniqueID implements InitializingBean{
	/** 序号。范围（0-999999） */
	private static Integer number = new Integer(0);

	/** 机器号 */
	private String hostId = "";

	private  long Starttime = 0;

	@Value("${system.systemstartdate:2018-01-01}")
	public  String systemStartDate = "2018-01-01";

	@Value("${server.port:0000}")
	public  String port="0000";

	/**
	 * 获取ID
	 * 
	 * @return BigDecimal 唯一ID
	 */
	public long getId() {
		synchronized (UniqueID.class) {
			return createId();
		}
	}

	/**
	 * 获取一组ID
	 * 
	 * @param number
	 *            ID个数
	 * @return List<String> 唯一ID
	 */
	public List<Long> getIdArray(int number) {
		List<Long> retArray = new ArrayList<Long>();
		synchronized (UniqueID.class) {
			for (int i = 0; i < number; i++) {
				retArray.add(createId());
			}
		}

		return retArray;
	}

	public List<String> getNoArray(int number, int len) {
		List<String> retArray = new ArrayList<String>();
		synchronized (UniqueID.class) {
			// 时间到毫秒占13位
			StringBuffer sb = new StringBuffer();
			len = len - 13;
			String fmt = "%0" + len + "d";
			for (int i = 0; i < len; i++)
				sb.append("9");
			int sed = Integer.parseInt(sb.toString());
			int sedmod = sed + 1;

			java.security.SecureRandom rand = new java.security.SecureRandom();
			// Random rand = new Random();
			for (int i = 0; i < number; i++) {
				long uid = 0;
				Date dt = new Date();
				uid = dt.getTime();

				Formatter format = new Formatter();
				String suff = format.format(fmt, rand.nextInt(sed) % sedmod).toString();
				retArray.add(String.valueOf(uid) + suff);
			}
		}

		return retArray;
	}
	
	/**
	 * 创建ID
	 * 
	 * @return BigDecimal ID
	 */
	private long createId() {
		long uid = 0;
		Date dt = new Date();
		/*
		 * // 最大ID(7643726453097023999) dt.setYear(300); dt.setMonth(11);
		 * dt.setDate(31); dt.setHours(23); dt.setMinutes(59);
		 * dt.setSeconds(59); number = 999999; hostId = "999";
		 */
		// 时间去掉毫秒(32位二进制整数,可表示到2200/12/31 23:59:59年)
		uid = dt.getTime() / 1000;
		uid = uid - Starttime/1000;
		uid = Long.parseLong(String.valueOf(uid) + hostId);
		//System.out.println(hostId);
		//System.out.println(uid);
		int len = 18 - String.valueOf(uid).length() ;
		//System.out.println(len);
		//System.out.println(number);
		Formatter format = new Formatter();
		String num = format.format("%0"+len+"d", number).toString();
		//System.out.println(num);
		uid = Long.parseLong(String.valueOf(uid) + num);
		number = (number + 1) % 1000000;
		//System.out.println(uid);
//		uid <<= 20;
//		System.out.println(uid);
//		System.out.println(number);
//		// 加上序号(20位二进制整数,最大可表示整数999999)
//		uid += number;
//		number = (number + 1) % 1000000;
//		System.out.println(uid);
//		// 固定用随机数避免重复
//		int n = new Random().nextInt(99) % 1000;
//		Formatter format = new Formatter();
//		String suff = format.format("%02d", n).toString();
		
		return uid;
		/*
		 * // 加上机器号(3位10进制,最大整数999) return
		 * Long.parseLong(String.valueOf(uid)+hostId);
		 */
	}

	public String getHostId() {
		return hostId;
	}


	public void init(){
		if (!StringUtils.isEmpty(hostId) && hostId.length() <= 3 && !hostId.equals("0")) {
			//this.hostId = hostId;
		}
		else
		{
			this.hostId = genHostId();
		}
		
	}
	public void setHostId(String hostId) {
		// 从属性文件读取
		if (!StringUtils.isEmpty(hostId) && (hostId.startsWith("/") || hostId.startsWith("\\"))) {
			try {
				hostId.replace("\\", "/");
				int pos = hostId.lastIndexOf("/");
				String file = hostId.substring(0, pos);
				String key = hostId.substring(pos + 1);

				File input = new File(WebPathUtils.getWebRootPath() + file);
				InputStream is = new FileInputStream(input);
				Properties prop = new Properties();
				prop.load(is);
				is.close();
				hostId = prop.get(key).toString().trim();
			} catch (Exception e) {
				e.printStackTrace();
			}
		}

		// 设置
		

		// 取IP组合成HostId
		if (!StringUtils.isEmpty(hostId) && hostId.length() <= 3) {
			this.hostId = hostId;
		}
//			String ip = getHostIP();
//			if (ip == null)
//				ip = ".000";
//			String suff = new Formatter().format("%03d", Integer.parseInt(ip.substring(ip.lastIndexOf(".") + 1)))
//					.toString();
//			this.hostId += suff.substring(hostId.length());
//		}
//		else
//		{
//			this.hostId = genHostId();
//		}
	}

	private String genHostId() {
		String ip = getHostIP();
		String port = getPort();
		SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
		Date startDate = null;
		try {
			startDate = sd.parse(systemStartDate);
			this.Starttime = startDate.getTime();
			//System.out.println(Starttime);
		} catch (ParseException e) {
			this.Starttime = 1514736000000L;
		}
		Date dt = new Date();
		
		long time = dt.getTime()/1000 - Starttime/1000;
		String md5key = ip + port+time;
		String md5 = DigestUtils.md5Hex(md5key);
		int add = 0;
		byte[] bytes = md5.getBytes();
		for (int i = 0; i < bytes.length; i++) {
			add = add + bytes[i];
		}
		return String.valueOf(add);
	}

	public static String getHostIP() {
		try {
			Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
			while (netInterfaces.hasMoreElements()) {
				NetworkInterface nif = netInterfaces.nextElement();
				Enumeration<InetAddress> iparray = nif.getInetAddresses();
				while (iparray.hasMoreElements()) {
					InetAddress ip = iparray.nextElement();
					if (ip != null) {
						// System.out.println("IP: "+ ip.getHostAddress());
						if (ip instanceof Inet4Address) {
							String localip = ip.getHostAddress();
							if (!"127.0.0.1".equals(localip))
								return ip.getHostAddress();
						}
					}
				}
			}
		} catch (SocketException e) {
			e.printStackTrace();
		}
		return null;
	}

	public static UniqueID getInstance() {
		UniqueID uniqueID = SpringBeanFactory.getBean("UniqueID", UniqueID.class);
		return uniqueID;
	}

	public static long getUniqueID() {
		return getInstance().getId();
	}

	public static List<Long> getUniqueIDArray(int size) {
		return getInstance().getIdArray(size);
	}

	public static List<String> getUniqueNoArray(int size, int len) {
		return getInstance().getNoArray(size, len);
	}

	public static long getTime() {
//		SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
//		Date startDate = null;
//		try {
//			startDate = sd.parse("2008-01-01");
//		} catch (ParseException e) {
//			// TODO Auto-generated catch block
//			e.printStackTrace();
//		}
//		Date dt = new Date();
//		long end = dt.getTime() / 1000;
//		long start = startDate.getTime() / 1000;
//		System.out.println("时间："+(end - start));
//		String ip = getHostIP();
//		String port = getPort();
//		System.out.println(ip);
//		System.out.println(port);
//		String[] ips = ip.split(".");
//		// int v = Integer.valueOf(ips[2])*Integer.valueOf(ips[3]);
//		String md5key = ip + port;
//		System.out.println(md5key);
//		String md5 = DigestUtils.md5Hex(md5key);
//		System.out.println(md5);
//		int add = 0;
//		byte[] bytes = md5.getBytes();
//		for (int i = 0; i < bytes.length; i++) {
//
//			System.out.println(bytes[i]);
//			add = add + bytes[i];
//		}
//
//		System.out.println(add);
//		// ea1d943519b51fa886dfe48607dff641
//		return end - start;
		return 0;
	}

	/* 获取当前PID下绑定的所有IP和端口信息 */
	public  String getPort() {
		if (port.equalsIgnoreCase("0000")) {
			String pid = getPid();
			return getPort(pid);
		} else {
			return port;
		}

	}

	public static String getPort(String pid) {
		BufferedReader buffereReader = null;
		Process process = null;
		String port = "0";
		try {
			if (getOs().indexOf("window") != -1) {
				String cmd = "cmd /c netstat -anop TCP|findstr \"" + pid + "\"";
				process = Runtime.getRuntime().exec(cmd);
				if (process.waitFor() != 0) {
					System.out.println("警告:执行netstat命令失败pid-IP");
					return "0";
				}
				buffereReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
				String line;
				while ((line = buffereReader.readLine()) != null) {
					line = line.trim();
					String[] st = line.split("[\\s]{1,}");
					if (st.length != 5)
						continue;
					int idx = st[1].lastIndexOf(":");
					if (idx == -1)
						continue;
					String _port = st[1].substring(idx + 1);
					if (pid.equals(st[4]))
						// ips.put(st[1], _port);
						port = _port;
				}

			} else {/* Linux Unix */
				String[] cmds = { "/bin/sh", "-c", "netstat -tlnp|grep \"" + pid + "\"" };
				process = Runtime.getRuntime().exec(cmds);
				if (process.waitFor() != 0) {
					System.out.println("警告:执行netstat命令失败pid-IP");
					return "0";
				}
				buffereReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
				String line;
				while ((line = buffereReader.readLine()) != null) {
					line = line.trim();
					String[] st = line.split("[\\s]{1,}");
					if (st.length != 7)
						continue;
					int idx = st[3].lastIndexOf(":");
					if (idx == -1)
						continue;
					String _port = st[3].substring(idx + 1);
					idx = st[6].indexOf("/");
					String _pid = st[6];
					if (idx != -1)
						_pid = _pid.substring(0, idx);
					if (pid.equals(_pid))
						// ips.put(st[3], _port);
						port = _port;
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			try {
				if (buffereReader != null)
					buffereReader.close();
			} catch (Exception e1) {
			}
			buffereReader = null;
			process = null;
		}
		//System.out.println("当前port:" + port);
		return port;
	}

	/* 根据PID获取该PID下绑定的所有IP和端口信息 */
	public static Map<String, String> getIp(String pid) {
		BufferedReader buffereReader = null;
		Process process = null;
		Map<String, String> ips = new HashMap<String, String>();
		try {
			if (getOs().indexOf("window") != -1) {
				String cmd = "cmd /c netstat -anop TCP|findstr \"" + pid + "\"";
				process = Runtime.getRuntime().exec(cmd);
				if (process.waitFor() != 0) {
					System.out.println("警告:执行netstat命令失败pid-IP");
					return ips;
				}
				buffereReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
				String line;
				while ((line = buffereReader.readLine()) != null) {
					line = line.trim();
					String[] st = line.split("[\\s]{1,}");
					if (st.length != 5)
						continue;
					int idx = st[1].lastIndexOf(":");
					if (idx == -1)
						continue;
					String _port = st[1].substring(idx + 1);
					if (pid.equals(st[4]))
						ips.put(st[1], _port);
				}

			} else {/* Linux Unix */
				String[] cmds = { "/bin/sh", "-c", "netstat -tlnp|grep \"" + pid + "\"" };
				process = Runtime.getRuntime().exec(cmds);
				if (process.waitFor() != 0) {
					System.out.println("警告:执行netstat命令失败pid-IP");
					return ips;
				}
				buffereReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
				String line;
				while ((line = buffereReader.readLine()) != null) {
					line = line.trim();
					String[] st = line.split("[\\s]{1,}");
					if (st.length != 7)
						continue;
					int idx = st[3].lastIndexOf(":");
					if (idx == -1)
						continue;
					String _port = st[3].substring(idx + 1);
					idx = st[6].indexOf("/");
					String _pid = st[6];
					if (idx != -1)
						_pid = _pid.substring(0, idx);
					if (pid.equals(_pid))
						ips.put(st[3], _port);
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			try {
				if (buffereReader != null)
					buffereReader.close();
			} catch (Exception e1) {
			}
			buffereReader = null;
			process = null;
		}
		System.out.println("当前port:" + ips);
		return ips;
	}

	private static String PID = null;

	/* 得到当前java PID */
	public static String getPid() {
		if (PID == null) {
			try {
				RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
				System.out.println(runtime.getInputArguments());
				String name = runtime.getName(); // format: "pid@hostname"
				PID = name.substring(0, name.indexOf('@'));
			} catch (Throwable e) {
				System.out.println("警告:无法获取当前进程号");
				e.printStackTrace();
				PID = "-1";
			}
		}
		System.out.println("当前cpid:" + PID);
		return PID;
	}

	private static String OS = null;

	/* 得到操作系统类型 */
	public static String getOs() {
		if (OS == null) {
			OS = System.getProperty("os.name").toLowerCase();
		}
		return OS;
	}

	@Override
	public void afterPropertiesSet() throws Exception {
		init();
	}

	

}
