/**
 * Copyright (C), 2007-2014, eFuture 北京富基融通科技有限公司
 * FileName:	Utils.java
 * Author:		亮
 * Date:		2014-3-25 上午9:34:23
 * Description:	
 * History:
 * <author>		<time>			<version>		<description>
 * 
 */
package com.efuture.ocp.common.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.servlet.ServletContext;
import javax.ws.rs.core.HttpHeaders;

import org.springframework.util.StringUtils;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.WebApplicationContext;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.language.ResponseCode;

/**
 * @author 亮
 * @description
 * 
 */
public class Utils {
	private final static String CR = " \n          at ";
	private static boolean isDetailException = false;
	private static int detailDepth = 99;
	static {
		WebApplicationContext cont = ContextLoader.getCurrentWebApplicationContext();
		if (cont != null) {
			ServletContext sc = cont.getServletContext();
			if (sc != null) {
				String s = sc.getInitParameter("detailException");
				if (!StringUtils.isEmpty(s)) {
					if ("true".equalsIgnoreCase(s)) {
						isDetailException = true;
						detailDepth = 99;
					} else if (Pattern.compile("[0-9]*").matcher(s).matches()) {
						isDetailException = true;
						detailDepth = Integer.parseInt(s);
					}
				}
			}
		}
	}

	public static String getLastExceptionMessage(Exception e) {
		return getLastExceptionMessage(e, isDetailException);
	}

	protected static String getLastExceptionMessage(Exception e, boolean all) {
		// 找到最后一个引起异常的原因
		Throwable t = e;
		if (e instanceof InvocationTargetException) {
			t = ((InvocationTargetException) e).getTargetException();
			e = (Exception) t;
		}

		do {
			t = t.getCause();
		} while (t != null && t.getCause() != null);
		if (t == null)
			t = e;

		String errmsg = t.getClass().getName() + ": " + t.getMessage();
		StackTraceElement[] stes = t.getStackTrace();
		if (stes != null && stes.length > 0) {
			errmsg += CR + stes[0].toString();
			if (all) {
				StringBuffer sb = new StringBuffer();
				for (int i = 1; i < stes.length && i < detailDepth; i++)
					sb.append(CR + stes[i].toString());
				errmsg += sb.toString();
			} else {
				// 找到由com.efuture引起的异常点,进行省略提示
				String privmsg = null;
				String currmsg = null;
				for (int i = 1; i < stes.length; i++) {
					privmsg = stes[i - 1].toString();
					if (stes[i].toString().indexOf("com.efuture.") >= 0) {
						if (i == 1)
							privmsg = null;
						currmsg = stes[i].toString();
						break;
					}
				}
				if (currmsg != null) {
					if (privmsg != null)
						errmsg += CR + "..." + CR + privmsg;
					errmsg += CR + currmsg;
				}
			}
		}

		return errmsg;
	}

	public static Object toNormalJSONObject(Object data) {
		JSONObject jsondata = null;

		// 先把对象转为JSONObject
		if (data instanceof JSONObject)
			jsondata = ((JSONObject) data);
		else {
			try {
				jsondata = JSON.parseObject(JSON.toJSONStringWithDateFormat(data, "yyyy-MM-dd HH:mm:ss"));
			} catch (Exception ex) {
				return data;
			}
		}

		// 再把Long型数据转为String,供前端JS使用,否则JS会丢失数据
		Set<String> keys = jsondata.keySet();
		for (String key : keys) {
			if (jsondata.get(key) instanceof Long) {
				jsondata.put(key, String.valueOf(jsondata.getLong(key)));
			} else if (jsondata.get(key) instanceof JSONObject) {
				jsondata.put(key, toNormalJSONObject(jsondata.getJSONObject(key)));
			} else if (jsondata.get(key) instanceof JSONArray) {
				JSONArray array = jsondata.getJSONArray(key);
				for (int i = 0; i < array.size(); i++) {
					Object o = array.get(i);
					if (o instanceof Long)
						array.set(i, String.valueOf(o));
					else if (o instanceof JSONObject)
						array.set(i, toNormalJSONObject(o));
				}
			}
		}
		return jsondata;
	}

	public static boolean stringArrayContainsKey(String[] array, String key, boolean ignoreCase) {
		if (array == null)
			return false;

		for (String k : array) {
			if (ignoreCase) {
				if (key.equalsIgnoreCase(k))
					return true;
			} else {
				if (key.equals(k))
					return true;
			}
		}

		return false;
	}
	public static boolean stringArrayIncludeKey(String[] array, String key, boolean ignoreCase) {
		if (array == null)
			return false;

		for (String k : array) {
			if (ignoreCase) {
				if (key.toUpperCase().indexOf(k.toUpperCase()) >= 0)
					return true;
			} else {
				if (key.indexOf(k) >= 0 )
					return true;
			}
		}

		return false;
	}

	public static String builderContentDispositionFileName(HttpHeaders headers, String filename) {
		String contentDisposition = "attachment;";
		try {
			// Firefox需要对中文文件名进行编码
			String browser = headers.getRequestHeader(HttpHeaders.USER_AGENT).toString();
			if (browser != null && browser.toLowerCase().indexOf("firefox") > 0)
				contentDisposition += "filename*=UTF-8''" + URLEncoder.encode(filename, "UTF-8");
			else
				contentDisposition += "filename=" + URLEncoder.encode(filename, "UTF-8");
		} catch (Exception ex) {
			contentDisposition += "filename=" + filename;
		}
		return contentDisposition;
	}

	/**
	 * 判断第一个参数是否为空,如果空则返回第二个参数，不为空返回第一个参数 参数类型和返回值类型必须保持一致
	 * 
	 * @param str
	 * @param rtn
	 * @return
	 */
	public static <T> T nvl(T str, T rtn) {
		return StringUtils.isEmpty(str) ? rtn : str;
	}
	
	public static String  nvl(Object str, String rtn) {
		return StringUtils.isEmpty(str) ? rtn : str.toString();
	}
	/**
	 * 把日期的时间部分去掉
	 * 
	 * @param d
	 * @return
	 */
	public static Date trunc(Date d) {
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		try {
			return sdf.parse(sdf.format(d));
		} catch (ParseException e) {
			return null;
		}

	}

	/**
	 * 返回
	 * 
	 * @param src
	 * @return
	 */
	public static String getMethodName(String src) {
		if (src != null) {
			StringBuffer sb = new StringBuffer(src);
			sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
			return "get" + sb.toString();
		} else {
			return null;
		}
	}

	/**
	 * 根据传入的字段列表，取bean的值，用json返回
	 * 
	 * @param bean
	 * @param fields
	 * @return
	 * @throws IllegalAccessException
	 * @throws IllegalArgumentException
	 * @throws InvocationTargetException
	 * @throws NoSuchMethodException
	 * @throws SecurityException
	 */
	public static JSONObject filterBeanField(Object bean, String fields, JSONObject json) throws IllegalAccessException,
			IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
		if (json == null) {
			json = new JSONObject();
		}
		List<String> fieldlist = Arrays.asList(fields.split(","));

		Field[] fds = bean.getClass().getDeclaredFields();
		String key;
		for (Field field : fds) {
			key = field.getName();
			if (!fieldlist.contains(key))
				continue;
			json.put(key, bean.getClass().getMethod(getMethodName(key), null).invoke(bean, null));
		}
		return json;
	}

	public static JSONObject filterBeanField(Object bean, String fields) throws IllegalAccessException,
			IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
		JSONObject json = new JSONObject();
		return filterBeanField(bean, fields, json);
	}

	public static Object getParamWithCheck(JSONObject param, String key, boolean checknull, Object defaultVal) throws Exception
    {
        if (!param.containsKey(key) || StringUtils.isEmpty(param.get(key)))
        {
            if (checknull)
            {
                throw new ServiceException(ResponseCode.FAILURE, "【{0}】 is Null", key);
            }
            else
            {
                return defaultVal;
            }
        }
        return param.get(key);
    }
	
	public static String getEnvValue(String keySource) {
		String keyData = keySource.toString();

		int startPos = keyData.indexOf("${");
		if (startPos >= 0) {
			final Pattern pattern = Pattern.compile("(\\$\\{[^>]*?\\})");
			StringBuffer buffer = new StringBuffer();

			Matcher matcher = pattern.matcher(keyData);
			while (matcher.find()) {
				String findKey = matcher.group();
				String dataKey = findKey.replaceAll("\\$\\{", "").replaceAll("\\}", "");
				// 获取环境变量
				//String dataNew = env.getProperty(dataKey);
				String dataNew = System.getenv(dataKey);
				if (!StringUtils.isEmpty(dataNew)) {
					matcher.appendReplacement(buffer, dataNew.toString());
				}
			}
			matcher.appendTail(buffer);
			return buffer.toString();
		}

		return keySource;
	}
	
}
