package com.efuture.ocp.common.util;

import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

import com.efuture.ocp.common.util.SpringBeanFactory;


/**
 * 注册spring应用程序上下文
 * @author 肖志文
 *
 */
@Component
public class OcpApplicationContextRegister implements ApplicationContextAware {
	public void setApplicationContext(ApplicationContext context) {
		if (OcpApplicationContext.getInstance().getContext() == null) {
			System.out.println("开始注册ocp上下文......");
			OcpApplicationContext.getInstance().setContext(context);
			SpringBeanFactory.setContext(context);
		}
	}
}
