package com.efuture.ocp.common.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.*;
import java.util.Map.Entry;

import javax.servlet.http.HttpServletRequest;

import org.springframework.util.StringUtils;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.rest.ServiceVersion;

/**
 * @author 穆轩 用于多种签名方法的封装
 * @date 2018/02/13
 */
public class SignUtils {

    private static final String ENABLEDEBUG = "Y";

    public static String getToken(String serviceName, String paraList, String secret) {
        return MD5Utils.MD5(serviceName.concat(paraList).concat(secret));
    }
    public static String getJSONValueList_add(JSONObject json, String charset) throws IOException {
        StringBuffer sb = new StringBuffer();
        for (Entry<String, Object> keyVal : json.entrySet()) {
        	sb.append(keyVal.getValue().toString());
        	sb.append(",");
        }
        return sb.toString();
    }
    public static String getParaMapSignModeG(JSONObject jsonparam, String charset, String secret, String debugStatus)
            throws IOException {
        StringBuilder sb = new StringBuilder(secret);
        sb.append(getJSONValueList_add(jsonparam, charset));
        sb.deleteCharAt(sb.length()-1);
        sb.append(secret);
        byte[] bytes = MD5Utils.encryptMD5(sb.toString().getBytes(charset));
        String signKey = MD5Utils.byte2hex(bytes);

        if (ENABLEDEBUG.equalsIgnoreCase(debugStatus)) {
            ServiceVersion.getInstance().debugLog("SignStr=".concat(sb.toString()));
            ServiceVersion.getInstance().debugLog("SignKey=".concat(signKey));
        }
        return signKey;
    }
    public static String getParaMapSignModeA(JSONObject jsonparam, String charset, String secret, String debugStatus)
            throws IOException {
        StringBuilder sb = new StringBuilder(secret);
        sb.append(getParamStrFromMapModeA(getJSONMap(jsonparam, charset)));
        sb.append(secret);
        byte[] bytes = MD5Utils.encryptMD5(sb.toString().getBytes(charset));
        String signKey = MD5Utils.byte2hex(bytes);

        if (ENABLEDEBUG.equalsIgnoreCase(debugStatus)) {
            ServiceVersion.getInstance().debugLog("SignStr=".concat(sb.toString()));
            ServiceVersion.getInstance().debugLog("SignKey=".concat(signKey));
        }
        return signKey;
    }

    public static String getParaMapSignModeB(JSONObject jsonparam, String charset, String secret, String debugStatus)
            throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(getParamStrFromMapModeB(getJSONMap(jsonparam, charset)));
        sb.append("&key=".concat(secret));
        byte[] bytes = MD5Utils.encryptMD5(sb.toString().getBytes(charset));
        String signKey = MD5Utils.byte2hex(bytes);

        if (ENABLEDEBUG.equalsIgnoreCase(debugStatus)) {
            ServiceVersion.getInstance().debugLog("SignStr=".concat(sb.toString()));
            ServiceVersion.getInstance().debugLog("SignKey=".concat(signKey));
        }
        return signKey;
    }

    public static String urlToJson(String input, String encoding) throws UnsupportedEncodingException {
        String[] inputs = input.split("&");
        JSONObject json = new JSONObject();
        for (int i = 0; i < inputs.length; i++) {
            String[] keyVal = inputs[i].split("=");
            json.put(keyVal[0], URLDecoder.decode(keyVal[1], encoding));
        }
        if (StringUtils.isEmpty(json)) {
            return null;
        } else {
            return json.toJSONString();
        }
    }

    public static Map<String, String> urlToMap(String input, String encoding) throws UnsupportedEncodingException {
        String[] inputs = input.split("&");
        Map<String, String> result = new HashMap<String, String>();
        for (int i = 0; i < inputs.length; i++) {
            String[] keyVal = inputs[i].split("=");
            result.put(keyVal[0], URLDecoder.decode(keyVal[1], encoding));
        }
        return result;
    }

    public static Map<String, String> getQueryMap(HttpServletRequest request, String charset) throws IOException {
        Map queryMap = new HashMap();
        String queryString = request.getQueryString();
        String[] params = queryString.split("&");
        for (int i = 0; i < params.length; i++) {
            String[] kv = params[i].split("=");
            if (kv.length == 2) {
                String key = URLDecoder.decode(kv[0], charset);
                String value = URLDecoder.decode(kv[1], charset);
                queryMap.put(key, value);
            } else if (kv.length == 1) {
                String key = URLDecoder.decode(kv[0], charset);
                queryMap.put(key, "");
            }
        }
        return queryMap;
    }

    public static Map<String, String> getFormMap(HttpServletRequest request, Map<String, String> queryMap)
            throws IOException {
        Map formMap = new HashMap();
        Set keys = request.getParameterMap().keySet();
        for (Iterator it = keys.iterator(); it.hasNext();) {
            Object tmp = it.next();
            String key = String.valueOf(tmp);
            if (!queryMap.containsKey(key)) {
                String value = request.getParameter(key);
                if (StringUtils.isEmpty(value))
                    formMap.put(key, "");
                else {
                    formMap.put(key, value);
                }
            }
        }
        return formMap;
    }

    public static Map<String, Object> getJSONMap(JSONObject json, String charset) throws IOException {
        Map jsonMap = new HashMap();
        for (Entry<String, Object> keyVal : json.entrySet()) {
            jsonMap.put(keyVal.getKey(), keyVal.getValue().toString());
        }
        return jsonMap;
    }

    private static String getParamStrFromMapModeA(Map<String, Object> params) {
        StringBuilder sb = new StringBuilder();
        if ((params != null) && (!params.isEmpty())) {
            String[] keys = (String[]) params.keySet().toArray(new String[0]);
            Arrays.sort(keys);
            for (int i = 0; i < keys.length; i++) {
                String name = keys[i];
                if (!"sign".equals(name)) {
                    sb.append(name);
                    sb.append((String) params.get(name));
                }
            }
        }
        return sb.toString();
    }

    private static String getParamStrFromMapModeB(Map<String, Object> params) {
        StringBuilder sb = new StringBuilder();
        if ((params != null) && (!params.isEmpty())) {
            String[] keys = (String[]) params.keySet().toArray(new String[0]);
            Arrays.sort(keys);
            for (int i = 0; i < keys.length; i++) {
                String name = keys[i];
                if (!"sign".equals(name)) {
                    if (sb.length() > 0) {
                        sb.append("&");
                    }
                    sb.append(name);
                    sb.append("=");
                    sb.append((String) params.get(name));
                }
            }
        }
        return sb.toString();
    }


    private static Map<String, Object> sortMapByKey(Map<String, Object> map) {
        if (map != null && !map.isEmpty()) {
            Map<String, Object> sortMap = new TreeMap(Comparator.naturalOrder());
            sortMap.putAll(map);
            return sortMap;
        } else {
            return null;
        }
    }
    private static String getSignContent(Map<String, Object> map) {
        String content = "";
        Map<String, Object> sortMap = sortMapByKey(map);
        String value;
        if (sortMap != null && !sortMap.isEmpty()) {
            for(Iterator var3 = sortMap.entrySet().iterator(); var3.hasNext(); content = content + value) {
                Entry<String, Object> entry = (Entry)var3.next();
                value = entry.getValue() != null ? String.valueOf(entry.getValue()).trim() : "";
            }
        }

        return content;
    }
    public static String getAeonCNSign(JSONObject param, String salt, Integer times, boolean debug) throws Exception {
        Map<String, Object> map = SignUtils.getJSONMap(param, "UTF-8" );
        String content = getSignContent(map);
        String sign = null;
        if (content != null && content.length() > 0) {
            if (debug)
            {
                ServiceVersion.getInstance().debugLog("Content=".concat(content));
            }
            sign = MD5Utils.MD5( content, salt, times ).toLowerCase();
        }

        return sign;
    }



}
