package com.efuture.ocp.common.util;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UUID {
	public static void main(String[] args) throws Exception {


//		logger.info(String.valueOf(Long.MAX_VALUE) + ":" + String.valueOf(Long.MAX_VALUE).length());
//		logger.info(format("", 3) + "-" + format("199990", 4) + "-" + format("808", 4));
		//logger.info("selfid=" + selfId());

//		logger.info(String.valueOf(isInternalIp("172.17.1.1")));

		
		logger.info("orders:" + UUID.getId("orders"));
		int THREADS_CONUT = 3;
		Thread[] threads = new Thread[THREADS_CONUT];
		for (int i = 0; i < THREADS_CONUT; i++) {
			threads[i] = new Thread(new Runnable() {
				@Override
				public void run() {
					//logger.info(String.valueOf(new Date()));
					for (int i = 0; i < 100; i++) {
						String id = UUID.getId("orders");            //不带
						logger.info(Thread.currentThread().getName() + ":" + id);
					}
					//logger.info(String.valueOf(new Date()));
				}
			});
			threads[i].setName(String.format("%02d", i));
			threads[i].start();
		}
		try {
			Thread.sleep(1000);
		} catch (InterruptedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		while (true) {
			logger.info("等待输入11:");
			char val = (char) System.in.read();
			if (val == 'e')
				break;
		}
		//logger.info(UUID.getStart());
		logger.info("A");
	}
	
	private static class Logger {
		public void info(String msg) {
		    int level = 1;
		    StackTraceElement[] stacks = new Throwable().getStackTrace();
		    int line = stacks[level].getLineNumber();
			System.out.println(String.format("%4d-%s", line, msg));
		}
		public void warn(String msg) {
		    int level = 1;
		    StackTraceElement[] stacks = new Throwable().getStackTrace();
		    int line = stacks[level].getLineNumber();
			System.out.println(String.format("%4d-%s", line, msg));
		}
	}
	/**
	 * 获取异常中的所有信息
	 * 
	 * @param t
	 * @return
	 */
	public static String getTrace(Throwable t) {
		StringWriter stringWriter = new StringWriter();
		PrintWriter writer = new PrintWriter(stringWriter);
		t.printStackTrace(writer);
		StringBuffer buffer = stringWriter.getBuffer();
		return buffer.toString();
	}
	private static Logger logger = new Logger();
	
	private static Map<String, String> IPS = new HashMap<String, String>();

	private static String port    = "";
	private static String ipAddr0 = "000";
	private static String ipAddr1 = "000";
	private static String ip = "";
	private static Map<String, SnoBean> allIds = new HashMap<String, SnoBean>();
	private static String sid = null;
	private static List<String> envAppid = new ArrayList<String>(){
	private static final long serialVersionUID = -8526509897241940795L;
	{
		add("OCMOMP_APPID");
		add("EFUTURE_APPID");
	}};
	private static List<String> envPrefix = new ArrayList<String>(){
	private static final long serialVersionUID = -8526509897241940796L;
	{
		add("OCMOMP_APPID_PREFIX");
		add("EFUTURE_APPID_PREFIX");
	}};	
	
	public static String getId(final String key) {
		SnoBean uid = allIds.get(key);
		if (uid == null) {
			synchronized (allIds) {
				uid = allIds.get(key);
				if (uid == null) {
					uid = initId();
					allIds.put(key, uid);
					logger.info("开始uuid:" + key + "=" + uid.value());
				}
			}
		}
		return uid.value();
	}
	private static SnoBean initId() {
		String sid = getSid();
		SnoBean sno = new SnoBean(sid, "yyMMddHHmmssSSS");
		return sno;
	}
	public static String getSid() {
		if (sid != null) {
			return sid;
		}
		for(String key : envAppid) {
			String val = System.getProperty(key);
			if (val == null) {
				val = System.getenv(key);
			}
			if (val == null) continue;
			val = val.trim();
			if (val.length() > 3) sid = val.substring(val.length() - 4);
			else {
				int i = 4 - val.length();
				for(int j = 0; j < i; i++) {
					val = "0" + val;
				}
			}
			sid = val;
			return sid;
		}
		String port = getPort();
		String skey = null;
		for(String key : envPrefix) {
			skey = System.getProperty(key);
			if (skey == null) {
				skey = System.getenv(key);
			}
			if (skey == null) continue;
			skey = skey.trim();
		}
		if (skey == null) skey = "";
		String[] addr = getIpAddr(skey);
		
		if (port == null || "".equals(port)) port = addr[1].substring(addr[1].length() - 1);
		else port = port.substring(port.length() - 1);//最后一位
		sid = addr[2] + port;
		logger.warn("efuture sid:[" + sid + "]");
		return sid;
	}
	
	private static String getPort() {
		String path = getPath();
//		try {
//			path = Thread.currentThread().getContextClassLoader().getResource("").getPath();
//			path = URLDecoder.decode(path, "UTF-8");
//		} catch (Exception e) {
//			logger.error("获取app运行路径失败[" + path + "]:" + getTrace(e));
//			path = null;
//		}
		String regex = "\\d+";
		Pattern pattern = Pattern.compile(regex);
		Matcher matcher = pattern.matcher(path);
		while (matcher.find()) {
			String s = matcher.group();
			if (s.length() > 3) {
				port = matcher.group();// 匹配最后的数字
			}
		}
		if (port != null && port.length() > 3) {
			port = port.substring(port.length() - 4);
		} else {
			port = null;
		}
		logger.warn("efuture port:[" + port + "]");
		return port;
	}
	/**
	 * 获取当前运行路径
	 * @return
	 */
	public static String getPath() {
		// String p1 = UUID.class.getResource("/").getPath();
		
			//String path = ResourceUtils.getURL("classpath:").getPath();
			//String path = UUID.class.getProtectionDomain().getCodeSource().getLocation().getFile();
			//URL url = UUID.class.getProtectionDomain().getCodeSource().getLocation();
			
			//curPath = path; //Thread.currentThread().getContextClassLoader().getResource("").getPath();
		String cpath = null;
			
		ClassLoader cl = getDefaultClassLoader();
		URL url = (cl != null ? cl.getResource("") : ClassLoader.getSystemResource(""));
		File sp = getFile(url);
		File fp = new File(sp.getAbsolutePath());
		while(!fp.exists() || !fp.isDirectory()) {
			fp = fp.getParentFile();
		}
		cpath = fp.getPath();
		cpath = cpath.replace('\\', '/').toLowerCase();
		logger.warn("efuture path:[" + cpath + "]");
		return cpath;
	}
	private static ClassLoader getDefaultClassLoader() {
		ClassLoader cl = null;
		try {
			cl = Thread.currentThread().getContextClassLoader();
		}catch (Throwable ex) {
		}
		if (cl == null) {
			cl = UUID.class.getClassLoader();
			if (cl == null) {
				try {
					cl = ClassLoader.getSystemClassLoader();
				}
				catch (Throwable ex) {
				}
			}
		}
		return cl;
	}
	public static File getFile(URL resourceUrl) {
		try {
			return new File(toURI(resourceUrl).getSchemeSpecificPart());
		}
		catch (URISyntaxException ex) {
			return new File(resourceUrl.getFile());
		}
	}
	private static URI toURI(URL url) throws URISyntaxException {
		return new URI(url.toString().replace(" ", "%20"));
	}

	private static String[] getIpAddr(String prefix) {
		try {
			// InetAddress.getLocalHost().getHostAddress();
			/* 获取所有IP地址 如果存在所需要内网ip就退出了*/ 
			InetAddress lo = InetAddress.getLocalHost();
			if (!lo.isAnyLocalAddress() && !lo.isLoopbackAddress() && lo instanceof Inet4Address) {
				String key = lo.getHostAddress();
				IPS.put(key, lo.getHostName());
				if (key.startsWith(prefix)) {// IPV4 同时内网 
					ip = key; 
				}
			}
		} catch(UnknownHostException  e) {
			logger.warn("警告:getLocalHost系统获取IP地址异常:" + getTrace(e));
		}
		if ("".equals(ip)) {
			try {
				// InetAddress.getLocalHost().getHostAddress();
				/* 获取所有IP地址 如果存在所需要内网ip就退出了*/ 
				Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
		        for (NetworkInterface netint : Collections.list(nets)) {
		        	//去掉虚拟网卡
					if (netint.isLoopback() || !netint.isUp() || netint.isVirtual() || netint.isPointToPoint()) { // || netint.isPointToPoint() (VPN也可以包含在里面)
						continue;
					}
					List<InterfaceAddress> netips = netint.getInterfaceAddresses();
					for(InterfaceAddress addr : netips) {
						InetAddress ia = addr.getAddress();
						if (ia instanceof Inet4Address) {
							String key = ia.getHostAddress();
							IPS.put(key, ia.getHostName());
							if (isInternalIp(key) && key.startsWith(prefix)) {// IPV4 同时内网 
								ip = key; break;
							}
						}
					}
				}
			} catch (java.net.SocketException e) {
				logger.warn("警告:系统获取IP地址异常," + getTrace(e));
			}
		}
		String[] rtn = null, address = null;
		if ("".equals(ip)) {
			IPS.put("127.0.0.1", "localhost");
			IPS.put("0.0.0.0", "localhost");
			
			for (String key : IPS.keySet()) {
				if (isIpv4(key) && isInternalIp(key) && key.startsWith(prefix)) {// IPV4 同时内网
					ip = key; break;
				}
			}
			if ("".equals(ip) || "0.0.0.0".equals(ip)) {
				for (String key : IPS.keySet()) {// 只要是IPV4
					if (isIpv4(key) && key.startsWith(prefix)) {
						ip = key; break;
					}
				}
			}
			if ("".equals(ip)) {
				ip = "127.0.0.1";
			}
		}
		address = ip.split("\\.");
		ipAddr0 = address[3]; ipAddr1= address[2];
		
		rtn = new String[]{ip, String.format("%03d", Integer.parseInt(ipAddr1)), String.format("%03d", Integer.parseInt(ipAddr0))};
		logger.warn("efuture ip 地址["  +  rtn[0] + "], ["+rtn[1] + "], ["+rtn[2] +"]");
		return rtn;
	}
	

	// ipv4是32位地址，分成4段，每段之间都有 "." 分开，而每段之间有8位，从 0 - 255.
	// pv6是128位地址，每个数目等于4位（0-F）16位进制，4个一组，每段之间由 ":"隔开，共有8段
	private static boolean isIpv4(String ip) {
		if (ip.indexOf('.') != -1)
			return true;
		else
			return false;
	}

	private static boolean isInternalIp(String ip) {
		byte[] addr = textToNumericFormatV4(ip);
		return isInternalIp(addr);
	}

	/**
	 * tcp/ip协议中，专门保留了三个IP地址区域作为私有地址，其地址范围如下：
	 * 
	 * 10.0.0.0/8：10.0.0.0～10.255.255.255  172.16.0.0/12：172.16.0.0～172.31.255.255 
	 * 192.168.0.0/16：192.168.0.0～192.168.255.255
	 * 
	 * @param addr
	 * @return
	 */
	private static boolean isInternalIp(byte[] addr) {
		final byte b0 = addr[0];
		final byte b1 = addr[1];
		// 10.x.x.x/8
		final byte SECTION_1 = 0x0A;
		// 172.16.x.x/12
		final byte SECTION_2 = (byte) 0xAC;
		final byte SECTION_3 = (byte) 0x10;
		final byte SECTION_4 = (byte) 0x1F;
		// 192.168.x.x/16
		final byte SECTION_5 = (byte) 0xC0;
		final byte SECTION_6 = (byte) 0xA8;
		switch (b0) {
		case SECTION_1:
			return true;
		case SECTION_2:
			if (b1 >= SECTION_3 && b1 <= SECTION_4) {
				return true;
			}
		case SECTION_5:
			switch (b1) {
			case SECTION_6:
				return true;
			}
		default:
			return false;
		}
	}

	private final static int INADDR4SZ = 4;

	public static byte[] textToNumericFormatV4(String src) {
		if (src.length() == 0) {
			return null;
		}
		byte[] res = new byte[INADDR4SZ];
		String[] s = src.split("\\.", -1);
		long val;
		try {
			switch (s.length) {
			case 1:
				val = Long.parseLong(s[0]);
				if (val < 0 || val > 0xffffffffL)
					return null;
				res[0] = (byte) ((val >> 24) & 0xff);
				res[1] = (byte) (((val & 0xffffff) >> 16) & 0xff);
				res[2] = (byte) (((val & 0xffff) >> 8) & 0xff);
				res[3] = (byte) (val & 0xff);
				break;
			case 2:
				val = Integer.parseInt(s[0]);
				if (val < 0 || val > 0xff)
					return null;
				res[0] = (byte) (val & 0xff);
				val = Integer.parseInt(s[1]);
				if (val < 0 || val > 0xffffff)
					return null;
				res[1] = (byte) ((val >> 16) & 0xff);
				res[2] = (byte) (((val & 0xffff) >> 8) & 0xff);
				res[3] = (byte) (val & 0xff);
				break;
			case 3:
				for (int i = 0; i < 2; i++) {
					val = Integer.parseInt(s[i]);
					if (val < 0 || val > 0xff)
						return null;
					res[i] = (byte) (val & 0xff);
				}
				val = Integer.parseInt(s[2]);
				if (val < 0 || val > 0xffff)
					return null;
				res[2] = (byte) ((val >> 8) & 0xff);
				res[3] = (byte) (val & 0xff);
				break;
			case 4:
				for (int i = 0; i < 4; i++) {
					val = Integer.parseInt(s[i]);
					if (val < 0 || val > 0xff)
						return null;
					res[i] = (byte) (val & 0xff);
				}
				break;
			default:
				return null;
			}
		} catch (NumberFormatException e) {
			e.printStackTrace();
			return null;
		}
		return res;
	}
}

class SnoBean {
	private String prev;
	private AtomicLong val = new AtomicLong(0);
	private DateFormat rule = null;
	private String sid;
	public SnoBean(String sid, String rule) {
		this.rule = new SimpleDateFormat("yyMMddHHmmssSSS");;
		this.sid  = sid;
		Date d    = new Date();
		long cid  = Long.valueOf(this.rule.format(d));
		val       = new AtomicLong(cid);
		SimpleDateFormat sdf0 = new SimpleDateFormat("yyyyMMdd");
		prev = sdf0.format(d);
	}
	public String getPrev() {
		return prev;
	}
	public AtomicLong getVal() {
		return val;
	}
	public String value() {
		SimpleDateFormat sdf0 = new SimpleDateFormat("yyyyMMdd");
		Date d = new Date();
		String cdate = sdf0.format(d);
		if (!cdate.equals(prev)) {
			synchronized(this) {
				Date d0 = new Date();
				cdate = sdf0.format(d0);
				long cid = Long.valueOf(this.rule.format(d0));
				val = new AtomicLong(cid);
				prev = cdate;
			}
		}
		String v = String.valueOf(val.incrementAndGet()) + sid;
		return v;
	}
}