package com.efuture.ocp.common.autorollback;

import org.apache.log4j.Logger;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.stereotype.Component;


@Aspect
@Component
public class AutoRollbackAspect {
	private static final Logger logger = Logger.getLogger(AutoRollbackAspect.class);
	

	@Around("@annotation(around)")
	public Object round(ProceedingJoinPoint point, AutoRollbackAnnotation around) throws Throwable {
		Object result = null;
		
		//判断是否已经存在冲正事物，
		//如果存在，则不在本次方法执行冲正
		//如果不存在，则重新开启一个事物号，在本次方法执行异常时冲正事物

		String name = around.name();
		
		boolean ibhavetrans = false;
		Long transid = AutoRollBackService.gettransid();
		if (transid != null && transid != 0) {
			ibhavetrans = true;
			logger.debug(name+":已经有冲正事物:"+transid);
		} else {
			transid = AutoRollBackService.opentrans();
			logger.debug(name+":开启冲正事物:"+transid);
		}
		try {
			result = point.proceed();
		} catch (Throwable e) {
			logger.debug(name+":执行冲正:"+transid);
			AutoRollBackService.rollback();
			throw e;
		} finally {
			if (!ibhavetrans) {
				logger.debug(name+":执行清理:"+transid);
				AutoRollBackService.clean();
			}
			else
			{
				logger.debug(name+":不是本次事物,不执行清理:"+transid);
			}
			
		}
		return result;
	}
}
