/**
 * Copyright (C), 2007-2015, eFuture 北京富基融通科技有限公司
 * FileName:	BillBaseBean.java
 * Author:		亮
 * Date:		2015-7-14 下午5:00:30
 * Description:	
 * History:
 * <author>		<time>			<version>		<description>
 * 
 */
package com.efuture.ocp.common.billservice;

import java.util.Date;

import javax.validation.constraints.NotNull;

import org.hibernate.validator.constraints.NotEmpty;
import org.springframework.util.StringUtils;

import com.efuture.ocp.common.entity.AbstractEntityBean;
import com.efuture.ocp.common.entity.ServiceSession;

/**
 * @author		亮
 * @description	
 * 
 */
public abstract class BillAbstractHeadBean extends BillAbstractBean
{
    private static final long serialVersionUID = -57293662004962006L;
    
    @NotEmpty
    protected String billno;                              //档期编号
    protected String billsgno;                            //手工单号    
    @NotEmpty
    protected String billmoduleid;                        //模块编号
    @NotEmpty
    protected String billstatus;                          //单据状态

    @NotEmpty
    protected String inputer;                             //录入人 
    protected String inputer_name;                        //录入人名称
    @NotNull
    protected Date inputdate;                             //录入日期
    
    protected String auditor;                             //审核人
    protected String auditor_name;                        //审核人名称
    protected Date auditdate;                             //审核日期
    
    protected String canceler;                            //取消人
    protected String canceler_name;                       //取消人名称
    protected Date canceldate;                            //取消时间
    
    protected String lastmodby;                           //最后修改人
    protected String lastmodby_name;                      //最后修改人名称
    
    /**
     * @return billno
     */
    public String getBillno()
    {
        return billno;
    }
    /**
     * @param billno 要设置的 billno
     */
    public void setBillno(String billno)
    {
        this.billno = billno;
    }
    /**
     * @return billsgno
     */
    public String getBillsgno()
    {
        return billsgno;
    }
    /**
     * @param billsgno 要设置的 billsgno
     */
    public void setBillsgno(String billsgno)
    {
        this.billsgno = billsgno;
    }
    /**
     * @return billmoduleid
     */
    public String getBillmoduleid()
    {
        return billmoduleid;
    }
    /**
     * @param billmoduleid 要设置的 billmoduleid
     */
    public void setBillmoduleid(String billmoduleid)
    {
        this.billmoduleid = billmoduleid;
    }
    /**
     * @return billstatus
     */
    public String getBillstatus()
    {
        return billstatus;
    }
    /**
     * @param billstatus 要设置的 billstatus
     */
    public void setBillstatus(String billstatus)
    {
        this.billstatus = billstatus;
    }
    /**
     * @return inputer
     */
    public String getInputer()
    {
        return inputer;
    }
    /**
     * @param inputer 要设置的 inputer
     */
    public void setInputer(String inputer)
    {
        this.inputer = inputer;
    }
    /**
     * @return inputer_name
     */
    public String getInputer_name()
    {
        return inputer_name;
    }
    /**
     * @param inputer_name 要设置的 inputer_name
     */
    public void setInputer_name(String inputer_name)
    {
        this.inputer_name = inputer_name;
    }
    /**
     * @return inputdate
     */
    public Date getInputdate()
    {
        return inputdate;
    }
    /**
     * @param inputdate 要设置的 inputdate
     */
    public void setInputdate(Date inputdate)
    {
        this.inputdate = inputdate;
    }
    /**
     * @return auditor
     */
    public String getAuditor()
    {
        return auditor;
    }
    /**
     * @param auditor 要设置的 auditor
     */
    public void setAuditor(String auditor)
    {
        this.auditor = auditor;
    }
    /**
     * @return auditor_name
     */
    public String getAuditor_name()
    {
        return auditor_name;
    }
    /**
     * @param auditor_name 要设置的 auditor_name
     */
    public void setAuditor_name(String auditor_name)
    {
        this.auditor_name = auditor_name;
    }
    /**
     * @return auditdate
     */
    public Date getAuditdate()
    {
        return auditdate;
    }
    /**
     * @param auditdate 要设置的 auditdate
     */
    public void setAuditdate(Date auditdate)
    {
        this.auditdate = auditdate;
    }
    /**
     * @return canceler
     */
    public String getCanceler()
    {
        return canceler;
    }
    /**
     * @param canceler 要设置的 canceler
     */
    public void setCanceler(String canceler)
    {
        this.canceler = canceler;
    }
    /**
     * @return canceler_name
     */
    public String getCanceler_name()
    {
        return canceler_name;
    }
    /**
     * @param canceler_name 要设置的 canceler_name
     */
    public void setCanceler_name(String canceler_name)
    {
        this.canceler_name = canceler_name;
    }
    /**
     * @return canceldate
     */
    public Date getCanceldate()
    {
        return canceldate;
    }
    /**
     * @param canceldate 要设置的 canceldate
     */
    public void setCanceldate(Date canceldate)
    {
        this.canceldate = canceldate;
    }
    /**
     * @return lastmodby
     */
    public String getLastmodby()
    {
        return lastmodby;
    }
    /**
     * @param lastmodby 要设置的 lastmodby
     */
    public void setLastmodby(String lastmodby)
    {
        this.lastmodby = lastmodby;
    }
    /**
     * @return lastmodby_name
     */
    public String getLastmodby_name()
    {
        return lastmodby_name;
    }
    /**
     * @param lastmodby_name 要设置的 lastmodby_name
     */
    public void setLastmodby_name(String lastmodby_name)
    {
        this.lastmodby_name = lastmodby_name;
    }
    
    // 新增操作时初始化通用成员方法
    public void initInsertMember(ServiceSession session)
    {
        super.initInsertMember(session);
        
        if (StringUtils.isEmpty(inputer)) this.inputer = session.getUser_code();
        if (StringUtils.isEmpty(inputer_name)) this.inputer_name = "["+session.getUser_code()+"]"+session.getUser_name();
        this.lastmodby = this.inputer;
        this.lastmodby_name = this.inputer_name;
    }

    public void initInsertMember(AbstractEntityBean bean)
    {
        super.initInsertMember(bean);
        
        if (StringUtils.isEmpty(inputer)) this.inputer = ((BillAbstractHeadBean)bean).getInputer();
        if (StringUtils.isEmpty(inputer_name)) this.inputer_name = ((BillAbstractHeadBean)bean).getInputer_name();
        this.lastmodby = this.inputer;
        this.lastmodby_name = this.inputer_name;
    }
       
    // 更新操作时初始化通用成员方法
    public void initUpdateMember(ServiceSession session)
    {
        super.initUpdateMember(session);
        
        if (StringUtils.isEmpty(lastmodby)) this.lastmodby = session.getUser_code();
        if (StringUtils.isEmpty(lastmodby_name)) this.lastmodby_name = "["+session.getUser_code()+"]"+session.getUser_name();
    }
    
    public void initUpdateMember(AbstractEntityBean bean)
    {
        super.initUpdateMember(bean);
        
        if (StringUtils.isEmpty(lastmodby)) this.lastmodby = ((BillAbstractHeadBean)bean).getLastmodby();
        if (StringUtils.isEmpty(lastmodby_name)) this.lastmodby_name = ((BillAbstractHeadBean)bean).getLastmodby_name();
    }
}
