/**
 * Copyright (C), 2007-2015, eFuture 北京富基融通科技有限公司
 * FileName:	TopicHead.java
 * Author:		亮
 * Date:		2015-7-8 下午2:55:15
 * Description:
 * History:
 * <author>		<time>			<version>		<description>
 *
 */
package com.efuture.ocp.common.billservice;

import java.io.FileOutputStream;
import java.text.DateFormat;
import java.util.*;
import java.util.regex.Matcher;

import com.github.pagehelper.PageHelper;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.util.StringUtils;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.component.BasicComponent;
import com.efuture.ocp.common.entity.BeanConstant;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.language.ResponseCode;
import com.efuture.omd.storage.FMybatisTemplate;
import com.efuture.omd.storage.mybatis.HashMapCase;
import com.github.pagehelper.Page;

/**
 * @author 亮
 * @description
 *
 */
public class ReportServiceImpl extends BasicComponent implements ReportService
{
    protected Map<String, String> dbMap;

    public ReportServiceImpl()
    {
    }

    public ReportServiceImpl(Map<String, String> dbMap)
    {
        this.dbMap = dbMap;
    }

    @Override
    public ServiceResponse query(ServiceSession session, JSONObject jsonparam) throws Exception
    {
        return query(session, jsonparam, "report");
    }

    @Override
    public ServiceResponse query(ServiceSession session, JSONObject jsonparam, String datakey) throws Exception
    {
        // 参数检查
        if (session == null) {
            return ServiceResponse.buildFailure(session, ResponseCode.Exception.SESSION_IS_EMPTY);
        }

        if (StringUtils.isEmpty(jsonparam)) {
            return ServiceResponse.buildFailure(session, ResponseCode.Exception.PARAM_IS_EMPTY);
        }

        if (StringUtils.isEmpty(jsonparam.get("queryid"))) {
            return ServiceResponse.buildFailure(session, ResponseCode.EXCEPTION, "{0} {1} is empty", "", "queryid");
        }

        // 分页参数
        int pageno = -1, pagesize = 40;

        if (jsonparam.containsKey(BeanConstant.QueryField.PARAMKEY_PAGENO)
            && !StringUtils.isEmpty(jsonparam.get(BeanConstant.QueryField.PARAMKEY_PAGENO))) {
            pageno = jsonparam.getInteger(BeanConstant.QueryField.PARAMKEY_PAGENO);

            if (pageno <= 0) {
                pageno = 1;
            }

            jsonparam.remove(BeanConstant.QueryField.PARAMKEY_PAGENO);
        }

        if (jsonparam.containsKey(BeanConstant.QueryField.PARAMKEY_PAGESIZE)
            && !StringUtils.isEmpty(jsonparam.get(BeanConstant.QueryField.PARAMKEY_PAGESIZE))) {
            pagesize = jsonparam.getInteger(BeanConstant.QueryField.PARAMKEY_PAGESIZE);

            if (pagesize <= 0) {
                pagesize = 40;
            }

            // if (pagesize > 100) pagesize = 100;
            if (pagesize > 10000) {
                pagesize = 10000;
            }

            jsonparam.remove(BeanConstant.QueryField.PARAMKEY_PAGESIZE);

            if (pageno <= 0) {
                pageno = 1;
            }
        }

        RowBounds rowBounds = null;

        if (pageno >= 1) {
            rowBounds = new RowBounds((pageno - 1) * pagesize, pagesize);
        }

        // 转换查询条件
        Map<String, Object> map = new HashMapCase<String, Object>();
        map.put("ent_id", session.getEnt_id());

        for (String key : jsonparam.keySet()) {
            map.put(key, jsonparam.get(key));
        }

        // 执行SQL查询
        StringBuffer total = new StringBuffer();
        JSONObject json = new JSONObject();
        json.put(datakey, doQuery(jsonparam.getString("queryid"), map, rowBounds, total));

        if (total.toString() != "") {
            json.put("total_results", total.toString());
        }
        else {
            json.put("total_results", "0");
        }

        queryReportSum(session, jsonparam.getString("queryid"), map, json);
        //报表汇总
        getReportTot(session, json, jsonparam, total);
        return ServiceResponse.buildSuccess(json);
    }

    @SuppressWarnings("rawtypes")
    public List<Map<String, Object>> doQuery(String queryid, Object param, RowBounds rowBounds, StringBuffer total)
    {
        FMybatisTemplate storage = null;

        try {
            // 得到数据源
            if (this.dbMap != null && param instanceof Map && ((Map)param).containsKey("business")) {
                String dbkey = this.dbMap.get(((Map)param).get("business").toString());
                storage = getStorageOperations(dbkey, FMybatisTemplate.class);
            }
            else {
                storage = getStorageOperations(FMybatisTemplate.class);
            }

            SqlSessionTemplate db = storage.getSqlSessionTemplate();
            List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();

            // 查询
            if (rowBounds == null) {
                list = db.selectList(queryid, param);
                // total.append(list.size());
                filter(db, queryid, list);
            }
            else {
                // (rowBounds.getOffset()/rowBounds.getLimit()+1,
                // rowBounds.getLimit());
                list = db.selectList(queryid, param, rowBounds);
                filter(db, queryid, list);

                if (total != null) {
                    total.append(((Page) list).getTotal());
                }
            }

            return list;
        }
        finally {
            if (storage != null) {
                storage.destroy();
            }
        }
    }
    public void queryReportSum(ServiceSession session, String queryid, Object param, JSONObject json) throws Exception
    {
        if (param instanceof Map && ((Map)param).containsKey("summary_fld")) {
            String summary_fld = ((Map)param).get("summary_fld").toString();
            String[] summary_flds = summary_fld.split(",");

            if (!StringUtils.isEmpty(summary_fld)) {
                FMybatisTemplate storage = null;

                if (this.dbMap != null && param instanceof Map && ((Map)param).containsKey("business")) {
                    String dbkey = this.dbMap.get(((Map)param).get("business").toString());
                    storage = getStorageOperations(dbkey, FMybatisTemplate.class);
                }
                else {
                    storage = getStorageOperations(FMybatisTemplate.class);
                }

                SqlSessionTemplate db = storage.getSqlSessionTemplate();
                MappedStatement mappedStatement = db.getConfiguration().getMappedStatement(queryid);
                BoundSql boundSql = mappedStatement.getBoundSql(param);
                Configuration configuration = mappedStatement.getConfiguration();
                String sql = showSql(configuration, boundSql);
                String sumcols = sumcol_sql(summary_fld);
                String newsql = "select " + sumcols + " from (" + sql + ") tabsummary";
                Map<String, Object> rs = db.selectOne("mybatis.sql.select", newsql);

                if (!StringUtils.isEmpty(rs)) {
                    JSONObject jsonsum = new JSONObject();

                    for (String fld : summary_flds) {
                        jsonsum.put(fld, rs.get(fld));
                    }

                    if (!StringUtils.isEmpty(jsonsum)) {
                        json.put("total_summary", jsonsum);
                    }
                }
            }
        }
    }
    public void filter(SqlSessionTemplate db, String queryid, List<Map<String, Object>> list)
    {
        //vdict_Ismz_Ismz
        //vfld_spid_name
    }

    public String sumcol_sql(String cols) throws Exception
    {
        String sumcols = "";

        for (String col : cols.split(",")) {
            sumcols += "sum(" + col + ") " + col + ",";
        }

        return sumcols.substring(0, sumcols.length() - 1);
    }

    /**
     * 解析sql语句
     * @param configuration
     * @param boundSql
     * @return
     */
    public String showSql(Configuration configuration, BoundSql boundSql)
    {
        Object parameterObject = boundSql.getParameterObject();
        List<ParameterMapping> parameterMappings = boundSql.getParameterMappings();
        String sql = boundSql.getSql().replaceAll("[\\s]+", " ");

        if (parameterMappings.size() > 0 && parameterObject != null) {
            TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();

            if (typeHandlerRegistry.hasTypeHandler(parameterObject.getClass())) {
                sql = sql.replaceFirst("\\?", Matcher.quoteReplacement(getParameterValue(parameterObject)));
            }
            else {
                MetaObject metaObject = configuration.newMetaObject(parameterObject);

                for (ParameterMapping parameterMapping : parameterMappings) {
                    String propertyName = parameterMapping.getProperty();

                    if (metaObject.hasGetter(propertyName)) {
                        Object obj = metaObject.getValue(propertyName);
                        sql = sql.replaceFirst("\\?", Matcher.quoteReplacement(getParameterValue(obj)));
                    }
                    else if (boundSql.hasAdditionalParameter(propertyName)) {
                        Object obj = boundSql.getAdditionalParameter(propertyName);
                        sql = sql.replaceFirst("\\?", Matcher.quoteReplacement(getParameterValue(obj)));
                    }
                }
            }
        }

        return sql;
    }
    /**
     * 参数解析
     * @param obj
     * @return
     */
    private String getParameterValue(Object obj)
    {
        String value = null;

        if (obj instanceof String) {
            value = "'" + obj.toString() + "'";
        }
        else if (obj instanceof Date) {
            DateFormat formatter = DateFormat.getDateTimeInstance(DateFormat.DEFAULT, DateFormat.DEFAULT, Locale.CHINA);
            value = "'" + formatter.format((Date)obj) + "'";
        }
        else {
            if (obj != null) {
                value = obj.toString();
            }
            else {
                value = "";
            }
        }

        return value;
    }
    protected void getReportTot(ServiceSession session, JSONObject json, JSONObject jsonparam, StringBuffer total)
    {
        try {
            if (!StringUtils.isEmpty(jsonparam.get("tot_cols")) && !StringUtils.isEmpty(jsonparam.get("tot_queryid"))) {
                String tot_cols = jsonparam.getString("tot_cols");
                jsonparam.put("tot_cols", sumcol_sql(tot_cols));
                // 转换查询条件
                Map<String, Object> map = new HashMapCase<String, Object>();
                map.put("ent_id", session.getEnt_id());

                for (String key : jsonparam.keySet()) {
                    map.put(key, jsonparam.get(key));
                }

                List<Map<String, Object>> tot_row = doQuery(jsonparam.getString("tot_queryid"), map,
                                                    new RowBounds(0, 100), total);

                if (tot_row.size() > 0) {
                    Map<String, Object> row = tot_row.get(0);

                    for (String key : tot_cols.split(",")) {
                        json.put(key, row.get(key));
                    }
                }
            }
        }
        catch (Exception e) {
        }
    }

    // 导出
    @Override
    public String export(ServiceSession session, JSONObject jsonparam) throws Exception
    {
        // 参数检查
        if (session == null) {
            throw new ServiceException(ResponseCode.Exception.SESSION_IS_EMPTY, "session is empty");
        }

        if (StringUtils.isEmpty(jsonparam)) {
            throw new ServiceException(ResponseCode.Exception.PARAM_IS_EMPTY, "param is empty");
        }

        // 导出必须指定字段
        if (StringUtils.isEmpty(jsonparam.get(BeanConstant.QueryField.PARAMKEY_FIELDS))) {
            throw new ServiceException(ResponseCode.EXCEPTION, "{0} {1} is empty", "",
                                       BeanConstant.QueryField.PARAMKEY_FIELDS);
        }

        // 解析字段名
        // fields="fld1:XXXX:fmt,fld2:XXXXX:fmt,fld3:XXXXX:fmt";
        StringBuffer flds = new StringBuffer();
        List<String> fldlst = new ArrayList<String>();
        Map<String, String> disps = new HashMap<String, String>();
        Map<String, String> fmts = new HashMap<String, String>();
        analyzeExportFields(jsonparam.getString(BeanConstant.QueryField.PARAMKEY_FIELDS), flds, fldlst, disps, fmts);
        jsonparam.put(BeanConstant.QueryField.PARAMKEY_FIELDS, flds.toString());
        // 查询全部数据导出
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("ent_id", session.getEnt_id());

        for (String key : jsonparam.keySet()) {
            map.put(key, jsonparam.get(key));
        }

        List<Map<String, Object>> list = doQuery(jsonparam.getString("queryid"), map, null, null);
        // 记录日志
        createExportLog(session, jsonparam.toJSONString(), jsonparam.getString("modulecode"), "export.xls", list.size());
        // 生成XLS文件的XML
        return createExportXLS(list, fldlst, disps, fmts);
    }

    // 导出日志
    public void createExportLog(ServiceSession session, String param, String modulecode, String fileName, long dataNum)
    throws Exception
    {
        String token = session.getToken();
        String userid = "";
        String usercode = "";
        String postid = "";

        if (!StringUtils.isEmpty(token)) {
            try {
                if (!StringUtils.isEmpty(Long.toString(session.getUser_id()))) {
                    userid = Long.toString(session.getUser_id());
                }

                if (!StringUtils.isEmpty(session.getUser_code())) {
                    usercode = session.getUser_code();
                }

                if (!StringUtils.isEmpty(session.getPostid())) {
                    postid = session.getPostid();
                }

                Map<String, Object> exportlog = new HashMap<String, Object>();
                exportlog.put("opdate", new Date());
                exportlog.put("userid", userid);
                exportlog.put("usercode", usercode);
                exportlog.put("postid", postid);
                exportlog.put("moduleid", modulecode);
                exportlog.put("param", param);
                exportlog.put("total", dataNum);
                exportlog.put("expfilename", fileName);
                logger.info(exportlog.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public long count(String statement, Object parameter)
    {
        Page page = PageHelper.startPage(1, -1);
        List<Map<String, Object>> list = doQuery(statement, parameter, null, null);

        long count = page.getTotal();
        return count;
    }
}
